/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adkernel;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adkernel.ExtImpAdkernel;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

public class AdkernelBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdkernel>> ADKERNEL_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpAdkernel>>(){};
    private final String endpointTemplate;
    private final JacksonMapper mapper;

    public AdkernelBidder(String endpointTemplate, JacksonMapper mapper) {
        this.endpointTemplate = HttpUtil.validateUrl(Objects.requireNonNull(endpointTemplate));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        HashMap<ExtImpAdkernel, List<Imp>> pubToImps = new HashMap<ExtImpAdkernel, List<Imp>>();
        for (Imp imp : request.getImp()) {
            try {
                this.processImp(imp, pubToImps);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
            }
        }
        if (AdkernelBidder.hasNoImpressions(pubToImps)) {
            return Result.withErrors(errors);
        }
        BidRequest.BidRequestBuilder requestBuilder = request.toBuilder();
        List<HttpRequest> httpRequests = pubToImps.entrySet().stream().map(extAndImp -> this.createHttpRequest((Map.Entry<ExtImpAdkernel, List<Imp>>)extAndImp, requestBuilder, request.getSite(), request.getApp())).toList();
        return Result.of(httpRequests, errors);
    }

    private void processImp(Imp imp, Map<ExtImpAdkernel, List<Imp>> pubToImps) {
        AdkernelBidder.validateImp(imp);
        ExtImpAdkernel extImpAdkernel = this.parseAndValidateImpExt(imp);
        AdkernelBidder.dispatchImpression(imp, extImpAdkernel, pubToImps);
    }

    private static void validateImp(Imp imp) {
        if (imp.getBanner() == null && imp.getVideo() == null && imp.getXNative() == null) {
            throw new PreBidException("Invalid imp id=" + imp.getId() + ". Expected imp.banner / imp.video / imp.native");
        }
    }

    private ExtImpAdkernel parseAndValidateImpExt(Imp imp) {
        ExtImpAdkernel extImpAdkernel;
        try {
            extImpAdkernel = (ExtImpAdkernel)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADKERNEL_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), e);
        }
        Integer zoneId = extImpAdkernel.getZoneId();
        if (zoneId == null || zoneId < 1) {
            throw new PreBidException("Invalid zoneId value: %d. Ignoring imp id=%s".formatted(zoneId, imp.getId()));
        }
        return extImpAdkernel;
    }

    private static void dispatchImpression(Imp imp, ExtImpAdkernel extImpAdkernel, Map<ExtImpAdkernel, List<Imp>> pubToImp) {
        pubToImp.putIfAbsent(extImpAdkernel, new ArrayList());
        pubToImp.get(extImpAdkernel).add(AdkernelBidder.compatImpression(imp));
    }

    private static Imp compatImpression(Imp imp) {
        Imp.ImpBuilder impBuilder = imp.toBuilder().ext(null).audio(null);
        if (imp.getBanner() != null) {
            return impBuilder.video(null).xNative(null).build();
        }
        if (imp.getVideo() != null) {
            return impBuilder.xNative(null).build();
        }
        return impBuilder.build();
    }

    private static boolean hasNoImpressions(Map<ExtImpAdkernel, List<Imp>> pubToImps) {
        return pubToImps.values().stream().allMatch(CollectionUtils::isEmpty);
    }

    private HttpRequest<BidRequest> createHttpRequest(Map.Entry<ExtImpAdkernel, List<Imp>> extAndImp, BidRequest.BidRequestBuilder requestBuilder, Site site, App app) {
        ExtImpAdkernel impExt = extAndImp.getKey();
        String uri = this.endpointTemplate.formatted(impExt.getZoneId());
        MultiMap headers = HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        BidRequest outgoingRequest = AdkernelBidder.createBidRequest(extAndImp.getValue(), requestBuilder, site, app);
        return HttpRequest.builder().method(HttpMethod.POST).uri(uri).headers(headers).body(this.mapper.encodeToBytes(outgoingRequest)).payload(outgoingRequest).build();
    }

    private static BidRequest createBidRequest(List<Imp> imps, BidRequest.BidRequestBuilder requestBuilder, Site site, App app) {
        requestBuilder.imp(imps);
        if (site != null) {
            requestBuilder.site(site.toBuilder().publisher(null).build());
        } else {
            requestBuilder.app(app.toBuilder().publisher(null).build());
        }
        return requestBuilder.build();
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues(AdkernelBidder.extractBids(httpCall.getRequest().getPayload(), bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || bidResponse.getSeatbid() == null) {
            return Collections.emptyList();
        }
        if (bidResponse.getSeatbid().size() != 1) {
            throw new PreBidException("Invalid SeatBids count: " + bidResponse.getSeatbid().size());
        }
        return AdkernelBidder.bidsFromResponse(bidRequest, bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().map(SeatBid::getBid).flatMap(Collection::stream).map(bid -> BidderBid.of(bid, AdkernelBidder.getType(bid.getImpid(), bidRequest.getImp()), bidResponse.getCur())).toList();
    }

    private static BidType getType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId) || imp.getBanner() == null) continue;
            return BidType.banner;
        }
        return BidType.video;
    }
}

