/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adf;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.adf.ExtImpAdf;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

public class AdfBidder
implements Bidder<BidRequest> {
    private static final String REQUEST_EXT_PT = "pt";
    private static final TypeReference<ExtPrebid<?, ExtImpAdf>> ADF_EXT_TYPE_REFERENCE = new TypeReference<ExtPrebid<?, ExtImpAdf>>(){};
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AdfBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl(Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        String priceType = null;
        for (Imp imp : bidRequest.getImp()) {
            ExtImpAdf extImpAdf;
            try {
                extImpAdf = this.parseImpExt(imp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput(e.getMessage()));
                continue;
            }
            modifiedImps.add(imp.toBuilder().tagid(extImpAdf.getMid()).build());
            priceType = (String)StringUtils.defaultIfEmpty(priceType, (CharSequence)extImpAdf.getPriceType());
        }
        if (modifiedImps.isEmpty()) {
            return Result.withErrors(errors);
        }
        BidRequest modifiedBidRequest = this.modifyBidRequest(bidRequest, modifiedImps, priceType);
        return Result.of(Collections.singletonList(this.makeRequest(modifiedBidRequest)), errors);
    }

    private ExtImpAdf parseImpExt(Imp imp) {
        try {
            return (ExtImpAdf)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADF_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private BidRequest modifyBidRequest(BidRequest bidRequest, List<Imp> imps, String priceType) {
        ExtRequest extRequest = (ExtRequest)ObjectUtils.defaultIfNull((Object)bidRequest.getExt(), (Object)ExtRequest.empty());
        ExtRequest modifiedExtRequest = StringUtils.isNotEmpty((CharSequence)priceType) ? this.modifyExtRequest(extRequest, priceType) : extRequest;
        return bidRequest.toBuilder().imp(imps).ext(modifiedExtRequest).build();
    }

    private ExtRequest modifyExtRequest(ExtRequest extRequest, String priceType) {
        ObjectNode adfNode = this.mapper.mapper().createObjectNode().put(REQUEST_EXT_PT, priceType);
        return this.mapper.fillExtension(extRequest, adfNode);
    }

    private HttpRequest<BidRequest> makeRequest(BidRequest bidRequest) {
        return BidderUtil.defaultRequest(bidRequest, this.endpointUrl, this.mapper);
    }

    @Override
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            ArrayList<BidderError> errors = new ArrayList<BidderError>();
            List<BidderBid> bidderBids = this.extractBids(bidResponse, errors);
            return Result.of(bidderBids, errors);
        }
        catch (DecodeException e) {
            return Result.withError(BidderError.badServerResponse(e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty(bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> this.makeBidderBid((Bid)bid, bidResponse.getCur(), errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid makeBidderBid(Bid bid, String bidCurrency, List<BidderError> errors) {
        BidType bidType;
        JsonNode prebidNode = ObjectUtil.getIfNotNull(bid.getExt(), node -> node.get("prebid"));
        JsonNode typeNode = ObjectUtil.getIfNotNull(prebidNode, node -> node.get("type"));
        try {
            bidType = (BidType)((Object)this.mapper.mapper().convertValue((Object)typeNode, BidType.class));
        }
        catch (IllegalArgumentException e) {
            this.addMediaTypeParseError(errors, bid.getImpid());
            return null;
        }
        if (bidType == null) {
            this.addMediaTypeParseError(errors, bid.getImpid());
            return null;
        }
        return BidderBid.of(bid, bidType, bidCurrency);
    }

    private void addMediaTypeParseError(List<BidderError> errors, String impId) {
        errors.add(BidderError.badServerResponse("Failed to parse impression %s mediatype".formatted(impId)));
    }
}

