/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.BidderInfo;
import org.prebid.server.bidder.BidderInstanceDeps;
import org.prebid.server.bidder.Usersyncer;

public class BidderCatalog {
    private static final String ERROR_MESSAGE_TEMPLATE_FOR_DEPRECATED = "%s has been deprecated and is no longer available. Use %s instead.";
    private final Set<String> biddersNames = new HashSet<String>();
    private final Map<String, BidderInstanceDeps> bidderDepsMap = new CaseInsensitiveMap();
    private final Map<String, String> deprecatedNameToError = new CaseInsensitiveMap();
    private final Map<Integer, String> vendorIdToBidderName = new HashMap<Integer, String>();

    public BidderCatalog(List<BidderDeps> bidderDeps) {
        Objects.requireNonNull(bidderDeps).stream().map(BidderDeps::getInstances).flatMap(Collection::stream).forEach(this::processDeps);
    }

    private void processDeps(BidderInstanceDeps deps) {
        String bidderName = deps.getName();
        this.validateBidderName(bidderName);
        this.biddersNames.add(bidderName);
        this.bidderDepsMap.put(bidderName, deps);
        this.deprecatedNameToError.putAll(this.createErrorsForDeprecatedNames(deps));
        this.processVendorId(deps, bidderName);
    }

    private void validateBidderName(String bidderName) {
        if (this.bidderDepsMap.containsKey(bidderName)) {
            throw new IllegalArgumentException("Duplicate bidder or alias '%s'. Please check the configuration".formatted(bidderName));
        }
    }

    private Map<String, String> createErrorsForDeprecatedNames(BidderInstanceDeps deps) {
        return deps.getDeprecatedNames().stream().collect(Collectors.toMap(Function.identity(), deprecatedName -> ERROR_MESSAGE_TEMPLATE_FOR_DEPRECATED.formatted(deprecatedName, deps.getName())));
    }

    private void processVendorId(BidderInstanceDeps coreDeps, String bidderName) {
        Optional.ofNullable(coreDeps.getBidderInfo()).map(BidderInfo::getGdpr).map(BidderInfo.GdprInfo::getVendorId).filter(vendorId -> vendorId != 0).ifPresent(vendorId -> this.vendorIdToBidderName.put((Integer)vendorId, bidderName));
    }

    public Set<String> names() {
        return Collections.unmodifiableSet(this.biddersNames);
    }

    public boolean isValidName(String name) {
        return Optional.ofNullable(name).map(this.bidderDepsMap::containsKey).orElse(false);
    }

    public boolean isModifyingVastXmlAllowed(String name) {
        return Optional.ofNullable(name).map(this.bidderDepsMap::get).map(BidderInstanceDeps::getBidderInfo).map(BidderInfo::isModifyingVastXmlAllowed).orElse(false);
    }

    public boolean isDeprecatedName(String name) {
        return Optional.ofNullable(name).map(this.deprecatedNameToError::containsKey).orElse(false);
    }

    public String errorForDeprecatedName(String name) {
        return Optional.ofNullable(name).map(this.deprecatedNameToError::get).orElse(null);
    }

    public boolean isActive(String name) {
        return Optional.ofNullable(name).map(this.bidderDepsMap::get).map(BidderInstanceDeps::getBidderInfo).map(BidderInfo::isEnabled).orElse(false);
    }

    public boolean isDebugAllowed(String name) {
        return Optional.ofNullable(name).map(this.bidderDepsMap::get).map(BidderInstanceDeps::getBidderInfo).map(BidderInfo::isDebugAllowed).orElse(false);
    }

    public BidderInfo bidderInfoByName(String name) {
        return Optional.ofNullable(name).map(this.bidderDepsMap::get).map(BidderInstanceDeps::getBidderInfo).orElse(null);
    }

    public Integer vendorIdByName(String name) {
        return Optional.ofNullable(name).map(this.bidderDepsMap::get).map(BidderInstanceDeps::getBidderInfo).map(BidderInfo::getGdpr).map(BidderInfo.GdprInfo::getVendorId).orElse(null);
    }

    public String nameByVendorId(Integer vendorId) {
        return this.vendorIdToBidderName.get(vendorId);
    }

    public Set<Integer> knownVendorIds() {
        return this.bidderDepsMap.values().stream().map(BidderInstanceDeps::getBidderInfo).map(BidderInfo::getGdpr).map(BidderInfo.GdprInfo::getVendorId).collect(Collectors.toSet());
    }

    public Optional<Usersyncer> usersyncerByName(String name) {
        return Optional.ofNullable(name).map(this.bidderDepsMap::get).map(BidderInstanceDeps::getUsersyncer);
    }

    private Optional<String> aliasOf(String bidder) {
        return Optional.ofNullable(bidder).map(this.bidderDepsMap::get).map(BidderInstanceDeps::getBidderInfo).map(BidderInfo::getAliasOf);
    }

    public boolean isAlias(String bidder) {
        return this.aliasOf(bidder).isPresent();
    }

    public String resolveBaseBidder(String bidder) {
        return this.aliasOf(bidder).orElse(bidder);
    }

    public Optional<String> cookieFamilyName(String bidder) {
        return this.usersyncerByName(bidder).map(Usersyncer::getCookieFamilyName);
    }

    public Set<String> usersyncReadyBidders() {
        return this.names().stream().filter(this::isActive).filter(bidder -> this.usersyncerByName((String)bidder).isPresent()).collect(Collectors.toSet());
    }

    public Bidder<?> bidderByName(String name) {
        return Optional.ofNullable(name).map(this.bidderDepsMap::get).map(BidderInstanceDeps::getBidder).orElse(null);
    }
}

