/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.requestfactory;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Source;
import com.iab.openrtb.request.SupplyChain;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Collections;
import java.util.Currency;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.ImplicitParametersExtractor;
import org.prebid.server.auction.IpAddressHelper;
import org.prebid.server.auction.PriceGranularity;
import org.prebid.server.auction.TimeoutResolver;
import org.prebid.server.auction.model.Endpoint;
import org.prebid.server.auction.model.IpAddress;
import org.prebid.server.exception.BlacklistedAppException;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.identity.IdGenerator;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.json.JsonMerger;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtDevice;
import org.prebid.server.proto.openrtb.ext.request.ExtMediaTypePriceGranularity;
import org.prebid.server.proto.openrtb.ext.request.ExtPriceGranularity;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidCache;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidChannel;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidServer;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestTargeting;
import org.prebid.server.proto.openrtb.ext.request.ExtSite;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;
import org.prebid.server.util.StreamUtil;

public class Ortb2ImplicitParametersResolver {
    private static final Logger logger = LoggerFactory.getLogger(Ortb2ImplicitParametersResolver.class);
    public static final String WEB_CHANNEL = "web";
    public static final String APP_CHANNEL = "app";
    public static final String AMP_CHANNEL = "amp";
    public static final String DOOH_CHANNEL = "dooh";
    private static final String PREBID_EXT = "prebid";
    private static final String BIDDER_EXT = "bidder";
    private static final Set<String> IMP_EXT_NON_BIDDER_FIELDS = Set.of("prebid", "context", "all", "general", "skadn", "data", "gpid", "tid", "ae");
    private static final String OVERRIDE_SOURCE_ID_TEMPLATE = "{{UUID}}";
    private final boolean shouldCacheOnlyWinningBids;
    private final boolean generateBidRequestId;
    private final String adServerCurrency;
    private final List<String> blacklistedApps;
    private final ExtRequestPrebidServer serverInfo;
    private final ImplicitParametersExtractor paramsExtractor;
    private final TimeoutResolver timeoutResolver;
    private final IpAddressHelper ipAddressHelper;
    private final IdGenerator tidGenerator;
    private final JsonMerger jsonMerger;
    private final JacksonMapper mapper;

    public Ortb2ImplicitParametersResolver(boolean shouldCacheOnlyWinningBids, boolean generateBidRequestId, String adServerCurrency, List<String> blacklistedApps, String externalUrl, Integer hostVendorId, String datacenterRegion, ImplicitParametersExtractor paramsExtractor, TimeoutResolver timeoutResolver, IpAddressHelper ipAddressHelper, IdGenerator tidGenerator, JsonMerger jsonMerger, JacksonMapper mapper) {
        this.shouldCacheOnlyWinningBids = shouldCacheOnlyWinningBids;
        this.generateBidRequestId = generateBidRequestId;
        this.adServerCurrency = Ortb2ImplicitParametersResolver.validateCurrency(Objects.requireNonNull(adServerCurrency));
        this.blacklistedApps = Objects.requireNonNull(blacklistedApps);
        this.serverInfo = ExtRequestPrebidServer.of(externalUrl, hostVendorId, datacenterRegion, null);
        this.paramsExtractor = Objects.requireNonNull(paramsExtractor);
        this.timeoutResolver = Objects.requireNonNull(timeoutResolver);
        this.ipAddressHelper = Objects.requireNonNull(ipAddressHelper);
        this.tidGenerator = Objects.requireNonNull(tidGenerator);
        this.jsonMerger = Objects.requireNonNull(jsonMerger);
        this.mapper = Objects.requireNonNull(mapper);
    }

    private static String validateCurrency(String code) {
        try {
            Currency.getInstance(code);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Currency code supplied is not valid: " + code, e);
        }
        return code;
    }

    public BidRequest resolve(BidRequest bidRequest, HttpRequestContext httpRequest, String endpoint, boolean hasStoredBidRequest) {
        this.checkBlacklistedApp(bidRequest);
        Device device = bidRequest.getDevice();
        Device populatedDevice = this.populateDevice(device, bidRequest.getApp(), httpRequest);
        Site site = bidRequest.getSite();
        Site populatedSite = bidRequest.getApp() != null || bidRequest.getDooh() != null ? null : this.populateSite(site, httpRequest);
        List<Imp> populatedImps = this.populateImps(bidRequest, this.generateBidRequestId, hasStoredBidRequest);
        Integer at = bidRequest.getAt();
        Integer resolvedAt = Ortb2ImplicitParametersResolver.resolveAt(at);
        List<String> cur = bidRequest.getCur();
        List<String> resolvedCurrencies = this.resolveCurrencies(cur);
        Long tmax = bidRequest.getTmax();
        Long resolvedTmax = this.resolveTmax(tmax);
        ExtRequest ext = bidRequest.getExt();
        List<Imp> imps = bidRequest.getImp();
        ExtRequest populatedExt = this.populateRequestExt(ext, bidRequest, (List)ObjectUtils.defaultIfNull(populatedImps, imps), endpoint);
        Source source = bidRequest.getSource();
        Source populatedSource = this.populateSource(source, populatedExt, hasStoredBidRequest);
        return bidRequest.toBuilder().device(populatedDevice != null ? populatedDevice : device).site(populatedSite != null ? populatedSite : site).imp(populatedImps != null ? populatedImps : imps).at(resolvedAt != null ? resolvedAt : at).cur(resolvedCurrencies != null ? resolvedCurrencies : cur).tmax(resolvedTmax != null ? resolvedTmax : tmax).ext(populatedExt).source(populatedSource != null ? populatedSource : source).build();
    }

    public static boolean isImpExtBidder(String field) {
        return !IMP_EXT_NON_BIDDER_FIELDS.contains(field);
    }

    private void checkBlacklistedApp(BidRequest bidRequest) {
        String appId;
        App app = bidRequest.getApp();
        String string = appId = app != null ? app.getId() : null;
        if (StringUtils.isNotBlank((CharSequence)appId) && this.blacklistedApps.contains(appId)) {
            throw new BlacklistedAppException("Prebid-server does not process requests from App ID: " + appId);
        }
    }

    private Device populateDevice(Device device, App app, HttpRequestContext httpRequest) {
        String deviceIp = device != null ? device.getIp() : null;
        String deviceIpv6 = device != null ? device.getIpv6() : null;
        String resolvedIp = this.sanitizeIp(deviceIp, IpAddress.IP.v4);
        String resolvedIpv6 = this.sanitizeIp(deviceIpv6, IpAddress.IP.v6);
        if (resolvedIp == null && resolvedIpv6 == null) {
            IpAddress requestIp = this.findIpFromRequest(httpRequest);
            resolvedIp = Ortb2ImplicitParametersResolver.getIpIfVersionIs(requestIp, IpAddress.IP.v4);
            resolvedIpv6 = Ortb2ImplicitParametersResolver.getIpIfVersionIs(requestIp, IpAddress.IP.v6);
        }
        Ortb2ImplicitParametersResolver.logWarnIfNoIp(resolvedIp, resolvedIpv6);
        String ua = device != null ? device.getUa() : null;
        Integer dnt = this.resolveDntHeader(httpRequest);
        Integer lmt = Ortb2ImplicitParametersResolver.resolveLmt(device, app);
        if (!Objects.equals(deviceIp, resolvedIp) || !Objects.equals(deviceIpv6, resolvedIpv6) || StringUtils.isBlank((CharSequence)ua) || dnt != null || lmt != null) {
            Device.DeviceBuilder builder;
            Device.DeviceBuilder deviceBuilder = builder = device == null ? Device.builder() : device.toBuilder();
            if (StringUtils.isBlank((CharSequence)ua)) {
                builder.ua(this.paramsExtractor.uaFrom(httpRequest));
            }
            if (dnt != null) {
                builder.dnt(dnt);
            }
            if (lmt != null) {
                builder.lmt(lmt);
            }
            builder.ip(resolvedIp).ipv6(resolvedIpv6);
            return builder.build();
        }
        return null;
    }

    private Integer resolveDntHeader(HttpRequestContext request) {
        String dnt = request.getHeaders().get(HttpUtil.DNT_HEADER.toString());
        return StringUtils.equalsAny((CharSequence)dnt, (CharSequence[])new CharSequence[]{"0", "1"}) ? Integer.valueOf(dnt) : null;
    }

    private String sanitizeIp(String ip, IpAddress.IP version) {
        IpAddress ipAddress = ip != null ? this.ipAddressHelper.toIpAddress(ip) : null;
        return ipAddress != null && ipAddress.getVersion() == version ? ipAddress.getIp() : null;
    }

    private IpAddress findIpFromRequest(HttpRequestContext request) {
        CaseInsensitiveMultiMap headers = request.getHeaders();
        String remoteHost = request.getRemoteHost();
        List<String> requestIps = this.paramsExtractor.ipFrom(headers, remoteHost);
        return requestIps.stream().map(this.ipAddressHelper::toIpAddress).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static String getIpIfVersionIs(IpAddress requestIp, IpAddress.IP version) {
        return requestIp != null && requestIp.getVersion() == version ? requestIp.getIp() : null;
    }

    private static void logWarnIfNoIp(String resolvedIp, String resolvedIpv6) {
        if (resolvedIp == null && resolvedIpv6 == null) {
            logger.warn((Object)"No IP address found in OpenRTB request and HTTP request headers.");
        }
    }

    private static Integer resolveLmt(Device device, App app) {
        if (app == null || device == null || !StringUtils.equalsIgnoreCase((CharSequence)device.getOs(), (CharSequence)"ios")) {
            return null;
        }
        String osv = device.getOsv();
        if (osv == null) {
            return null;
        }
        String[] versionParts = StringUtils.split((String)osv, (char)'.');
        if (versionParts.length < 2) {
            return null;
        }
        Integer versionMajor = Ortb2ImplicitParametersResolver.tryParseAsNumber(versionParts[0]);
        Integer versionMinor = Ortb2ImplicitParametersResolver.tryParseAsNumber(versionParts[1]);
        if (versionMajor == null || versionMinor == null) {
            return null;
        }
        return Ortb2ImplicitParametersResolver.resolveLmtForIos(device, versionMajor, versionMinor);
    }

    private static Integer tryParseAsNumber(String number) {
        try {
            return Integer.parseUnsignedInt(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Integer resolveLmtForIos(Device device, Integer versionMajor, Integer versionMinor) {
        if (versionMajor < 14) {
            return null;
        }
        if (versionMajor == 14 && (versionMinor == 0 || versionMinor == 1)) {
            return Ortb2ImplicitParametersResolver.resolveLmtForIos14Minor0And1(device);
        }
        if (versionMajor > 14 || versionMinor >= 2) {
            return Ortb2ImplicitParametersResolver.resolveLmtForIos14Minor2AndHigher(device);
        }
        return null;
    }

    private static Integer resolveLmtForIos14Minor0And1(Device device) {
        String ifa = device.getIfa();
        Integer lmt = device.getLmt();
        if (StringUtils.isEmpty((CharSequence)ifa) || ifa.equals("00000000-0000-0000-0000-000000000000")) {
            return !Objects.equals(lmt, 1) ? Integer.valueOf(1) : null;
        }
        return !Objects.equals(lmt, 0) ? Integer.valueOf(0) : null;
    }

    private static Integer resolveLmtForIos14Minor2AndHigher(Device device) {
        Integer lmt = device.getLmt();
        Integer atts = ObjectUtil.getIfNotNull(device.getExt(), ExtDevice::getAtts);
        if (atts == null) {
            return null;
        }
        if (atts == 3) {
            return !Objects.equals(lmt, 0) ? Integer.valueOf(0) : null;
        }
        if (atts == 0 || atts == 1 || atts == 2) {
            return !Objects.equals(lmt, 1) ? Integer.valueOf(1) : null;
        }
        return null;
    }

    private Site populateSite(Site site, HttpRequestContext httpRequest) {
        ExtSite updatedSiteExt;
        String page = site != null ? StringUtils.trimToNull((String)site.getPage()) : null;
        String updatedPage = page == null ? this.paramsExtractor.refererFrom(httpRequest) : null;
        String domain = site != null ? StringUtils.trimToNull((String)site.getDomain()) : null;
        String updatedDomain = domain == null ? HttpUtil.getHostFromUrl((String)ObjectUtils.defaultIfNull((Object)updatedPage, (Object)page)) : null;
        Publisher publisher = site != null ? site.getPublisher() : null;
        Publisher updatedPublisher = this.populateSitePublisher(publisher, (String)ObjectUtils.defaultIfNull((Object)updatedDomain, (Object)domain));
        ExtSite siteExt = site != null ? site.getExt() : null;
        ExtSite extSite = updatedSiteExt = siteExt == null || siteExt.getAmp() == null ? ExtSite.of(0, ObjectUtil.getIfNotNull(siteExt, ExtSite::getData)) : null;
        if (ObjectUtils.anyNotNull((Object[])new Object[]{updatedPage, updatedDomain, updatedPublisher, updatedSiteExt})) {
            boolean domainPresent = publisher != null && publisher.getDomain() != null || updatedPublisher != null && updatedPublisher.getDomain() != null;
            return (site == null ? Site.builder() : site.toBuilder()).page(domainPresent ? (String)ObjectUtils.defaultIfNull((Object)updatedPage, (Object)page) : page).domain((String)ObjectUtils.defaultIfNull((Object)updatedDomain, (Object)domain)).publisher((Publisher)ObjectUtils.defaultIfNull((Object)updatedPublisher, (Object)publisher)).ext((ExtSite)ObjectUtils.defaultIfNull((Object)updatedSiteExt, (Object)siteExt)).build();
        }
        return null;
    }

    private Publisher populateSitePublisher(Publisher publisher, String domain) {
        String updatedPublisherDomain;
        String publisherDomain = publisher != null ? publisher.getDomain() : null;
        String string = updatedPublisherDomain = publisherDomain == null ? this.getDomainOrNull(domain) : null;
        if (updatedPublisherDomain != null) {
            return (publisher == null ? Publisher.builder() : publisher.toBuilder()).domain(updatedPublisherDomain).build();
        }
        return null;
    }

    private String getDomainOrNull(String url) {
        try {
            return this.paramsExtractor.domainFrom(url);
        }
        catch (PreBidException e) {
            logger.warn((Object)"Error occurred while populating bid request: {0}", new Object[]{e.getMessage()});
            return null;
        }
    }

    private Source populateSource(Source source, ExtRequest extRequest, boolean hasStoredBidRequest) {
        SupplyChain supplyChain;
        SupplyChain populatedSupplyChain;
        String tid = source != null ? source.getTid() : null;
        String populatedTid = Ortb2ImplicitParametersResolver.populateTidValue(tid, this.generateBidRequestId, hasStoredBidRequest, this.tidGenerator);
        if (ObjectUtils.anyNotNull((Object[])new Object[]{populatedTid, populatedSupplyChain = this.populateSupplyChain(supplyChain = source != null ? source.getSchain() : null, extRequest)})) {
            return (source != null ? source.toBuilder() : Source.builder()).tid(populatedTid != null ? populatedTid : tid).schain(populatedSupplyChain != null ? populatedSupplyChain : supplyChain).build();
        }
        return null;
    }

    private static String populateTidValue(String tid, boolean generateBidRequestId, boolean hasStoredBidRequest, IdGenerator tidGenerator) {
        boolean containsTidMacro = StringUtils.containsIgnoreCase((CharSequence)tid, (CharSequence)OVERRIDE_SOURCE_ID_TEMPLATE);
        if (!(!StringUtils.isNotBlank((CharSequence)tid) || containsTidMacro || generateBidRequestId && hasStoredBidRequest)) {
            return null;
        }
        String generatedId = tidGenerator.generateId();
        return StringUtils.isBlank((CharSequence)tid) || generateBidRequestId && hasStoredBidRequest && !containsTidMacro ? generatedId : StringUtils.replaceIgnoreCase((String)tid, (String)OVERRIDE_SOURCE_ID_TEMPLATE, (String)generatedId);
    }

    private SupplyChain populateSupplyChain(SupplyChain supplyChain, ExtRequest extRequest) {
        if (supplyChain != null || extRequest == null) {
            return null;
        }
        try {
            return (SupplyChain)this.mapper.mapper().convertValue((Object)extRequest.getProperty("schain"), SupplyChain.class);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private List<Imp> populateImps(BidRequest bidRequest, boolean generateBidRequestId, boolean hasStoredBidRequest) {
        List<Imp> imps = bidRequest.getImp();
        if (CollectionUtils.isEmpty(imps)) {
            return null;
        }
        ObjectNode globalBidderParams = Ortb2ImplicitParametersResolver.extractGlobalBidderParams(bidRequest);
        boolean isUniqueIds = Ortb2ImplicitParametersResolver.isUniqueIds(imps);
        List<ImpPopulationContext> impPopulationContexts = IntStream.range(0, imps.size()).mapToObj(index -> new ImpPopulationContext((Imp)imps.get(index), globalBidderParams, generateBidRequestId, hasStoredBidRequest, !isUniqueIds ? String.valueOf(index + 1) : null, this.mapper, this.tidGenerator, this.jsonMerger)).toList();
        if (impPopulationContexts.stream().map(ImpPopulationContext::getPopulatedImp).allMatch(Objects::isNull)) {
            return null;
        }
        return impPopulationContexts.stream().map(ImpPopulationContext::getPopulationResult).toList();
    }

    private static ObjectNode extractGlobalBidderParams(BidRequest bidRequest) {
        ExtRequest extRequest = bidRequest.getExt();
        ExtRequestPrebid extBidPrebid = extRequest != null ? extRequest.getPrebid() : null;
        ObjectNode bidderParams = extBidPrebid != null ? extBidPrebid.getBidderparams() : null;
        return Ortb2ImplicitParametersResolver.isObjectNode((JsonNode)bidderParams) ? Ortb2ImplicitParametersResolver.removeNonBidderFields(bidderParams) : null;
    }

    private static ObjectNode removeNonBidderFields(ObjectNode node) {
        ObjectNode modifiedNode = node.deepCopy();
        IMP_EXT_NON_BIDDER_FIELDS.forEach(arg_0 -> ((ObjectNode)modifiedNode).remove(arg_0));
        return !modifiedNode.isEmpty() ? modifiedNode : null;
    }

    private static boolean isObjectNode(JsonNode node) {
        return node != null && node.isObject();
    }

    private static boolean isUniqueIds(List<Imp> imps) {
        List<String> impIdsList = imps.stream().filter(Objects::nonNull).map(Imp::getId).toList();
        HashSet<String> impIdsSet = new HashSet<String>(impIdsList);
        return impIdsSet.size() == impIdsList.size();
    }

    private ExtRequest populateRequestExt(ExtRequest ext, BidRequest bidRequest, List<Imp> imps, String endpoint) {
        ExtRequestPrebid prebid = ObjectUtil.getIfNotNull(ext, ExtRequest::getPrebid);
        ExtRequestTargeting updatedTargeting = this.targetingOrNull(prebid, imps);
        ExtRequestPrebidCache updatedCache = this.cacheOrNull(prebid);
        ExtRequestPrebidChannel updatedChannel = this.channelOrNull(prebid, bidRequest, endpoint);
        ExtRequestPrebid.ExtRequestPrebidBuilder prebidBuilder = prebid != null ? prebid.toBuilder() : ExtRequestPrebid.builder();
        ExtRequest updatedExt = ExtRequest.of(prebidBuilder.targeting((ExtRequestTargeting)ObjectUtils.defaultIfNull((Object)updatedTargeting, (Object)ObjectUtil.getIfNotNull(prebid, ExtRequestPrebid::getTargeting))).cache((ExtRequestPrebidCache)ObjectUtils.defaultIfNull((Object)updatedCache, (Object)ObjectUtil.getIfNotNull(prebid, ExtRequestPrebid::getCache))).channel((ExtRequestPrebidChannel)ObjectUtils.defaultIfNull((Object)updatedChannel, (Object)ObjectUtil.getIfNotNull(prebid, ExtRequestPrebid::getChannel))).server(this.serverInfo.with(endpoint)).build());
        Map extProperties = ObjectUtil.getIfNotNull(ext, FlexibleExtension::getProperties);
        if (extProperties != null) {
            updatedExt.addProperties(extProperties);
        }
        return updatedExt;
    }

    private static Set<BidType> getImpMediaTypes(List<Imp> imps) {
        HashSet<BidType> impMediaTypes = new HashSet<BidType>();
        if (CollectionUtils.isEmpty(imps)) {
            return impMediaTypes;
        }
        for (Imp imp : imps) {
            Ortb2ImplicitParametersResolver.resolveImpMediaTypes(imp, impMediaTypes);
            if (impMediaTypes.size() < 4) continue;
            break;
        }
        return impMediaTypes;
    }

    private static void resolveImpMediaTypes(Imp imp, Set<BidType> impsMediaTypes) {
        if (imp.getBanner() != null) {
            impsMediaTypes.add(BidType.banner);
        }
        if (imp.getVideo() != null) {
            impsMediaTypes.add(BidType.video);
        }
        if (imp.getAudio() != null) {
            impsMediaTypes.add(BidType.audio);
        }
        if (imp.getXNative() != null) {
            impsMediaTypes.add(BidType.xNative);
        }
    }

    private ExtRequestTargeting targetingOrNull(ExtRequestPrebid prebid, List<Imp> imps) {
        boolean isIncludeBidderKeysNull;
        ExtRequestTargeting targeting = prebid != null ? prebid.getTargeting() : null;
        boolean isTargetingNotNull = targeting != null;
        boolean isPriceGranularityNull = isTargetingNotNull && (targeting.getPricegranularity() == null || targeting.getPricegranularity().isNull());
        boolean isPriceGranularityTextual = isTargetingNotNull && !isPriceGranularityNull && targeting.getPricegranularity().isTextual();
        boolean isIncludeWinnersNull = isTargetingNotNull && targeting.getIncludewinners() == null;
        boolean bl = isIncludeBidderKeysNull = isTargetingNotNull && targeting.getIncludebidderkeys() == null;
        if (isPriceGranularityNull || isPriceGranularityTextual || isIncludeWinnersNull || isIncludeBidderKeysNull) {
            return targeting.toBuilder().pricegranularity(this.resolvePriceGranularity(targeting, isPriceGranularityNull, isPriceGranularityTextual, imps)).includewinners(isIncludeWinnersNull || targeting.getIncludewinners() != false).includebidderkeys(isIncludeBidderKeysNull ? !this.isWinningOnly(prebid.getCache()) : targeting.getIncludebidderkeys()).build();
        }
        return null;
    }

    private boolean isWinningOnly(ExtRequestPrebidCache cache) {
        Boolean cacheWinningOnly = cache != null ? cache.getWinningonly() : null;
        return (Boolean)ObjectUtils.defaultIfNull((Object)cacheWinningOnly, (Object)this.shouldCacheOnlyWinningBids);
    }

    private JsonNode resolvePriceGranularity(ExtRequestTargeting targeting, boolean isPriceGranularityNull, boolean isPriceGranularityTextual, List<Imp> imps) {
        boolean hasAllMediaTypes = Ortb2ImplicitParametersResolver.checkExistingMediaTypes(targeting.getMediatypepricegranularity()).containsAll(Ortb2ImplicitParametersResolver.getImpMediaTypes(imps));
        if (isPriceGranularityNull && !hasAllMediaTypes) {
            return this.mapper.mapper().valueToTree((Object)ExtPriceGranularity.from(PriceGranularity.DEFAULT));
        }
        JsonNode priceGranularityNode = targeting.getPricegranularity();
        if (isPriceGranularityTextual) {
            PriceGranularity priceGranularity;
            try {
                priceGranularity = PriceGranularity.createFromString(priceGranularityNode.textValue());
            }
            catch (PreBidException e) {
                throw new InvalidRequestException(e.getMessage());
            }
            return this.mapper.mapper().valueToTree((Object)ExtPriceGranularity.from(priceGranularity));
        }
        return priceGranularityNode;
    }

    private static Set<BidType> checkExistingMediaTypes(ExtMediaTypePriceGranularity mediaTypePriceGranularity) {
        ObjectNode xNative;
        ObjectNode video;
        if (mediaTypePriceGranularity == null) {
            return Collections.emptySet();
        }
        HashSet<BidType> priceGranularityTypes = new HashSet<BidType>();
        ObjectNode banner = mediaTypePriceGranularity.getBanner();
        if (banner != null && !banner.isNull()) {
            priceGranularityTypes.add(BidType.banner);
        }
        if ((video = mediaTypePriceGranularity.getVideo()) != null && !video.isNull()) {
            priceGranularityTypes.add(BidType.video);
        }
        if ((xNative = mediaTypePriceGranularity.getXNative()) != null && !xNative.isNull()) {
            priceGranularityTypes.add(BidType.xNative);
        }
        return priceGranularityTypes;
    }

    private ExtRequestPrebidCache cacheOrNull(ExtRequestPrebid prebid) {
        Boolean cacheWinningOnly;
        ExtRequestPrebidCache cache = prebid != null ? prebid.getCache() : null;
        Boolean bl = cacheWinningOnly = cache != null ? cache.getWinningonly() : null;
        if (cacheWinningOnly == null && this.shouldCacheOnlyWinningBids) {
            return ExtRequestPrebidCache.of(ObjectUtil.getIfNotNull(cache, ExtRequestPrebidCache::getBids), ObjectUtil.getIfNotNull(cache, ExtRequestPrebidCache::getVastxml), true);
        }
        return null;
    }

    private ExtRequestPrebidChannel channelOrNull(ExtRequestPrebid prebid, BidRequest bidRequest, String endpoint) {
        ExtRequestPrebidChannel channel = ObjectUtil.getIfNotNull(prebid, ExtRequestPrebid::getChannel);
        String channelName = ObjectUtil.getIfNotNull(channel, ExtRequestPrebidChannel::getName);
        if (channel != null && StringUtils.isBlank((CharSequence)channelName)) {
            throw new PreBidException("ext.prebid.channel.name can't be empty");
        }
        return channel == null ? Ortb2ImplicitParametersResolver.populateChannel(bidRequest, endpoint) : null;
    }

    private static ExtRequestPrebidChannel populateChannel(BidRequest bidRequest, String endpoint) {
        if (StringUtils.equals((CharSequence)Endpoint.openrtb2_amp.value(), (CharSequence)endpoint)) {
            return ExtRequestPrebidChannel.of(AMP_CHANNEL);
        }
        if (bidRequest.getApp() != null) {
            return ExtRequestPrebidChannel.of(APP_CHANNEL);
        }
        if (bidRequest.getSite() != null) {
            return ExtRequestPrebidChannel.of(WEB_CHANNEL);
        }
        if (bidRequest.getDooh() != null) {
            return ExtRequestPrebidChannel.of(DOOH_CHANNEL);
        }
        return null;
    }

    private static Integer resolveAt(Integer at) {
        return at == null || at == 0 ? Integer.valueOf(1) : null;
    }

    private List<String> resolveCurrencies(List<String> currencies) {
        return CollectionUtils.isEmpty(currencies) ? Collections.singletonList(this.adServerCurrency) : null;
    }

    private Long resolveTmax(Long requestTimeout) {
        long timeout = this.timeoutResolver.limitToMax(requestTimeout);
        return !Objects.equals(requestTimeout, timeout) ? Long.valueOf(timeout) : null;
    }

    private static final class ImpPopulationContext {
        private static final String DEALS_ONLY = "dealsonly";
        private static final String PG_DEALS_ONLY = "pgdealsonly";
        private static final String TID = "tid";
        private final Imp imp;
        private final Imp populatedImp;

        ImpPopulationContext(Imp imp, ObjectNode globalBidderParams, boolean generateBidRequestId, boolean hasStoredBidRequest, String impIdOverride, JacksonMapper mapper, IdGenerator tidGenerator, JsonMerger jsonMerger) {
            this.imp = imp;
            this.populatedImp = ImpPopulationContext.populateImp(imp, globalBidderParams, generateBidRequestId, hasStoredBidRequest, impIdOverride, mapper, tidGenerator, jsonMerger);
        }

        public Imp getPopulationResult() {
            return this.populatedImp != null ? this.populatedImp : this.imp;
        }

        private static Imp populateImp(Imp imp, ObjectNode globalBidderParams, boolean generateBidRequestId, boolean hasStoredBidRequest, String impIdOverride, JacksonMapper mapper, IdGenerator tidGenerator, JsonMerger jsonMerger) {
            ObjectNode impExt;
            ObjectNode populatedImpExt;
            Integer impSecure;
            Integer populatedImpSecure;
            String impId = imp.getId();
            String populatedImpId = ImpPopulationContext.populateImpId(impId, impIdOverride);
            return ObjectUtils.anyNotNull((Object[])new Object[]{populatedImpId, populatedImpSecure = ImpPopulationContext.populateImpSecure(impSecure = imp.getSecure()), populatedImpExt = ImpPopulationContext.populateImpExt(impExt = imp.getExt(), globalBidderParams, generateBidRequestId, hasStoredBidRequest, mapper, tidGenerator, jsonMerger)}) ? imp.toBuilder().id(populatedImpId != null ? populatedImpId : impId).secure(populatedImpSecure != null ? populatedImpSecure : impSecure).ext(populatedImpExt != null ? populatedImpExt : impExt).build() : null;
        }

        private static String populateImpId(String impId, String impIdOverride) {
            return StringUtils.isNotBlank((CharSequence)impIdOverride) || StringUtils.isBlank((CharSequence)impId) ? (StringUtils.isNotBlank((CharSequence)impIdOverride) ? impIdOverride : ImpPopulationContext.generateSixteenDigitRandomString()) : null;
        }

        private static String generateSixteenDigitRandomString() {
            return String.valueOf(ThreadLocalRandom.current().nextLong(1000000000000000L, 10000000000000000L));
        }

        private static Integer populateImpSecure(Integer impSecure) {
            return impSecure == null ? Integer.valueOf(1) : null;
        }

        private static ObjectNode populateImpExt(ObjectNode impExt, ObjectNode globalBidderParams, boolean generateBidRequestId, boolean hasStoredBidRequest, JacksonMapper mapper, IdGenerator tidGenerator, JsonMerger jsonMerger) {
            ObjectNode modifiedImpExt = ImpPopulationContext.prepareValidImpExtCopy(impExt, mapper);
            boolean isMoved = ImpPopulationContext.moveBidderParamsToPrebid(modifiedImpExt);
            boolean isMerged = ImpPopulationContext.mergeGlobalBidderParamsToImpExt(modifiedImpExt, globalBidderParams, jsonMerger);
            boolean isDealsOnlyModified = ImpPopulationContext.modifyDealsOnly(modifiedImpExt);
            boolean isNonBidderFieldsModified = ImpPopulationContext.modifyNonBidderFields(modifiedImpExt, generateBidRequestId, hasStoredBidRequest, tidGenerator);
            return isMoved || isMerged || isDealsOnlyModified || isNonBidderFieldsModified ? modifiedImpExt : null;
        }

        private static ObjectNode prepareValidImpExtCopy(ObjectNode impExt, JacksonMapper mapper) {
            ObjectNode copiedImpExt = impExt != null ? impExt.deepCopy() : mapper.mapper().createObjectNode();
            ObjectNode modifiedExtPrebid = ImpPopulationContext.getOrCreateChildObjectNode(copiedImpExt, Ortb2ImplicitParametersResolver.PREBID_EXT);
            ImpPopulationContext.getOrCreateChildObjectNode(modifiedExtPrebid, Ortb2ImplicitParametersResolver.BIDDER_EXT);
            return copiedImpExt;
        }

        private static ObjectNode getOrCreateChildObjectNode(ObjectNode parentNode, String fieldName) {
            JsonNode childNode = parentNode.get(fieldName);
            return Ortb2ImplicitParametersResolver.isObjectNode(childNode) ? (ObjectNode)childNode : parentNode.putObject(fieldName);
        }

        private static boolean moveBidderParamsToPrebid(ObjectNode impExt) {
            ObjectNode extPrebidBidder = ImpPopulationContext.bidderParamsFromImpExt(impExt);
            Set bidders = StreamUtil.asStream(impExt.fieldNames()).filter(Ortb2ImplicitParametersResolver::isImpExtBidder).collect(Collectors.toSet());
            if (bidders.isEmpty()) {
                return false;
            }
            for (String bidder : bidders) {
                ObjectNode bidderNode = ImpPopulationContext.getOrCreateChildObjectNode(extPrebidBidder, bidder);
                JsonNode impExtBidderNode = impExt.remove(bidder);
                if (!Ortb2ImplicitParametersResolver.isObjectNode(impExtBidderNode)) continue;
                bidderNode.setAll((ObjectNode)impExtBidderNode);
            }
            return true;
        }

        private static ObjectNode bidderParamsFromImpExt(ObjectNode ext) {
            return (ObjectNode)ext.path(Ortb2ImplicitParametersResolver.PREBID_EXT).path(Ortb2ImplicitParametersResolver.BIDDER_EXT);
        }

        private static boolean mergeGlobalBidderParamsToImpExt(ObjectNode impExt, ObjectNode globalBidderParams, JsonMerger jsonMerger) {
            if (globalBidderParams == null || globalBidderParams.isEmpty()) {
                return false;
            }
            ObjectNode impExtPrebidBidder = ImpPopulationContext.bidderParamsFromImpExt(impExt);
            StreamUtil.asStream(globalBidderParams.fields()).forEach(bidderToParam -> ImpPopulationContext.mergeBidderParams(impExtPrebidBidder, bidderToParam, jsonMerger));
            return true;
        }

        private static void mergeBidderParams(ObjectNode impExtPrebidBidder, Map.Entry<String, JsonNode> bidderToParam, JsonMerger jsonMerger) {
            String bidder = bidderToParam.getKey();
            JsonNode bidderParams = impExtPrebidBidder.get(bidder);
            JsonNode requestParams = bidderToParam.getValue();
            JsonNode mergedParams = bidderParams == null ? requestParams : jsonMerger.merge(bidderParams, requestParams);
            impExtPrebidBidder.set(bidder, mergedParams);
        }

        private static boolean modifyDealsOnly(ObjectNode impExt) {
            Object[] isModified = (Boolean[])StreamUtil.asStream(ImpPopulationContext.bidderParamsFromImpExt(impExt).fields()).map(Map.Entry::getValue).filter(ImpPopulationContext::isPgDealsOnlyBidder).map(ObjectNode.class::cast).map(ImpPopulationContext::modifyDealsOnlyIfNotSpecified).toArray(Boolean[]::new);
            if (ArrayUtils.isEmpty((Object[])isModified)) {
                return false;
            }
            return BooleanUtils.or((Boolean[])isModified);
        }

        private static boolean isPgDealsOnlyBidder(JsonNode bidderFields) {
            JsonNode pgDealsOnlyNode = bidderFields.path(PG_DEALS_ONLY);
            return pgDealsOnlyNode.isBoolean() && pgDealsOnlyNode.asBoolean();
        }

        private static boolean modifyDealsOnlyIfNotSpecified(ObjectNode bidderFields) {
            JsonNode dealsOnlyNode = bidderFields.path(DEALS_ONLY);
            if (dealsOnlyNode.isBoolean()) {
                return false;
            }
            bidderFields.set(DEALS_ONLY, (JsonNode)BooleanNode.TRUE);
            return true;
        }

        private static boolean modifyNonBidderFields(ObjectNode impExt, boolean generateBidRequestId, boolean hasStoredBidRequest, IdGenerator tidGenerator) {
            JsonNode impExtTid = Optional.of(impExt).map(extNode -> extNode.get(TID)).filter(JsonNode::isTextual).orElse(null);
            String populatedTid = Ortb2ImplicitParametersResolver.populateTidValue(Optional.ofNullable(impExtTid).map(JsonNode::asText).orElse(null), generateBidRequestId, hasStoredBidRequest, tidGenerator);
            if (populatedTid != null) {
                impExt.set(TID, (JsonNode)new TextNode(populatedTid));
                return true;
            }
            return false;
        }

        public Imp getImp() {
            return this.imp;
        }

        public Imp getPopulatedImp() {
            return this.populatedImp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImpPopulationContext)) {
                return false;
            }
            ImpPopulationContext other = (ImpPopulationContext)o;
            Imp this$imp = this.getImp();
            Imp other$imp = other.getImp();
            if (this$imp == null ? other$imp != null : !((Object)this$imp).equals(other$imp)) {
                return false;
            }
            Imp this$populatedImp = this.getPopulatedImp();
            Imp other$populatedImp = other.getPopulatedImp();
            return !(this$populatedImp == null ? other$populatedImp != null : !((Object)this$populatedImp).equals(other$populatedImp));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Imp $imp = this.getImp();
            result = result * 59 + ($imp == null ? 43 : ((Object)$imp).hashCode());
            Imp $populatedImp = this.getPopulatedImp();
            result = result * 59 + ($populatedImp == null ? 43 : ((Object)$populatedImp).hashCode());
            return result;
        }

        public String toString() {
            return "Ortb2ImplicitParametersResolver.ImpPopulationContext(imp=" + this.getImp() + ", populatedImp=" + this.getPopulatedImp() + ")";
        }
    }
}

