/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.model;

import com.iab.openrtb.response.Bid;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.prebid.server.auction.model.BidRejectionReason;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.util.MapUtil;

public class BidRejectionTracker {
    private static final Logger logger = LoggerFactory.getLogger(BidRejectionTracker.class);
    private static final ConditionalLogger MULTIPLE_BID_REJECTIONS_LOGGER = new ConditionalLogger("multiple-bid-rejections", logger);
    private static final String WARNING_TEMPLATE = "Bid with imp id: %s for bidder: %s rejected due to: %s, but has been already rejected";
    private final double logSamplingRate;
    private final String bidder;
    private final Set<String> involvedImpIds;
    private final Set<String> succeededImpIds;
    private final Map<String, BidRejectionReason> rejectedImpIds;

    public BidRejectionTracker(String bidder, Set<String> involvedImpIds, double logSamplingRate) {
        this.bidder = bidder;
        this.involvedImpIds = new HashSet<String>(involvedImpIds);
        this.logSamplingRate = logSamplingRate;
        this.succeededImpIds = new HashSet<String>();
        this.rejectedImpIds = new HashMap<String, BidRejectionReason>();
    }

    public void succeed(String impId) {
        if (this.involvedImpIds.contains(impId)) {
            this.succeededImpIds.add(impId);
            this.rejectedImpIds.remove(impId);
        }
    }

    public void succeed(Collection<BidderBid> bids) {
        bids.stream().map(BidderBid::getBid).filter(Objects::nonNull).map(Bid::getImpid).filter(Objects::nonNull).forEach(this::succeed);
    }

    public void restoreFromRejection(Collection<BidderBid> bids) {
        this.succeed(bids);
    }

    public void reject(String impId, BidRejectionReason reason) {
        if (this.involvedImpIds.contains(impId) && !this.rejectedImpIds.containsKey(impId)) {
            this.rejectedImpIds.put(impId, reason);
            this.succeededImpIds.remove(impId);
        } else if (this.rejectedImpIds.containsKey(impId)) {
            MULTIPLE_BID_REJECTIONS_LOGGER.warn(WARNING_TEMPLATE.formatted(new Object[]{impId, this.bidder, reason}), this.logSamplingRate);
        }
    }

    public void reject(Collection<String> impIds, BidRejectionReason reason) {
        impIds.forEach(impId -> this.reject((String)impId, reason));
    }

    public void rejectAll(BidRejectionReason reason) {
        this.involvedImpIds.forEach(impId -> this.reject((String)impId, reason));
    }

    public Map<String, BidRejectionReason> getRejectionReasons() {
        HashMap<String, BidRejectionReason> missingImpIds = new HashMap<String, BidRejectionReason>();
        for (String impId : this.involvedImpIds) {
            if (this.succeededImpIds.contains(impId) || this.rejectedImpIds.containsKey(impId)) continue;
            missingImpIds.put(impId, BidRejectionReason.NO_BID);
        }
        return MapUtil.merge(missingImpIds, this.rejectedImpIds);
    }
}

