/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.gpp;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.prebid.server.auction.gpp.model.GppContext;
import org.prebid.server.auction.gpp.model.GppContextWrapper;
import org.prebid.server.auction.gpp.processor.GppContextProcessor;

public class GppService {
    private final List<GppContextProcessor> processors;

    public GppService(List<GppContextProcessor> processors) {
        this.processors = Objects.requireNonNull(processors);
    }

    public GppContextWrapper processContext(GppContextWrapper initialGppContextWrapper) {
        GppContext localContext = initialGppContextWrapper.getGppContext();
        ArrayList<String> errors = new ArrayList<String>(initialGppContextWrapper.getErrors());
        for (GppContextProcessor processor : this.processors) {
            GppContextWrapper gppContextWrapper = processor.process(localContext);
            localContext = gppContextWrapper.getGppContext();
            errors.addAll(gppContextWrapper.getErrors());
        }
        return GppContextWrapper.of(localContext, errors);
    }
}

