/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.categorymapping;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.CpmRange;
import org.prebid.server.auction.PriceGranularity;
import org.prebid.server.auction.categorymapping.CategoryMappingService;
import org.prebid.server.auction.model.BidderResponse;
import org.prebid.server.auction.model.CategoryMappingResult;
import org.prebid.server.auction.requestfactory.Ortb2ImplicitParametersResolver;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderSeatBid;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtIncludeBrandCategory;
import org.prebid.server.proto.openrtb.ext.request.ExtDealTier;
import org.prebid.server.proto.openrtb.ext.request.ExtImp;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtMediaTypePriceGranularity;
import org.prebid.server.proto.openrtb.ext.request.ExtPriceGranularity;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestTargeting;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidVideo;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.util.ObjectUtil;

public class BasicCategoryMappingService
implements CategoryMappingService {
    private static final TypeReference<Map<String, DealTierContainer>> EXT_IMP_DEAL_TIER_REFERENCE = new TypeReference<Map<String, DealTierContainer>>(){};
    private static final String FREEWHEEL_AD_SERVER = "freewheel";
    private static final String DFP_AD_SERVER = "dfp";
    private final ApplicationSettings applicationSettings;
    private final JacksonMapper jacksonMapper;

    public BasicCategoryMappingService(ApplicationSettings applicationSettings, JacksonMapper jacksonMapper) {
        this.applicationSettings = Objects.requireNonNull(applicationSettings);
        this.jacksonMapper = Objects.requireNonNull(jacksonMapper);
    }

    @Override
    public Future<CategoryMappingResult> createCategoryMapping(List<BidderResponse> bidderResponses, BidRequest bidRequest, Timeout timeout) {
        ExtRequestTargeting targeting = BasicCategoryMappingService.targeting(bidRequest);
        ExtIncludeBrandCategory includeBrandCategory = ObjectUtil.getIfNotNull(targeting, ExtRequestTargeting::getIncludebrandcategory);
        if (includeBrandCategory == null) {
            return Future.succeededFuture((Object)CategoryMappingResult.of(bidderResponses));
        }
        boolean withCategory = BooleanUtils.toBooleanDefaultIfNull((Boolean)includeBrandCategory.getWithCategory(), (boolean)false);
        boolean translateCategories = BooleanUtils.toBooleanDefaultIfNull((Boolean)includeBrandCategory.getTranslateCategories(), (boolean)true);
        String primaryAdServer = withCategory && translateCategories ? BasicCategoryMappingService.getPrimaryAdServer(includeBrandCategory.getPrimaryAdserver()) : null;
        String publisher = withCategory && translateCategories ? includeBrandCategory.getPublisher() : null;
        ArrayList<RejectedBid> rejectedBids = new ArrayList<RejectedBid>();
        return this.makeBidderToBidCategory(bidderResponses, withCategory, translateCategories, primaryAdServer, publisher, rejectedBids, timeout).map(categoryBidContexts -> this.resolveBidsCategoriesDurations(bidderResponses, (List<CategoryBidContext>)categoryBidContexts, bidRequest, targeting, withCategory, (List<RejectedBid>)rejectedBids));
    }

    private static ExtRequestTargeting targeting(BidRequest bidRequest) {
        ExtRequest ext = bidRequest.getExt();
        ExtRequestPrebid prebid = ext != null ? ext.getPrebid() : null;
        return prebid != null ? prebid.getTargeting() : null;
    }

    private static String getPrimaryAdServer(Integer primaryAdServer) {
        if (primaryAdServer == null) {
            throw new InvalidRequestException("Primary ad server required but was not defined when translate category is enabled");
        }
        return switch (primaryAdServer) {
            case 1 -> FREEWHEEL_AD_SERVER;
            case 2 -> DFP_AD_SERVER;
            default -> throw new InvalidRequestException("Primary ad server `%s` is not recognized".formatted(primaryAdServer));
        };
    }

    private Future<List<CategoryBidContext>> makeBidderToBidCategory(List<BidderResponse> bidderResponses, boolean withCategory, boolean translateCategories, String primaryAdServer, String publisher, List<RejectedBid> rejectedBids, Timeout timeout) {
        Promise categoryBidContextsPromise = Promise.promise();
        CompositeFuture compositeFuture = CompositeFuture.join(bidderResponses.stream().flatMap(bidderResponse -> this.makeFetchCategoryFutures((BidderResponse)bidderResponse, primaryAdServer, publisher, timeout, withCategory, translateCategories)).collect(Collectors.toList()));
        compositeFuture.onComplete(ignored -> BasicCategoryMappingService.collectCategoryFetchResults(compositeFuture, (Promise<List<CategoryBidContext>>)categoryBidContextsPromise, rejectedBids));
        return categoryBidContextsPromise.future();
    }

    private Stream<Future<CategoryBidContext>> makeFetchCategoryFutures(BidderResponse bidderResponse, String primaryAdServer, String publisher, Timeout timeout, boolean withCategory, boolean translateCategories) {
        List<BidderBid> bidderBids = bidderResponse.getSeatBid().getBids();
        String bidder = bidderResponse.getBidder();
        return bidderBids.stream().map(bidderBid -> this.resolveCategory(primaryAdServer, publisher, (BidderBid)bidderBid, bidder, timeout, withCategory, translateCategories));
    }

    private Future<CategoryBidContext> resolveCategory(String primaryAdServer, String publisher, BidderBid bidderBid, String bidder, Timeout timeout, boolean withCategory, boolean translateCategories) {
        String category;
        Bid bid = bidderBid.getBid();
        String videoPrimaryCategory = this.getVideoBidPrimaryCategory(bidderBid);
        if (StringUtils.isNotBlank((CharSequence)videoPrimaryCategory)) {
            return Future.succeededFuture((Object)CategoryBidContext.of(bidderBid, bidder, videoPrimaryCategory));
        }
        if (!withCategory) {
            return Future.succeededFuture((Object)CategoryBidContext.of(bidderBid, bidder, null));
        }
        List iabCategories = ListUtils.emptyIfNull(bid.getCat());
        if (iabCategories.size() > 1) {
            return Future.failedFuture((Throwable)new RejectedBidException(bid.getId(), bidder, "Bid has more than one category"));
        }
        String string = category = CollectionUtils.isNotEmpty((Collection)iabCategories) ? (String)iabCategories.get(0) : null;
        if (StringUtils.isBlank((CharSequence)category)) {
            return Future.failedFuture((Throwable)new RejectedBidException(bid.getId(), bidder, "Bid did not contain a category"));
        }
        return translateCategories ? this.fetchCategory(bidderBid, bidder, primaryAdServer, publisher, category, timeout) : Future.succeededFuture((Object)CategoryBidContext.of(bidderBid, bidder, category));
    }

    private String getVideoBidPrimaryCategory(BidderBid bidderBid) {
        String wrapperVideoPrimaryCategory = ObjectUtil.getIfNotNull(bidderBid.getVideoInfo(), ExtBidPrebidVideo::getPrimaryCategory);
        if (wrapperVideoPrimaryCategory != null) {
            return wrapperVideoPrimaryCategory;
        }
        ObjectNode bidExt = bidderBid.getBid().getExt();
        ExtBidPrebid extPrebid = bidExt != null ? this.toExtBidPrebid(bidExt) : null;
        ExtBidPrebidVideo extVideo = extPrebid != null ? extPrebid.getVideo() : null;
        return extVideo != null ? extVideo.getPrimaryCategory() : null;
    }

    private ExtBidPrebid toExtBidPrebid(ObjectNode ext) {
        try {
            return (ExtBidPrebid)this.jacksonMapper.mapper().treeToValue((TreeNode)ext, ExtBidPrebid.class);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private Future<CategoryBidContext> fetchCategory(BidderBid bidderBid, String bidder, String primaryAdServer, String publisher, String category, Timeout timeout) {
        String bidId = bidderBid.getBid().getId();
        return this.applicationSettings.getCategories(primaryAdServer, publisher, timeout).map(fetchedCategories -> BasicCategoryMappingService.findAndValidateCategory(fetchedCategories, category, bidId, bidder, primaryAdServer, publisher)).recover(throwable -> this.wrapWithRejectedBidException(bidId, bidder, (Throwable)throwable)).map(fetchedCategory -> CategoryBidContext.of(bidderBid, bidder, fetchedCategory));
    }

    private static String findAndValidateCategory(Map<String, String> fetchedCategories, String category, String bidId, String bidder, String primaryAdServer, String publisher) {
        if (MapUtils.isEmpty(fetchedCategories)) {
            throw new RejectedBidException(bidId, bidder, "Category mapping data for primary ad server: '%s', publisher: '%s' not found".formatted(primaryAdServer, publisher));
        }
        String categoryId = fetchedCategories.get(category);
        if (StringUtils.isEmpty((CharSequence)categoryId)) {
            throw new RejectedBidException(bidId, bidder, "Category mapping data for primary ad server: '%s', publisher: '%s' does not contain category for cat = '%s'".formatted(primaryAdServer, publisher, category));
        }
        return categoryId;
    }

    private Future<String> wrapWithRejectedBidException(String bidId, String bidder, Throwable throwable) {
        return Future.failedFuture((Throwable)new RejectedBidException(bidId, bidder, throwable.getMessage()));
    }

    private static void collectCategoryFetchResults(CompositeFuture compositeFuture, Promise<List<CategoryBidContext>> resultPromise, List<RejectedBid> rejectedBids) {
        ArrayList<CategoryBidContext> categoryBidContexts = new ArrayList<CategoryBidContext>();
        for (int i = 0; i < compositeFuture.list().size(); ++i) {
            Object o = compositeFuture.resultAt(i);
            if (o != null) {
                categoryBidContexts.add((CategoryBidContext)o);
                continue;
            }
            RejectedBidException rejectedBidException = (RejectedBidException)compositeFuture.cause(i);
            rejectedBids.add(rejectedBidException.getBid());
        }
        resultPromise.complete(categoryBidContexts);
    }

    private CategoryMappingResult resolveBidsCategoriesDurations(List<BidderResponse> bidderResponses, List<CategoryBidContext> categoryBidContexts, BidRequest bidRequest, ExtRequestTargeting targeting, boolean withCategory, List<RejectedBid> rejectedBids) {
        PriceGranularity priceGranularity = this.resolvePriceGranularity(targeting);
        List durations = ListUtils.emptyIfNull(targeting.getDurationrangesec()).stream().sorted().toList();
        ArrayList<String> errors = new ArrayList<String>();
        Map impIdToBiddersDealTear = BasicCategoryMappingService.isSupportedForDeals(bidRequest) ? this.extractDealTierPerImpAndBidder(bidRequest.getImp(), errors) : Collections.emptyMap();
        boolean appendBidderNames = BooleanUtils.toBooleanDefaultIfNull((Boolean)targeting.getAppendbiddernames(), (boolean)false);
        Map<String, Set<CategoryBidContext>> uniqueCatKeysToCategoryBids = categoryBidContexts.stream().map(categoryBidContext -> this.enrichCategoryBidContext((CategoryBidContext)categoryBidContext, durations, priceGranularity, withCategory, appendBidderNames, impIdToBiddersDealTear, rejectedBids)).filter(Objects::nonNull).collect(Collectors.groupingBy(CategoryBidContext::getCategoryUniqueKey, Collectors.mapping(Function.identity(), Collectors.toSet())));
        rejectedBids.addAll(BasicCategoryMappingService.collectRejectedDuplicatedBids(uniqueCatKeysToCategoryBids));
        errors.addAll(rejectedBids.stream().map(RejectedBid::getErrorMessage).toList());
        return CategoryMappingResult.of(BasicCategoryMappingService.makeBidderToBidCategoryDuration(uniqueCatKeysToCategoryBids, rejectedBids), this.makeBidsSatisfiedPriority(uniqueCatKeysToCategoryBids), BasicCategoryMappingService.removeRejectedBids(bidderResponses, rejectedBids), errors);
    }

    private PriceGranularity resolvePriceGranularity(ExtRequestTargeting targeting) {
        PriceGranularity videoPriceGranularity = this.resolveVideoMediaTypePriceGranularity(targeting);
        return videoPriceGranularity != null ? videoPriceGranularity : this.createPriceGranularity(targeting.getPricegranularity(), "pricegranularity");
    }

    private PriceGranularity resolveVideoMediaTypePriceGranularity(ExtRequestTargeting targeting) {
        ExtMediaTypePriceGranularity extMediaTypePriceGranularity = targeting.getMediatypepricegranularity();
        return extMediaTypePriceGranularity != null ? this.createPriceGranularity((JsonNode)extMediaTypePriceGranularity.getVideo(), "mediatypepricegranularity.video") : null;
    }

    private PriceGranularity createPriceGranularity(JsonNode nodePriceGranularity, String path) {
        ExtPriceGranularity extPriceGranularity = nodePriceGranularity != null && !nodePriceGranularity.isNull() ? this.parsePriceGranularity(nodePriceGranularity, path) : null;
        return extPriceGranularity != null ? PriceGranularity.createFromExtPriceGranularity(extPriceGranularity) : null;
    }

    private ExtPriceGranularity parsePriceGranularity(JsonNode priceGranularity, String path) {
        try {
            return (ExtPriceGranularity)this.jacksonMapper.mapper().treeToValue((TreeNode)priceGranularity, ExtPriceGranularity.class);
        }
        catch (JsonProcessingException e) {
            throw new PreBidException("Error decoding bidRequest.prebid.targeting.%s: %s".formatted(path, e.getMessage()), e);
        }
    }

    private static boolean isSupportedForDeals(BidRequest bidRequest) {
        ExtRequestPrebid prebid = ObjectUtil.getIfNotNull(bidRequest.getExt(), ExtRequest::getPrebid);
        return prebid != null && BooleanUtils.toBooleanDefaultIfNull((Boolean)prebid.getSupportdeals(), (boolean)false);
    }

    private Map<String, Map<String, ExtDealTier>> extractDealTierPerImpAndBidder(List<Imp> imps, List<String> errors) {
        return imps.stream().collect(Collectors.toMap(Imp::getId, imp -> this.extractBidderToDealTiers((Imp)imp, errors)));
    }

    private Map<String, ExtDealTier> extractBidderToDealTiers(Imp imp, List<String> errors) {
        ObjectNode impExt = imp.getExt();
        Map bidderToImpExtDealTier = (Map)this.jacksonMapper.mapper().convertValue((Object)impExt, EXT_IMP_DEAL_TIER_REFERENCE);
        ExtImp extImp = this.parseImpExt(impExt);
        ExtImpPrebid extImpPrebid = extImp != null ? extImp.getPrebid() : null;
        ObjectNode bidders = extImpPrebid != null ? extImpPrebid.getBidder() : null;
        Map bidderToImpExtPrebidDealTier = bidders != null ? (Map)this.jacksonMapper.mapper().convertValue((Object)bidders, EXT_IMP_DEAL_TIER_REFERENCE) : Collections.emptyMap();
        bidderToImpExtPrebidDealTier.forEach((bidder, dealTierContainer) -> bidderToImpExtDealTier.merge(bidder, dealTierContainer, (value1, value2) -> value2));
        return bidderToImpExtDealTier.entrySet().stream().filter(entry -> BasicCategoryMappingService.isValidBidder((String)entry.getKey())).filter(entry -> BasicCategoryMappingService.isValidExtDealTier((DealTierContainer)entry.getValue(), (String)entry.getKey(), imp.getId(), errors)).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((DealTierContainer)entry.getValue()).getDealTier()));
    }

    private ExtImp parseImpExt(ObjectNode impExt) {
        try {
            return (ExtImp)this.jacksonMapper.mapper().treeToValue((TreeNode)impExt, ExtImp.class);
        }
        catch (JsonProcessingException e) {
            throw new PreBidException("Failed to decode imp.ext");
        }
    }

    private static boolean isValidBidder(String bidder) {
        return Ortb2ImplicitParametersResolver.isImpExtBidder(bidder);
    }

    private static boolean isValidExtDealTier(DealTierContainer dealTierContainer, String bidder, String impId, List<String> errors) {
        ExtDealTier dealTier = ObjectUtil.getIfNotNull(dealTierContainer, DealTierContainer::getDealTier);
        if (dealTier == null) {
            errors.add("DealTier configuration not defined for bidder '%s', imp ID '%s'".formatted(bidder, impId));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)dealTier.getPrefix())) {
            errors.add("DealTier configuration not valid for bidder '%s', imp ID '%s' with a reason: dealTier.prefix empty string or null".formatted(bidder, impId));
            return false;
        }
        Integer minDealTier = dealTier.getMinDealTier();
        if (minDealTier == null || minDealTier <= 0) {
            errors.add("DealTier configuration not valid for bidder '%s', imp ID '%s' with a reason: dealTier.minDealTier should be larger than 0, but was %s".formatted(bidder, impId, minDealTier));
            return false;
        }
        return true;
    }

    private static boolean isNotRejected(String bidId, String bidder, List<RejectedBid> rejectedBids) {
        return rejectedBids.stream().noneMatch(rejectedBid -> rejectedBid.getBidId().equals(bidId) && rejectedBid.getBidder().equals(bidder));
    }

    private CategoryBidContext enrichCategoryBidContext(CategoryBidContext categoryBidContext, List<Integer> durations, PriceGranularity priceGranularity, boolean withCategory, boolean appendBidderName, Map<String, Map<String, ExtDealTier>> impToBiddersDealTier, List<RejectedBid> rejectedBids) {
        int duration;
        BidderBid bidderBid = categoryBidContext.getBidderBid();
        Bid bid = bidderBid.getBid();
        String bidder = categoryBidContext.getBidder();
        try {
            duration = this.resolveDuration(durations, bidderBid, bidder);
        }
        catch (RejectedBidException e) {
            rejectedBids.add(e.getBid());
            return null;
        }
        BigDecimal price = CpmRange.fromCpmAsNumber(bid.getPrice(), priceGranularity);
        String rowPrice = CpmRange.format(price, priceGranularity.getPrecision());
        String category = categoryBidContext.getCategory();
        String categoryUniqueKey = this.createCategoryUniqueKey(withCategory, category, rowPrice, duration);
        Map<String, ExtDealTier> impsDealTiers = impToBiddersDealTier.get(bid.getImpid());
        ExtDealTier dealTier = impsDealTiers != null ? impsDealTiers.get(bidder) : null;
        int dealPriority = bidderBid.getDealPriority() != null ? bidderBid.getDealPriority() : 0;
        boolean satisfiedPriority = dealTier != null && dealPriority >= dealTier.getMinDealTier();
        String categoryDuration = BasicCategoryMappingService.createCategoryDuration(rowPrice, category, duration, satisfiedPriority, dealTier, withCategory, appendBidderName, bidder);
        return categoryBidContext.toBuilder().categoryUniqueKey(categoryUniqueKey).satisfiedPriority(satisfiedPriority).categoryDuration(categoryDuration).price(price).build();
    }

    private Integer resolveDuration(List<Integer> durations, BidderBid bidderBid, String bidder) {
        int duration;
        ExtBidPrebidVideo video = bidderBid.getVideoInfo();
        Integer videoDuration = video != null ? video.getDuration() : null;
        int n = duration = videoDuration != null ? videoDuration : 0;
        if (CollectionUtils.isEmpty(durations)) {
            return duration;
        }
        String bidId = bidderBid.getBid().getId();
        int maxDuration = durations.get(durations.size() - 1);
        if (duration > maxDuration) {
            throw new RejectedBidException(bidId, bidder, "Bid duration '%s' exceeds maximum '%s'".formatted(duration, maxDuration));
        }
        return durations.stream().filter(targetingDuration -> duration <= targetingDuration).findFirst().orElseThrow(() -> new RejectedBidException(bidId, bidder, "Duration is not in targeting range"));
    }

    private String createCategoryUniqueKey(boolean withCategory, String category, String price, int duration) {
        return withCategory ? category : "%s_%ds".formatted(price, duration);
    }

    private static String createCategoryDuration(String price, String category, int duration, boolean satisfiedPriority, ExtDealTier dealTier, boolean withCategory, boolean appendBidderName, String bidder) {
        String categoryPrefix = dealTier != null && satisfiedPriority ? dealTier.getPrefix() + dealTier.getMinDealTier() : price;
        String categoryDuration = withCategory ? "%s_%s_%ds".formatted(categoryPrefix, category, duration) : "%s_%ds".formatted(categoryPrefix, duration);
        return appendBidderName ? "%s_%s".formatted(categoryDuration, bidder) : categoryDuration;
    }

    private static Set<RejectedBid> collectRejectedDuplicatedBids(Map<String, Set<CategoryBidContext>> categoryToDuplicatedCategoryBids) {
        return categoryToDuplicatedCategoryBids.values().stream().filter(categoryBids -> categoryBids.size() > 1).flatMap(BasicCategoryMappingService::getDuplicatedForCategory).map(categoryBidContext -> RejectedBid.of(BasicCategoryMappingService.extractBidId(categoryBidContext), categoryBidContext.getBidder(), "Bid was deduplicated")).collect(Collectors.toSet());
    }

    private static Map<Bid, String> makeBidderToBidCategoryDuration(Map<String, Set<CategoryBidContext>> categoryToBidsWithBidder, List<RejectedBid> rejectedBids) {
        return categoryToBidsWithBidder.values().stream().flatMap(Collection::stream).filter(categoryBidContext -> BasicCategoryMappingService.isNotRejected(BasicCategoryMappingService.extractBidId(categoryBidContext), categoryBidContext.getBidder(), rejectedBids)).collect(Collectors.toMap(categoryBidContext -> categoryBidContext.getBidderBid().getBid(), CategoryBidContext::getCategoryDuration));
    }

    private Map<Bid, Boolean> makeBidsSatisfiedPriority(Map<String, Set<CategoryBidContext>> uniqueCatKeysToCategoryBids) {
        return uniqueCatKeysToCategoryBids.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(categoryBidContext -> categoryBidContext.getBidderBid().getBid(), CategoryBidContext::isSatisfiedPriority));
    }

    private static List<BidderResponse> removeRejectedBids(List<BidderResponse> bidderResponses, List<RejectedBid> rejectedBids) {
        Map bidderToRejectedBidIds = rejectedBids.stream().collect(Collectors.groupingBy(RejectedBid::getBidder, Collectors.mapping(RejectedBid::getBidId, Collectors.toList())));
        return bidderResponses.stream().map(bidderResponse -> bidderToRejectedBidIds.containsKey(bidderResponse.getBidder()) ? BasicCategoryMappingService.removeRejectedBids(bidderResponse, (List)bidderToRejectedBidIds.get(bidderResponse.getBidder())) : bidderResponse).toList();
    }

    private static BidderResponse removeRejectedBids(BidderResponse bidderResponse, List<String> rejectedBidIds) {
        String bidder = bidderResponse.getBidder();
        BidderSeatBid bidderSeatBid = bidderResponse.getSeatBid();
        List<BidderBid> survivedBidderBids = bidderSeatBid.getBids().stream().filter(bidderBid -> !rejectedBidIds.contains(bidderBid.getBid().getId())).toList();
        return BidderResponse.of(bidder, bidderSeatBid.with(survivedBidderBids), bidderResponse.getResponseTime());
    }

    private static Stream<CategoryBidContext> getDuplicatedForCategory(Set<CategoryBidContext> categoryBidContexts) {
        CategoryBidContext highestPriceBid = categoryBidContexts.stream().max(Comparator.comparing(CategoryBidContext::getPrice)).orElseThrow(() -> new PreBidException("Can't find bid with highest price."));
        return categoryBidContexts.stream().filter(categoryBidContext -> ObjectUtils.notEqual((Object)highestPriceBid, (Object)categoryBidContext));
    }

    private static String extractBidId(CategoryBidContext categoryBidContext) {
        return categoryBidContext.getBidderBid().getBid().getId();
    }

    private static final class CategoryBidContext {
        private final BidderBid bidderBid;
        private final String bidder;
        private final String category;
        private final String categoryDuration;
        private final String categoryUniqueKey;
        private final BigDecimal price;
        private final boolean satisfiedPriority;

        public static CategoryBidContext of(BidderBid bidderBid, String bidder, String category) {
            return CategoryBidContext.builder().bidderBid(bidderBid).bidder(bidder).category(category).build();
        }

        @ConstructorProperties(value={"bidderBid", "bidder", "category", "categoryDuration", "categoryUniqueKey", "price", "satisfiedPriority"})
        CategoryBidContext(BidderBid bidderBid, String bidder, String category, String categoryDuration, String categoryUniqueKey, BigDecimal price, boolean satisfiedPriority) {
            this.bidderBid = bidderBid;
            this.bidder = bidder;
            this.category = category;
            this.categoryDuration = categoryDuration;
            this.categoryUniqueKey = categoryUniqueKey;
            this.price = price;
            this.satisfiedPriority = satisfiedPriority;
        }

        public static CategoryBidContextBuilder builder() {
            return new CategoryBidContextBuilder();
        }

        public CategoryBidContextBuilder toBuilder() {
            return new CategoryBidContextBuilder().bidderBid(this.bidderBid).bidder(this.bidder).category(this.category).categoryDuration(this.categoryDuration).categoryUniqueKey(this.categoryUniqueKey).price(this.price).satisfiedPriority(this.satisfiedPriority);
        }

        public BidderBid getBidderBid() {
            return this.bidderBid;
        }

        public String getBidder() {
            return this.bidder;
        }

        public String getCategory() {
            return this.category;
        }

        public String getCategoryDuration() {
            return this.categoryDuration;
        }

        public String getCategoryUniqueKey() {
            return this.categoryUniqueKey;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public boolean isSatisfiedPriority() {
            return this.satisfiedPriority;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CategoryBidContext)) {
                return false;
            }
            CategoryBidContext other = (CategoryBidContext)o;
            if (this.isSatisfiedPriority() != other.isSatisfiedPriority()) {
                return false;
            }
            BidderBid this$bidderBid = this.getBidderBid();
            BidderBid other$bidderBid = other.getBidderBid();
            if (this$bidderBid == null ? other$bidderBid != null : !((Object)this$bidderBid).equals(other$bidderBid)) {
                return false;
            }
            String this$bidder = this.getBidder();
            String other$bidder = other.getBidder();
            if (this$bidder == null ? other$bidder != null : !this$bidder.equals(other$bidder)) {
                return false;
            }
            String this$category = this.getCategory();
            String other$category = other.getCategory();
            if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                return false;
            }
            String this$categoryDuration = this.getCategoryDuration();
            String other$categoryDuration = other.getCategoryDuration();
            if (this$categoryDuration == null ? other$categoryDuration != null : !this$categoryDuration.equals(other$categoryDuration)) {
                return false;
            }
            String this$categoryUniqueKey = this.getCategoryUniqueKey();
            String other$categoryUniqueKey = other.getCategoryUniqueKey();
            if (this$categoryUniqueKey == null ? other$categoryUniqueKey != null : !this$categoryUniqueKey.equals(other$categoryUniqueKey)) {
                return false;
            }
            BigDecimal this$price = this.getPrice();
            BigDecimal other$price = other.getPrice();
            return !(this$price == null ? other$price != null : !((Object)this$price).equals(other$price));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSatisfiedPriority() ? 79 : 97);
            BidderBid $bidderBid = this.getBidderBid();
            result = result * 59 + ($bidderBid == null ? 43 : ((Object)$bidderBid).hashCode());
            String $bidder = this.getBidder();
            result = result * 59 + ($bidder == null ? 43 : $bidder.hashCode());
            String $category = this.getCategory();
            result = result * 59 + ($category == null ? 43 : $category.hashCode());
            String $categoryDuration = this.getCategoryDuration();
            result = result * 59 + ($categoryDuration == null ? 43 : $categoryDuration.hashCode());
            String $categoryUniqueKey = this.getCategoryUniqueKey();
            result = result * 59 + ($categoryUniqueKey == null ? 43 : $categoryUniqueKey.hashCode());
            BigDecimal $price = this.getPrice();
            result = result * 59 + ($price == null ? 43 : ((Object)$price).hashCode());
            return result;
        }

        public String toString() {
            return "BasicCategoryMappingService.CategoryBidContext(bidderBid=" + this.getBidderBid() + ", bidder=" + this.getBidder() + ", category=" + this.getCategory() + ", categoryDuration=" + this.getCategoryDuration() + ", categoryUniqueKey=" + this.getCategoryUniqueKey() + ", price=" + this.getPrice() + ", satisfiedPriority=" + this.isSatisfiedPriority() + ")";
        }

        public static class CategoryBidContextBuilder {
            private BidderBid bidderBid;
            private String bidder;
            private String category;
            private String categoryDuration;
            private String categoryUniqueKey;
            private BigDecimal price;
            private boolean satisfiedPriority;

            CategoryBidContextBuilder() {
            }

            public CategoryBidContextBuilder bidderBid(BidderBid bidderBid) {
                this.bidderBid = bidderBid;
                return this;
            }

            public CategoryBidContextBuilder bidder(String bidder) {
                this.bidder = bidder;
                return this;
            }

            public CategoryBidContextBuilder category(String category) {
                this.category = category;
                return this;
            }

            public CategoryBidContextBuilder categoryDuration(String categoryDuration) {
                this.categoryDuration = categoryDuration;
                return this;
            }

            public CategoryBidContextBuilder categoryUniqueKey(String categoryUniqueKey) {
                this.categoryUniqueKey = categoryUniqueKey;
                return this;
            }

            public CategoryBidContextBuilder price(BigDecimal price) {
                this.price = price;
                return this;
            }

            public CategoryBidContextBuilder satisfiedPriority(boolean satisfiedPriority) {
                this.satisfiedPriority = satisfiedPriority;
                return this;
            }

            public CategoryBidContext build() {
                return new CategoryBidContext(this.bidderBid, this.bidder, this.category, this.categoryDuration, this.categoryUniqueKey, this.price, this.satisfiedPriority);
            }

            public String toString() {
                return "BasicCategoryMappingService.CategoryBidContext.CategoryBidContextBuilder(bidderBid=" + this.bidderBid + ", bidder=" + this.bidder + ", category=" + this.category + ", categoryDuration=" + this.categoryDuration + ", categoryUniqueKey=" + this.categoryUniqueKey + ", price=" + this.price + ", satisfiedPriority=" + this.satisfiedPriority + ")";
            }
        }
    }

    private static class RejectedBidException
    extends RuntimeException {
        private final RejectedBid rejectedBid;

        RejectedBidException(String bidId, String bidder, String error) {
            super(error);
            this.rejectedBid = RejectedBid.of(bidId, bidder, error);
        }

        public RejectedBid getBid() {
            return this.rejectedBid;
        }
    }

    private static final class RejectedBid {
        private final String bidId;
        private final String bidder;
        private final String errorMessage;

        private static RejectedBid of(String bidId, String bidder, String errorMessage) {
            return new RejectedBid(bidId, bidder, "Bid rejected [bidder: %s, bid ID: %s] with a reason: %s".formatted(bidder, bidId, errorMessage));
        }

        @ConstructorProperties(value={"bidId", "bidder", "errorMessage"})
        public RejectedBid(String bidId, String bidder, String errorMessage) {
            this.bidId = bidId;
            this.bidder = bidder;
            this.errorMessage = errorMessage;
        }

        public String getBidId() {
            return this.bidId;
        }

        public String getBidder() {
            return this.bidder;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RejectedBid)) {
                return false;
            }
            RejectedBid other = (RejectedBid)o;
            String this$bidId = this.getBidId();
            String other$bidId = other.getBidId();
            if (this$bidId == null ? other$bidId != null : !this$bidId.equals(other$bidId)) {
                return false;
            }
            String this$bidder = this.getBidder();
            String other$bidder = other.getBidder();
            if (this$bidder == null ? other$bidder != null : !this$bidder.equals(other$bidder)) {
                return false;
            }
            String this$errorMessage = this.getErrorMessage();
            String other$errorMessage = other.getErrorMessage();
            return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $bidId = this.getBidId();
            result = result * 59 + ($bidId == null ? 43 : $bidId.hashCode());
            String $bidder = this.getBidder();
            result = result * 59 + ($bidder == null ? 43 : $bidder.hashCode());
            String $errorMessage = this.getErrorMessage();
            result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
            return result;
        }

        public String toString() {
            return "BasicCategoryMappingService.RejectedBid(bidId=" + this.getBidId() + ", bidder=" + this.getBidder() + ", errorMessage=" + this.getErrorMessage() + ")";
        }
    }

    private static final class DealTierContainer {
        @JsonProperty(value="dealTier")
        private final ExtDealTier dealTier;

        @ConstructorProperties(value={"dealTier"})
        private DealTierContainer(ExtDealTier dealTier) {
            this.dealTier = dealTier;
        }

        public static DealTierContainer of(ExtDealTier dealTier) {
            return new DealTierContainer(dealTier);
        }

        public ExtDealTier getDealTier() {
            return this.dealTier;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DealTierContainer)) {
                return false;
            }
            DealTierContainer other = (DealTierContainer)o;
            ExtDealTier this$dealTier = this.getDealTier();
            ExtDealTier other$dealTier = other.getDealTier();
            return !(this$dealTier == null ? other$dealTier != null : !((Object)this$dealTier).equals(other$dealTier));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ExtDealTier $dealTier = this.getDealTier();
            result = result * 59 + ($dealTier == null ? 43 : ((Object)$dealTier).hashCode());
            return result;
        }

        public String toString() {
            return "BasicCategoryMappingService.DealTierContainer(dealTier=" + this.getDealTier() + ")";
        }
    }
}

