/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.iab.openrtb.request.Deal;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Pmp;
import com.iab.openrtb.response.Bid;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.auction.model.BidInfo;

public class WinningBidComparatorFactory {
    private static final Comparator<BidInfo> WINNING_BID_PRICE_COMPARATOR = new WinningBidPriceComparator();
    private static final Comparator<BidInfo> WINNING_BID_DEAL_COMPARATOR = new WinningBidDealComparator();
    private static final Comparator<BidInfo> WINNING_BID_PG_COMPARATOR = new WinningBidPgComparator();
    private static final Comparator<BidInfo> BID_INFO_COMPARATOR = WINNING_BID_PG_COMPARATOR.thenComparing(WINNING_BID_DEAL_COMPARATOR).thenComparing(WINNING_BID_PRICE_COMPARATOR);
    private static final Comparator<BidInfo> PREFER_PRICE_COMPARATOR = WINNING_BID_PG_COMPARATOR.thenComparing(WINNING_BID_PRICE_COMPARATOR);

    public Comparator<BidInfo> create(boolean preferDeals) {
        return preferDeals ? BID_INFO_COMPARATOR : PREFER_PRICE_COMPARATOR;
    }

    private static class WinningBidPriceComparator
    implements Comparator<BidInfo> {
        private static final Comparator<BidInfo> PRICE_COMPARATOR = Comparator.comparing(o -> o.getBid().getPrice());

        private WinningBidPriceComparator() {
        }

        @Override
        public int compare(BidInfo bidInfo1, BidInfo bidInfo2) {
            Imp imp = bidInfo1.getCorrespondingImp();
            if (!Objects.equals(imp, bidInfo2.getCorrespondingImp())) {
                throw new IllegalStateException("Error while determining winning bid: Multiple bids was found for impId: " + imp.getId());
            }
            return PRICE_COMPARATOR.compare(bidInfo1, bidInfo2);
        }
    }

    private static class WinningBidDealComparator
    implements Comparator<BidInfo> {
        private WinningBidDealComparator() {
        }

        @Override
        public int compare(BidInfo bidInfo1, BidInfo bidInfo2) {
            boolean isPresentBidDealId2;
            boolean isPresentBidDealId1 = bidInfo1.getBid().getDealid() != null;
            boolean bl = isPresentBidDealId2 = bidInfo2.getBid().getDealid() != null;
            if (!Boolean.logicalXor(isPresentBidDealId1, isPresentBidDealId2)) {
                return 0;
            }
            return isPresentBidDealId1 ? 1 : -1;
        }
    }

    private static class WinningBidPgComparator
    implements Comparator<BidInfo> {
        private final Comparator<Integer> dealIndexComparator = Comparator.comparingInt(Integer::intValue).reversed();

        private WinningBidPgComparator() {
        }

        @Override
        public int compare(BidInfo bidInfo1, BidInfo bidInfo2) {
            boolean isOneOrBothDealIdNotPresent;
            List<Deal> impDeals;
            Imp imp = bidInfo1.getCorrespondingImp();
            Pmp pmp = imp.getPmp();
            List<Deal> list = impDeals = pmp != null ? pmp.getDeals() : null;
            if (CollectionUtils.isEmpty(impDeals)) {
                return 0;
            }
            Bid bid1 = bidInfo1.getBid();
            Bid bid2 = bidInfo2.getBid();
            int indexOfBidDealId1 = -1;
            int indexOfBidDealId2 = -1;
            for (int i = 0; i < impDeals.size(); ++i) {
                String dealId = impDeals.get(i).getId();
                if (Objects.equals(dealId, bid1.getDealid())) {
                    indexOfBidDealId1 = i;
                }
                if (!Objects.equals(dealId, bid2.getDealid())) continue;
                indexOfBidDealId2 = i;
            }
            boolean isPresentImpDealId1 = indexOfBidDealId1 != -1;
            boolean isPresentImpDealId2 = indexOfBidDealId2 != -1;
            boolean bl = isOneOrBothDealIdNotPresent = !isPresentImpDealId1 || !isPresentImpDealId2;
            return isOneOrBothDealIdNotPresent ? (isPresentImpDealId1 ? 1 : -1) : this.dealIndexComparator.compare(indexOfBidDealId1, indexOfBidDealId2);
        }
    }
}

