/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Video;
import java.util.List;
import java.util.Objects;
import org.prebid.server.proto.openrtb.ext.request.ImpMediaType;
import org.prebid.server.proto.openrtb.ext.response.BidType;

public class ImpMediaTypeResolver {
    private ImpMediaTypeResolver() {
    }

    public static ImpMediaType resolve(String bidImpId, List<Imp> imps, BidType bidType) {
        return switch (bidType) {
            default -> throw new IncompatibleClassChangeError();
            case BidType.banner -> ImpMediaType.banner;
            case BidType.xNative -> ImpMediaType.xNative;
            case BidType.audio -> ImpMediaType.audio;
            case BidType.video -> ImpMediaTypeResolver.resolveBidAdjustmentVideoMediaType(bidImpId, imps);
        };
    }

    private static ImpMediaType resolveBidAdjustmentVideoMediaType(String bidImpId, List<Imp> imps) {
        Video bidImpVideo = imps.stream().filter(imp -> imp.getId().equals(bidImpId)).map(Imp::getVideo).filter(Objects::nonNull).findFirst().orElse(null);
        if (bidImpVideo == null) {
            return null;
        }
        Integer placement = bidImpVideo.getPlacement();
        return placement == null || Objects.equals(placement, 1) ? ImpMediaType.video : ImpMediaType.video_outstream;
    }
}

