/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Data;
import com.iab.openrtb.request.Dooh;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.json.JsonMerger;
import org.prebid.server.proto.openrtb.ext.request.ExtApp;
import org.prebid.server.proto.openrtb.ext.request.ExtBidderConfig;
import org.prebid.server.proto.openrtb.ext.request.ExtBidderConfigOrtb;
import org.prebid.server.proto.openrtb.ext.request.ExtDooh;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidBidderConfig;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebidData;
import org.prebid.server.proto.openrtb.ext.request.ExtSite;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.request.Targeting;

public class FpdResolver {
    private static final String USER = "user";
    private static final String SITE = "site";
    private static final String BIDDERS = "bidders";
    private static final String APP = "app";
    private static final String DOOH = "dooh";
    private static final Set<String> KNOWN_FPD_ATTRIBUTES = Set.of("user", "site", "app", "dooh", "bidders");
    private static final String ALLOW_ALL_BIDDERS = "*";
    private static final String EXT = "ext";
    private static final String CONTEXT = "context";
    private static final String DATA = "data";
    private static final Set<String> USER_DATA_ATTR = Collections.singleton("geo");
    private static final Set<String> APP_DATA_ATTR = Set.of("id", "content", "publisher", "privacypolicy");
    private static final Set<String> SITE_DATA_ATTR = Set.of("id", "content", "publisher", "privacypolicy", "mobile");
    private static final Set<String> DOOH_DATA_ATTR = Set.of("id", "content", "publisher", "privacypolicy");
    private static final TypeReference<List<Data>> USER_DATA_TYPE_REFERENCE = new TypeReference<List<Data>>(){};
    private final JacksonMapper jacksonMapper;
    private final JsonMerger jsonMerger;

    public FpdResolver(JacksonMapper jacksonMapper, JsonMerger jsonMerger) {
        this.jacksonMapper = Objects.requireNonNull(jacksonMapper);
        this.jsonMerger = Objects.requireNonNull(jsonMerger);
    }

    public User resolveUser(User originUser, ObjectNode fpdUser) {
        if (fpdUser == null) {
            return originUser;
        }
        User resultUser = originUser == null ? User.builder().build() : originUser;
        ExtUser resolvedExtUser = this.resolveUserExt(fpdUser, resultUser);
        return resultUser.toBuilder().keywords((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdUser, "keywords"), (Object)resultUser.getKeywords())).gender((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdUser, "gender"), (Object)resultUser.getGender())).yob((Integer)ObjectUtils.defaultIfNull((Object)FpdResolver.getInteger(fpdUser, "yob"), (Object)resultUser.getYob())).data((List)ObjectUtils.defaultIfNull(this.getFpdUserData(fpdUser), resultUser.getData())).ext(resolvedExtUser).build();
    }

    private ExtUser resolveUserExt(ObjectNode fpdUser, User originUser) {
        ExtUser originExtUser = originUser.getExt();
        ObjectNode resolvedData = this.mergeExtData(fpdUser.path(EXT).path(DATA), (JsonNode)(originExtUser != null ? originExtUser.getData() : null));
        return this.updateUserExtDataWithFpdAttr(fpdUser, originExtUser, resolvedData);
    }

    private ExtUser updateUserExtDataWithFpdAttr(ObjectNode fpdUser, ExtUser originExtUser, ObjectNode extData) {
        ObjectNode resultData = extData != null ? extData : this.jacksonMapper.mapper().createObjectNode();
        USER_DATA_ATTR.forEach(attribute -> FpdResolver.setAttr(fpdUser, resultData, attribute));
        return originExtUser != null ? originExtUser.toBuilder().data(resultData.isEmpty() ? null : resultData).build() : (resultData.isEmpty() ? null : ExtUser.builder().data(resultData).build());
    }

    private List<Data> getFpdUserData(ObjectNode fpdUser) {
        ArrayNode fpdUserDataNode = FpdResolver.getValueFromJsonNode(fpdUser, DATA, node -> (ArrayNode)node, JsonNode::isArray);
        return this.toList((JsonNode)fpdUserDataNode, USER_DATA_TYPE_REFERENCE);
    }

    public App resolveApp(App originApp, ObjectNode fpdApp) {
        if (fpdApp == null) {
            return originApp;
        }
        App resultApp = originApp == null ? App.builder().build() : originApp;
        ExtApp resolvedExtApp = this.resolveAppExt(fpdApp, resultApp);
        return resultApp.toBuilder().name((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdApp, "name"), (Object)resultApp.getName())).bundle((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdApp, "bundle"), (Object)resultApp.getBundle())).storeurl((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdApp, "storeurl"), (Object)resultApp.getStoreurl())).domain((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdApp, "domain"), (Object)resultApp.getDomain())).cat((List)ObjectUtils.defaultIfNull(FpdResolver.getStrings((JsonNode)fpdApp, "cat"), resultApp.getCat())).sectioncat((List)ObjectUtils.defaultIfNull(FpdResolver.getStrings((JsonNode)fpdApp, "sectioncat"), resultApp.getSectioncat())).pagecat((List)ObjectUtils.defaultIfNull(FpdResolver.getStrings((JsonNode)fpdApp, "pagecat"), resultApp.getPagecat())).keywords((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdApp, "keywords"), (Object)resultApp.getKeywords())).ext(resolvedExtApp).build();
    }

    private ExtApp resolveAppExt(ObjectNode fpdApp, App originApp) {
        ExtApp originExtApp = originApp.getExt();
        ObjectNode resolvedData = this.mergeExtData(fpdApp.path(EXT).path(DATA), (JsonNode)(originExtApp != null ? originExtApp.getData() : null));
        return this.updateAppExtDataWithFpdAttr(fpdApp, originExtApp, resolvedData);
    }

    private ExtApp updateAppExtDataWithFpdAttr(ObjectNode fpdApp, ExtApp originExtApp, ObjectNode extData) {
        ObjectNode resultData = extData != null ? extData : this.jacksonMapper.mapper().createObjectNode();
        APP_DATA_ATTR.forEach(attribute -> FpdResolver.setAttr(fpdApp, resultData, attribute));
        return originExtApp != null ? ExtApp.of(originExtApp.getPrebid(), resultData.isEmpty() ? null : resultData) : (resultData.isEmpty() ? null : ExtApp.of(null, resultData));
    }

    public Site resolveSite(Site originSite, ObjectNode fpdSite) {
        if (fpdSite == null) {
            return originSite;
        }
        Site resultSite = originSite == null ? Site.builder().build() : originSite;
        ExtSite resolvedExtSite = this.resolveSiteExt(fpdSite, resultSite);
        return resultSite.toBuilder().name((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdSite, "name"), (Object)resultSite.getName())).domain((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdSite, "domain"), (Object)resultSite.getDomain())).cat((List)ObjectUtils.defaultIfNull(FpdResolver.getStrings((JsonNode)fpdSite, "cat"), resultSite.getCat())).sectioncat((List)ObjectUtils.defaultIfNull(FpdResolver.getStrings((JsonNode)fpdSite, "sectioncat"), resultSite.getSectioncat())).pagecat((List)ObjectUtils.defaultIfNull(FpdResolver.getStrings((JsonNode)fpdSite, "pagecat"), resultSite.getPagecat())).page((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdSite, "page"), (Object)resultSite.getPage())).keywords((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdSite, "keywords"), (Object)resultSite.getKeywords())).ref((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdSite, "ref"), (Object)resultSite.getRef())).search((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdSite, "search"), (Object)resultSite.getSearch())).ext(resolvedExtSite).build();
    }

    private ExtSite resolveSiteExt(ObjectNode fpdSite, Site originSite) {
        ExtSite originExtSite = originSite.getExt();
        ObjectNode resolvedData = this.mergeExtData(fpdSite.path(EXT).path(DATA), (JsonNode)(originExtSite != null ? originExtSite.getData() : null));
        return this.updateSiteExtDataWithFpdAttr(fpdSite, originExtSite, resolvedData);
    }

    private ExtSite updateSiteExtDataWithFpdAttr(ObjectNode fpdSite, ExtSite originExtSite, ObjectNode extData) {
        ObjectNode resultData = extData != null ? extData : this.jacksonMapper.mapper().createObjectNode();
        SITE_DATA_ATTR.forEach(attribute -> FpdResolver.setAttr(fpdSite, resultData, attribute));
        return originExtSite != null ? ExtSite.of(originExtSite.getAmp(), resultData.isEmpty() ? null : resultData) : (resultData.isEmpty() ? null : ExtSite.of(null, resultData));
    }

    public Dooh resolveDooh(Dooh originDooh, ObjectNode fpdDooh) {
        if (fpdDooh == null) {
            return originDooh;
        }
        Dooh resultDooh = originDooh == null ? Dooh.builder().build() : originDooh;
        ExtDooh resolvedExtDooh = this.resolveDoohExt(fpdDooh, resultDooh);
        return resultDooh.toBuilder().name((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdDooh, "name"), (Object)resultDooh.getName())).venuetype((List)ObjectUtils.defaultIfNull(FpdResolver.getStrings((JsonNode)fpdDooh, "venuetype"), resultDooh.getVenuetype())).venuetypetax((Integer)ObjectUtils.defaultIfNull((Object)FpdResolver.getInteger(fpdDooh, "venuetypetax"), (Object)resultDooh.getVenuetypetax())).domain((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdDooh, "domain"), (Object)resultDooh.getDomain())).keywords((String)ObjectUtils.defaultIfNull((Object)FpdResolver.getString(fpdDooh, "keywords"), (Object)resultDooh.getKeywords())).ext(resolvedExtDooh).build();
    }

    private ExtDooh resolveDoohExt(ObjectNode fpdDooh, Dooh originDooh) {
        ExtDooh originExtDooh = originDooh.getExt();
        ObjectNode resolvedData = this.mergeExtData(fpdDooh.path(EXT).path(DATA), (JsonNode)(originExtDooh != null ? originExtDooh.getData() : null));
        return this.updateDoohExtDataWithFpdAttr(fpdDooh, originExtDooh, resolvedData);
    }

    private ExtDooh updateDoohExtDataWithFpdAttr(ObjectNode fpdDooh, ExtDooh originExtDooh, ObjectNode extData) {
        ObjectNode resultData = extData != null ? extData : this.jacksonMapper.mapper().createObjectNode();
        DOOH_DATA_ATTR.forEach(attribute -> FpdResolver.setAttr(fpdDooh, resultData, attribute));
        return originExtDooh != null ? ExtDooh.of(resultData.isEmpty() ? null : resultData) : (resultData.isEmpty() ? null : ExtDooh.of(resultData));
    }

    public ObjectNode resolveImpExt(ObjectNode impExt, ObjectNode targeting) {
        if (targeting == null) {
            return impExt;
        }
        KNOWN_FPD_ATTRIBUTES.forEach(arg_0 -> ((ObjectNode)targeting).remove(arg_0));
        if (!targeting.fieldNames().hasNext()) {
            return impExt;
        }
        if (impExt == null) {
            return (ObjectNode)this.jacksonMapper.mapper().createObjectNode().set(DATA, (JsonNode)targeting);
        }
        JsonNode extImpData = impExt.get(DATA);
        ObjectNode resolvedData = extImpData != null ? (ObjectNode)this.jsonMerger.merge((JsonNode)targeting, extImpData) : targeting;
        return (ObjectNode)impExt.set(DATA, (JsonNode)resolvedData);
    }

    public ObjectNode resolveImpExt(ObjectNode impExt, boolean useFirstPartyData) {
        this.removeOrReplace(impExt, CONTEXT, this.sanitizeImpExtContext(impExt, useFirstPartyData));
        this.removeOrReplace(impExt, DATA, this.sanitizeImpExtData(impExt, useFirstPartyData));
        return impExt;
    }

    private JsonNode sanitizeImpExtContext(ObjectNode originalImpExt, boolean useFirstPartyData) {
        if (!originalImpExt.hasNonNull(CONTEXT)) {
            return null;
        }
        JsonNode updatedContextNode = originalImpExt.get(CONTEXT).deepCopy();
        if (!useFirstPartyData && updatedContextNode.hasNonNull(DATA)) {
            ((ObjectNode)updatedContextNode).remove(DATA);
        }
        return updatedContextNode.isObject() && updatedContextNode.isEmpty() ? null : updatedContextNode;
    }

    private JsonNode sanitizeImpExtData(ObjectNode impExt, boolean useFirstPartyData) {
        JsonNode mergedDataNode;
        boolean contextDataIsObject;
        if (!useFirstPartyData) {
            return null;
        }
        JsonNode contextNode = impExt.hasNonNull(CONTEXT) ? impExt.get(CONTEXT) : null;
        JsonNode contextDataNode = contextNode != null && contextNode.hasNonNull(DATA) ? contextNode.get(DATA) : null;
        JsonNode dataNode = impExt.get(DATA);
        boolean dataIsNullOrObject = dataNode == null || dataNode.isObject();
        boolean bl = contextDataIsObject = contextDataNode != null && !contextDataNode.isNull() && contextDataNode.isObject();
        JsonNode jsonNode = dataIsNullOrObject && contextDataIsObject ? (dataNode != null ? this.jsonMerger.merge(contextDataNode, dataNode) : contextDataNode) : (mergedDataNode = dataNode);
        if (mergedDataNode != null && !mergedDataNode.isNull()) {
            return mergedDataNode;
        }
        return null;
    }

    private void removeOrReplace(ObjectNode impExt, String field, JsonNode jsonNode) {
        if (jsonNode == null) {
            impExt.remove(field);
        } else {
            impExt.set(field, jsonNode);
        }
    }

    public ExtRequest resolveBidRequestExt(ExtRequest extRequest, Targeting targeting) {
        if (targeting == null) {
            return extRequest;
        }
        ExtRequestPrebid extRequestPrebid = extRequest != null ? extRequest.getPrebid() : null;
        ExtRequestPrebidData extRequestPrebidData = extRequestPrebid != null ? extRequestPrebid.getData() : null;
        ExtRequestPrebidData resolvedExtRequestPrebidData = this.resolveExtRequestPrebidData(extRequestPrebidData, targeting.getBidders());
        List<ExtRequestPrebidBidderConfig> resolvedBidderConfig = this.createAllowedAllBidderConfig(targeting);
        if (resolvedExtRequestPrebidData != null || resolvedBidderConfig != null) {
            ExtRequestPrebid.ExtRequestPrebidBuilder prebidBuilder = extRequestPrebid != null ? extRequestPrebid.toBuilder() : ExtRequestPrebid.builder();
            return ExtRequest.of(prebidBuilder.data(resolvedExtRequestPrebidData != null ? resolvedExtRequestPrebidData : extRequestPrebidData).bidderconfig(resolvedBidderConfig).build());
        }
        return extRequest;
    }

    private ExtRequestPrebidData resolveExtRequestPrebidData(ExtRequestPrebidData data, List<String> fpdBidders) {
        if (CollectionUtils.isEmpty(fpdBidders)) {
            return null;
        }
        List<String> originBidders = data != null ? data.getBidders() : Collections.emptyList();
        return CollectionUtils.isEmpty(originBidders) ? ExtRequestPrebidData.of(fpdBidders, null) : ExtRequestPrebidData.of(this.mergeBidders(fpdBidders, originBidders), null);
    }

    private List<String> mergeBidders(List<String> fpdBidders, List<String> originBidders) {
        TreeSet<String> resolvedBidders = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        resolvedBidders.addAll(originBidders);
        resolvedBidders.addAll(fpdBidders);
        return new ArrayList<String>(resolvedBidders);
    }

    private List<ExtRequestPrebidBidderConfig> createAllowedAllBidderConfig(Targeting targeting) {
        ObjectNode userNode = targeting.getUser();
        ObjectNode siteNode = targeting.getSite();
        if (userNode == null && siteNode == null) {
            return null;
        }
        List<String> bidders = Collections.singletonList(ALLOW_ALL_BIDDERS);
        return Collections.singletonList(ExtRequestPrebidBidderConfig.of(bidders, ExtBidderConfig.of(null, ExtBidderConfigOrtb.of(siteNode, null, null, userNode))));
    }

    private ObjectNode mergeExtData(JsonNode fpdData, JsonNode originData) {
        if (fpdData.isMissingNode() || !fpdData.isObject()) {
            return originData != null && originData.isObject() ? ((ObjectNode)originData).deepCopy() : null;
        }
        if (originData != null && originData.isObject()) {
            return (ObjectNode)this.jsonMerger.merge(fpdData, originData);
        }
        return fpdData.isObject() ? (ObjectNode)fpdData : null;
    }

    private static void setAttr(ObjectNode source, ObjectNode dest, String fieldName) {
        JsonNode field = source.get(fieldName);
        if (field != null) {
            dest.set(fieldName, field);
        }
    }

    private static List<String> getStrings(JsonNode firstItem, String fieldName) {
        JsonNode valueNode = firstItem.get(fieldName);
        ArrayNode arrayNode = valueNode != null && valueNode.isArray() ? (ArrayNode)valueNode : null;
        return arrayNode != null && FpdResolver.isTextualArray(arrayNode) ? StreamSupport.stream(arrayNode.spliterator(), false).map(JsonNode::asText).toList() : null;
    }

    private static boolean isTextualArray(ArrayNode arrayNode) {
        return StreamSupport.stream(arrayNode.spliterator(), false).allMatch(JsonNode::isTextual);
    }

    private static String getString(ObjectNode firstItem, String fieldName) {
        return FpdResolver.getValueFromJsonNode(firstItem, fieldName, JsonNode::asText, JsonNode::isTextual);
    }

    private static Integer getInteger(ObjectNode firstItem, String fieldName) {
        return FpdResolver.getValueFromJsonNode(firstItem, fieldName, JsonNode::asInt, JsonNode::isInt);
    }

    private <T> List<T> toList(JsonNode node, TypeReference<List<T>> listTypeReference) {
        try {
            return (List)this.jacksonMapper.mapper().convertValue((Object)node, listTypeReference);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static <T> T getValueFromJsonNode(ObjectNode firstItem, String fieldName, Function<JsonNode, T> nodeConverter, Predicate<JsonNode> isCorrectType) {
        JsonNode valueNode = firstItem.get(fieldName);
        return valueNode != null && isCorrectType.test(valueNode) ? (T)nodeConverter.apply(valueNode) : null;
    }
}

