/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.analytics.model;

import com.iab.openrtb.response.BidResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.model.HttpRequestContext;

public final class AuctionEvent {
    private final Integer status;
    private final List<String> errors;
    private final HttpRequestContext httpContext;
    private final AuctionContext auctionContext;
    private final BidResponse bidResponse;

    @ConstructorProperties(value={"status", "errors", "httpContext", "auctionContext", "bidResponse"})
    AuctionEvent(Integer status, List<String> errors, HttpRequestContext httpContext, AuctionContext auctionContext, BidResponse bidResponse) {
        this.status = status;
        this.errors = errors;
        this.httpContext = httpContext;
        this.auctionContext = auctionContext;
        this.bidResponse = bidResponse;
    }

    public static AuctionEventBuilder builder() {
        return new AuctionEventBuilder();
    }

    public AuctionEventBuilder toBuilder() {
        return new AuctionEventBuilder().status(this.status).errors(this.errors).httpContext(this.httpContext).auctionContext(this.auctionContext).bidResponse(this.bidResponse);
    }

    public Integer getStatus() {
        return this.status;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public HttpRequestContext getHttpContext() {
        return this.httpContext;
    }

    public AuctionContext getAuctionContext() {
        return this.auctionContext;
    }

    public BidResponse getBidResponse() {
        return this.bidResponse;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuctionEvent)) {
            return false;
        }
        AuctionEvent other = (AuctionEvent)o;
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        List<String> this$errors = this.getErrors();
        List<String> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        HttpRequestContext this$httpContext = this.getHttpContext();
        HttpRequestContext other$httpContext = other.getHttpContext();
        if (this$httpContext == null ? other$httpContext != null : !((Object)this$httpContext).equals(other$httpContext)) {
            return false;
        }
        AuctionContext this$auctionContext = this.getAuctionContext();
        AuctionContext other$auctionContext = other.getAuctionContext();
        if (this$auctionContext == null ? other$auctionContext != null : !((Object)this$auctionContext).equals(other$auctionContext)) {
            return false;
        }
        BidResponse this$bidResponse = this.getBidResponse();
        BidResponse other$bidResponse = other.getBidResponse();
        return !(this$bidResponse == null ? other$bidResponse != null : !((Object)this$bidResponse).equals(other$bidResponse));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        List<String> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        HttpRequestContext $httpContext = this.getHttpContext();
        result = result * 59 + ($httpContext == null ? 43 : ((Object)$httpContext).hashCode());
        AuctionContext $auctionContext = this.getAuctionContext();
        result = result * 59 + ($auctionContext == null ? 43 : ((Object)$auctionContext).hashCode());
        BidResponse $bidResponse = this.getBidResponse();
        result = result * 59 + ($bidResponse == null ? 43 : ((Object)$bidResponse).hashCode());
        return result;
    }

    public String toString() {
        return "AuctionEvent(status=" + this.getStatus() + ", errors=" + this.getErrors() + ", httpContext=" + this.getHttpContext() + ", auctionContext=" + this.getAuctionContext() + ", bidResponse=" + this.getBidResponse() + ")";
    }

    public static class AuctionEventBuilder {
        private Integer status;
        private List<String> errors;
        private HttpRequestContext httpContext;
        private AuctionContext auctionContext;
        private BidResponse bidResponse;

        AuctionEventBuilder() {
        }

        public AuctionEventBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public AuctionEventBuilder errors(List<String> errors) {
            this.errors = errors;
            return this;
        }

        public AuctionEventBuilder httpContext(HttpRequestContext httpContext) {
            this.httpContext = httpContext;
            return this;
        }

        public AuctionEventBuilder auctionContext(AuctionContext auctionContext) {
            this.auctionContext = auctionContext;
            return this;
        }

        public AuctionEventBuilder bidResponse(BidResponse bidResponse) {
            this.bidResponse = bidResponse;
            return this;
        }

        public AuctionEvent build() {
            return new AuctionEvent(this.status, this.errors, this.httpContext, this.auctionContext, this.bidResponse);
        }

        public String toString() {
            return "AuctionEvent.AuctionEventBuilder(status=" + this.status + ", errors=" + this.errors + ", httpContext=" + this.httpContext + ", auctionContext=" + this.auctionContext + ", bidResponse=" + this.bidResponse + ")";
        }
    }
}

