/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.rule;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Set;
import org.prebid.server.activity.ComponentType;
import org.prebid.server.activity.infrastructure.debug.Loggable;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.rule.AbstractMatchRule;

public final class ComponentRule
extends AbstractMatchRule
implements Loggable {
    private final Set<ComponentType> componentTypes;
    private final Set<String> componentNames;
    private final boolean allowed;

    public ComponentRule(Set<ComponentType> componentTypes, Set<String> componentNames, boolean allowed) {
        this.componentTypes = componentTypes;
        this.componentNames = componentNames;
        this.allowed = allowed;
    }

    @Override
    public boolean matches(ActivityInvocationPayload activityInvocationPayload) {
        return !(this.componentTypes != null && !this.componentTypes.contains((Object)activityInvocationPayload.componentType()) || this.componentNames != null && !this.componentNames.contains(activityInvocationPayload.componentName()));
    }

    @Override
    public boolean allowed() {
        return this.allowed;
    }

    @Override
    public JsonNode asLogEntry(ObjectMapper mapper) {
        return mapper.valueToTree((Object)new ComponentRuleLogEntry(this.componentTypes, this.componentNames, this.allowed));
    }

    private record ComponentRuleLogEntry(Set<ComponentType> componentTypes, Set<String> componentNames, boolean allow) {
    }
}

