/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.privacy.usnat.inner;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.prebid.server.activity.infrastructure.debug.Loggable;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.privacy.PrivacyModule;
import org.prebid.server.activity.infrastructure.privacy.usnat.USNatGppReader;
import org.prebid.server.activity.infrastructure.privacy.usnat.debug.USNatModuleLogEntry;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.Gpc;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.KnownChildSensitiveDataConsent;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.MspaServiceProviderMode;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.PersonalDataConsents;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SaleOptOut;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SaleOptOutNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SensitiveDataLimitUseNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SensitiveDataProcessing;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SensitiveDataProcessingOptOutNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SharingNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SharingOptOut;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SharingOptOutNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.TargetedAdvertisingOptOut;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.TargetedAdvertisingOptOutNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.USNatField;
import org.prebid.server.activity.infrastructure.rule.Rule;

public class USNatTransmitUfpd
implements PrivacyModule,
Loggable {
    private static final Set<Integer> SENSITIVE_DATA_INDICES_SET_1 = Set.of(0, 1, 2, 3, 4, 5, 6, 8, 9, 10, 11);
    private static final Set<Integer> SENSITIVE_DATA_INDICES_SET_2 = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(10));
    private static final Set<Integer> SENSITIVE_DATA_INDICES_SET_3 = Set.of(Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(8), Integer.valueOf(9), Integer.valueOf(11));
    private final USNatGppReader gppReader;
    private final Rule.Result result;

    public USNatTransmitUfpd(USNatGppReader gppReader) {
        this.gppReader = gppReader;
        this.result = USNatTransmitUfpd.disallow(gppReader) ? Rule.Result.DISALLOW : Rule.Result.ALLOW;
    }

    @Override
    public Rule.Result proceed(ActivityInvocationPayload activityInvocationPayload) {
        return this.result;
    }

    public static boolean disallow(USNatGppReader gppReader) {
        return USNatTransmitUfpd.equals(gppReader.getMspaServiceProviderMode(), MspaServiceProviderMode.YES) || USNatTransmitUfpd.equals(gppReader.getGpc(), Gpc.TRUE) || USNatTransmitUfpd.checkSale(gppReader) || USNatTransmitUfpd.checkSharing(gppReader) || USNatTransmitUfpd.checkTargetedAdvertising(gppReader) || USNatTransmitUfpd.checkSensitiveData(gppReader) || USNatTransmitUfpd.checkKnownChildSensitiveDataConsents(gppReader) || USNatTransmitUfpd.equals(gppReader.getPersonalDataConsents(), PersonalDataConsents.CONSENT);
    }

    private static boolean checkSale(USNatGppReader gppReader) {
        Integer saleOptOut = gppReader.getSaleOptOut();
        Integer saleOptOutNotice = gppReader.getSaleOptOutNotice();
        return USNatTransmitUfpd.equals(saleOptOut, SaleOptOut.OPTED_OUT) || USNatTransmitUfpd.equals(saleOptOutNotice, SaleOptOutNotice.NO) || USNatTransmitUfpd.equals(saleOptOutNotice, SaleOptOutNotice.NOT_APPLICABLE) && USNatTransmitUfpd.equals(saleOptOut, SaleOptOut.DID_NOT_OPT_OUT);
    }

    private static boolean checkSharing(USNatGppReader gppReader) {
        Integer sharingNotice = gppReader.getSharingNotice();
        Integer sharingOptOut = gppReader.getSharingOptOut();
        Integer sharingOptOutNotice = gppReader.getSharingOptOutNotice();
        return USNatTransmitUfpd.equals(sharingNotice, SharingNotice.NO) || USNatTransmitUfpd.equals(sharingOptOut, SharingOptOut.OPTED_OUT) || USNatTransmitUfpd.equals(sharingOptOutNotice, SharingOptOutNotice.NO) || USNatTransmitUfpd.equals(sharingNotice, SharingNotice.NOT_APPLICABLE) && USNatTransmitUfpd.equals(sharingOptOut, SharingOptOut.DID_NOT_OPT_OUT) || USNatTransmitUfpd.equals(sharingOptOutNotice, SharingOptOutNotice.NOT_APPLICABLE) && USNatTransmitUfpd.equals(sharingOptOut, SharingOptOut.DID_NOT_OPT_OUT);
    }

    private static boolean checkTargetedAdvertising(USNatGppReader gppReader) {
        Integer targetedAdvertisingOptOut = gppReader.getTargetedAdvertisingOptOut();
        Integer targetedAdvertisingOptOutNotice = gppReader.getTargetedAdvertisingOptOutNotice();
        return USNatTransmitUfpd.equals(targetedAdvertisingOptOut, TargetedAdvertisingOptOut.OPTED_OUT) || USNatTransmitUfpd.equals(targetedAdvertisingOptOutNotice, TargetedAdvertisingOptOutNotice.NO) || USNatTransmitUfpd.equals(targetedAdvertisingOptOutNotice, TargetedAdvertisingOptOutNotice.NOT_APPLICABLE) && USNatTransmitUfpd.equals(targetedAdvertisingOptOut, TargetedAdvertisingOptOut.DID_NOT_OPT_OUT);
    }

    private static boolean checkSensitiveData(USNatGppReader gppReader) {
        Integer sensitiveDataProcessingOptOutNotice = gppReader.getSensitiveDataProcessingOptOutNotice();
        Integer sensitiveDataLimitUseNotice = gppReader.getSensitiveDataLimitUseNotice();
        List<Integer> sensitiveDataProcessing = gppReader.getSensitiveDataProcessing();
        return USNatTransmitUfpd.equals(sensitiveDataProcessingOptOutNotice, SensitiveDataProcessingOptOutNotice.NO) || USNatTransmitUfpd.equals(sensitiveDataLimitUseNotice, SensitiveDataLimitUseNotice.NO) || (USNatTransmitUfpd.equals(sensitiveDataProcessingOptOutNotice, SensitiveDataProcessingOptOutNotice.NOT_APPLICABLE) || USNatTransmitUfpd.equals(sensitiveDataLimitUseNotice, SensitiveDataLimitUseNotice.NOT_APPLICABLE)) && USNatTransmitUfpd.anyEqualsAtIndices(SensitiveDataProcessing.CONSENT, sensitiveDataProcessing, SENSITIVE_DATA_INDICES_SET_1) || USNatTransmitUfpd.anyEqualsAtIndices(SensitiveDataProcessing.NO_CONSENT, sensitiveDataProcessing, SENSITIVE_DATA_INDICES_SET_2) || USNatTransmitUfpd.anyEqualsAtIndices(SensitiveDataProcessing.NO_CONSENT, sensitiveDataProcessing, SENSITIVE_DATA_INDICES_SET_3) || USNatTransmitUfpd.anyEqualsAtIndices(SensitiveDataProcessing.CONSENT, sensitiveDataProcessing, SENSITIVE_DATA_INDICES_SET_3);
    }

    private static boolean checkKnownChildSensitiveDataConsents(USNatGppReader gppReader) {
        List<Integer> knownChildSensitiveDataConsents = gppReader.getKnownChildSensitiveDataConsents();
        return USNatTransmitUfpd.equalsAtIndex(KnownChildSensitiveDataConsent.NO_CONSENT, knownChildSensitiveDataConsents, 0) || USNatTransmitUfpd.equalsAtIndex(KnownChildSensitiveDataConsent.NO_CONSENT, knownChildSensitiveDataConsents, 1) || USNatTransmitUfpd.equalsAtIndex(KnownChildSensitiveDataConsent.CONSENT, knownChildSensitiveDataConsents, 1);
    }

    private static <T> boolean anyEqualsAtIndices(USNatField<T> expectedValue, List<T> list, Set<Integer> indices) {
        return indices.stream().anyMatch(index -> USNatTransmitUfpd.equalsAtIndex(expectedValue, list, index));
    }

    private static <T> boolean equalsAtIndex(USNatField<T> expectedValue, List<T> list, int index) {
        return list != null && list.size() > index && USNatTransmitUfpd.equals(list.get(index), expectedValue);
    }

    private static <T> boolean equals(T providedValue, USNatField<T> expectedValue) {
        return Objects.equals(providedValue, expectedValue.value());
    }

    @Override
    public JsonNode asLogEntry(ObjectMapper mapper) {
        return USNatModuleLogEntry.from(this, this.gppReader, this.result);
    }
}

