/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.privacy.usnat.inner;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import org.prebid.server.activity.infrastructure.debug.Loggable;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.privacy.PrivacyModule;
import org.prebid.server.activity.infrastructure.privacy.usnat.USNatGppReader;
import org.prebid.server.activity.infrastructure.privacy.usnat.debug.USNatModuleLogEntry;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.Gpc;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.KnownChildSensitiveDataConsent;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.MspaServiceProviderMode;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.PersonalDataConsents;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SensitiveDataLimitUseNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SensitiveDataProcessing;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.SensitiveDataProcessingOptOutNotice;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.model.USNatField;
import org.prebid.server.activity.infrastructure.rule.Rule;

public class USNatTransmitGeo
implements PrivacyModule,
Loggable {
    private final USNatGppReader gppReader;
    private final Rule.Result result;

    public USNatTransmitGeo(USNatGppReader gppReader) {
        this.gppReader = gppReader;
        this.result = USNatTransmitGeo.disallow(gppReader) ? Rule.Result.DISALLOW : Rule.Result.ALLOW;
    }

    @Override
    public Rule.Result proceed(ActivityInvocationPayload activityInvocationPayload) {
        return this.result;
    }

    public static boolean disallow(USNatGppReader gppReader) {
        return USNatTransmitGeo.equals(gppReader.getMspaServiceProviderMode(), MspaServiceProviderMode.YES) || USNatTransmitGeo.equals(gppReader.getGpc(), Gpc.TRUE) || USNatTransmitGeo.checkSensitiveData(gppReader) || USNatTransmitGeo.checkKnownChildSensitiveDataConsents(gppReader) || USNatTransmitGeo.equals(gppReader.getPersonalDataConsents(), PersonalDataConsents.CONSENT);
    }

    private static boolean checkSensitiveData(USNatGppReader gppReader) {
        Integer sensitiveDataProcessingOptOutNotice = gppReader.getSensitiveDataProcessingOptOutNotice();
        Integer sensitiveDataLimitUseNotice = gppReader.getSensitiveDataLimitUseNotice();
        List<Integer> sensitiveDataProcessing = gppReader.getSensitiveDataProcessing();
        return USNatTransmitGeo.equals(sensitiveDataProcessingOptOutNotice, SensitiveDataProcessingOptOutNotice.NO) || USNatTransmitGeo.equals(sensitiveDataLimitUseNotice, SensitiveDataLimitUseNotice.NO) || (USNatTransmitGeo.equals(sensitiveDataProcessingOptOutNotice, SensitiveDataProcessingOptOutNotice.NOT_APPLICABLE) || USNatTransmitGeo.equals(sensitiveDataLimitUseNotice, SensitiveDataLimitUseNotice.NOT_APPLICABLE)) && USNatTransmitGeo.equalsAtIndex(SensitiveDataProcessing.CONSENT, sensitiveDataProcessing, 7) || USNatTransmitGeo.equalsAtIndex(SensitiveDataProcessing.NO_CONSENT, sensitiveDataProcessing, 7);
    }

    private static boolean checkKnownChildSensitiveDataConsents(USNatGppReader gppReader) {
        List<Integer> knownChildSensitiveDataConsents = gppReader.getKnownChildSensitiveDataConsents();
        return USNatTransmitGeo.equalsAtIndex(KnownChildSensitiveDataConsent.NO_CONSENT, knownChildSensitiveDataConsents, 0) || USNatTransmitGeo.equalsAtIndex(KnownChildSensitiveDataConsent.NO_CONSENT, knownChildSensitiveDataConsents, 1) || USNatTransmitGeo.equalsAtIndex(KnownChildSensitiveDataConsent.CONSENT, knownChildSensitiveDataConsents, 1);
    }

    private static <T> boolean equalsAtIndex(USNatField<T> expectedValue, List<T> list, int index) {
        return list != null && list.size() > index && USNatTransmitGeo.equals(list.get(index), expectedValue);
    }

    private static <T> boolean equals(T providedValue, USNatField<T> expectedValue) {
        return Objects.equals(providedValue, expectedValue.value());
    }

    @Override
    public JsonNode asLogEntry(ObjectMapper mapper) {
        return USNatModuleLogEntry.from(this, this.gppReader, this.result);
    }
}

