/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.privacy.usnat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import org.prebid.server.activity.Activity;
import org.prebid.server.activity.infrastructure.debug.ActivityDebugUtils;
import org.prebid.server.activity.infrastructure.debug.Loggable;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.privacy.PrivacyModule;
import org.prebid.server.activity.infrastructure.privacy.usnat.USNatGppReader;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.USNatDefault;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.USNatSyncUser;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.USNatTransmitGeo;
import org.prebid.server.activity.infrastructure.privacy.usnat.inner.USNatTransmitUfpd;
import org.prebid.server.activity.infrastructure.rule.Rule;

public class USNatModule
implements PrivacyModule,
Loggable {
    private final PrivacyModule innerModule;

    public USNatModule(Activity activity, USNatGppReader gppReader) {
        Objects.requireNonNull(activity);
        Objects.requireNonNull(gppReader);
        this.innerModule = USNatModule.innerModule(activity, gppReader);
    }

    private static PrivacyModule innerModule(Activity activity, USNatGppReader gppReader) {
        return switch (activity) {
            default -> throw new IncompatibleClassChangeError();
            case Activity.SYNC_USER, Activity.MODIFY_UFDP -> new USNatSyncUser(gppReader);
            case Activity.TRANSMIT_UFPD -> new USNatTransmitUfpd(gppReader);
            case Activity.TRANSMIT_GEO -> new USNatTransmitGeo(gppReader);
            case Activity.CALL_BIDDER, Activity.TRANSMIT_TID, Activity.REPORT_ANALYTICS -> USNatDefault.instance();
        };
    }

    @Override
    public Rule.Result proceed(ActivityInvocationPayload activityInvocationPayload) {
        return this.innerModule.proceed(activityInvocationPayload);
    }

    @Override
    public JsonNode asLogEntry(ObjectMapper mapper) {
        return ActivityDebugUtils.asLogEntry(this.innerModule, mapper);
    }
}

