/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure.privacy.uscustomlogic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import io.github.jamsesso.jsonlogic.ast.JsonLogicNode;
import io.github.jamsesso.jsonlogic.evaluator.JsonLogicEvaluationException;
import java.util.Map;
import java.util.function.Supplier;
import org.prebid.server.activity.infrastructure.debug.Loggable;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.privacy.PrivacyModule;
import org.prebid.server.activity.infrastructure.rule.Rule;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.JsonLogic;

public class USCustomLogicModule
implements PrivacyModule,
Loggable {
    private final Rule.Result result;

    public USCustomLogicModule(JsonLogic jsonLogic, JsonLogicNode jsonLogicNode, Supplier<Map<String, Object>> dataSupplier) {
        try {
            this.result = jsonLogic.evaluate(jsonLogicNode, dataSupplier.get()) ? Rule.Result.DISALLOW : Rule.Result.ALLOW;
        }
        catch (JsonLogicEvaluationException e) {
            throw new PreBidException("An error occurred while evaluating the JsonLogic expression: " + e.getMessage());
        }
    }

    @Override
    public Rule.Result proceed(ActivityInvocationPayload activityInvocationPayload) {
        return this.result;
    }

    @Override
    public JsonNode asLogEntry(ObjectMapper mapper) {
        return TextNode.valueOf((String)"%s. Precomputed result: %s.".formatted(new Object[]{this.getClass().getSimpleName(), this.result}));
    }
}

