/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.activity.infrastructure;

import java.util.List;
import java.util.Objects;
import org.prebid.server.activity.infrastructure.debug.ActivityInfrastructureDebug;
import org.prebid.server.activity.infrastructure.payload.ActivityInvocationPayload;
import org.prebid.server.activity.infrastructure.rule.Rule;

public class ActivityController {
    private final boolean allowByDefault;
    private final List<Rule> rules;
    private final ActivityInfrastructureDebug debug;

    private ActivityController(boolean allowByDefault, List<Rule> rules, ActivityInfrastructureDebug debug) {
        this.allowByDefault = allowByDefault;
        this.rules = Objects.requireNonNull(rules);
        this.debug = Objects.requireNonNull(debug);
    }

    public static ActivityController of(boolean allowByDefault, List<Rule> rules, ActivityInfrastructureDebug debug) {
        return new ActivityController(allowByDefault, rules, debug);
    }

    public boolean isAllowed(ActivityInvocationPayload activityInvocationPayload) {
        this.debug.emitActivityInvocationDefaultResult(this.allowByDefault);
        boolean result = this.allowByDefault;
        for (Rule rule : this.rules) {
            Rule.Result ruleResult = rule.proceed(activityInvocationPayload);
            this.debug.emitProcessedRule(rule, ruleResult);
            if (ruleResult == Rule.Result.ABSTAIN) continue;
            result = ruleResult == Rule.Result.ALLOW;
            break;
        }
        return result;
    }
}

