package com.sspBidder.rtbRequest;

//import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
//import com.google.gson.Gson;
import com.sspBidder.entity.AdExchangeZone;
import com.sspBidder.entity.GlobalVariables;
import com.sspBidder.entity.SspExBuyer;
import com.sspBidder.entity.ZoneEn;
import com.sspBidder.helper.Helper;

public class Request {

	
	public static ImageRequest framing_request(AdExchangeZone requesto,List<SspExBuyer> sspbuyers,ZoneEn zonedetails, ImpObjects_pmp_deals pmpdeal,GlobalVariables global) {
		ImageRequest bidrequest = new ImageRequest();
		bidrequest.setId(generateRandomNumber(4)+"-"+generateRandomNumber(15)+"-"+generateRandomNumber(4));
		bidrequest.setTmax(requesto.getReq_tmax());
		bidrequest.setDsp(getdsp(zonedetails,sspbuyers,requesto));
		bidrequest.setImp(getimp(requesto,zonedetails,pmpdeal));
		bidrequest.setSite(getSiteObj(zonedetails,requesto,global));
		bidrequest.setRegs(getRegsObjects(requesto));
		bidrequest.setUser(getUserObjects(requesto));
		bidrequest.setRestr(getRestrictions(requesto));	
		bidrequest.setApp(getAppObj(requesto,zonedetails));	
		bidrequest.setDevice(getDeviceobj(requesto,global));
		return bidrequest;
	}
   
	private static long generateRandomNumber(int length) {
        Random random = new Random();
        StringBuilder sb = new StringBuilder();

        // The first digit should not be 0 to maintain the specified length
        sb.append((1 + random.nextInt(9)));

        // Append the remaining digits
        for(int i = 1; i < length; i++) {
            sb.append(random.nextInt(10));
        }

        return Long.parseLong(sb.toString());
    }
    
	
    public static List<DspObjects> getdsp(ZoneEn zonedetails,List<SspExBuyer> sspbuyers,AdExchangeZone addetails) {
    	List<DspObjects> dsps = new ArrayList<>();
    	

    	  for (SspExBuyer sspbuyer : sspbuyers) {
    		  Map<String, Object> AffAdditional = new HashMap<>();
    		  DspObjects dsp = new DspObjects();
    		  DspObjects_ext ext = new DspObjects_ext();
    		  DspObjects_source source = new DspObjects_source();
    		  DspObjects_ext_ads_txt ads_txt = new DspObjects_ext_ads_txt();
    			dsp.setId(sspbuyer.getExchange_id());
        		dsp.setVersion(String.valueOf(sspbuyer.getOpen_rtb_version()));
        		dsp.setPing_url(sspbuyer.getPing_url());
        		dsp.setAt(sspbuyer.getAuction_type());
        		if ("1".equals(sspbuyer.getOpen_rtb_version()) ||
        			    "2".equals(sspbuyer.getOpen_rtb_version()) ||
        			    "3".equals(sspbuyer.getOpen_rtb_version()) || 
        			    "4".equals(sspbuyer.getOpen_rtb_version())) {
        			dsp.setVersion("2.5");
        			} else if ("5".equals(sspbuyer.getOpen_rtb_version())) {
        				dsp.setVersion("3.0");
        			}
        		if (sspbuyer.getAuction_currency() == 0) {
        			dsp.setCur(new String[]{"USD"});
        		}

        		ads_txt.setStatus(1);
        		ads_txt.setAuth_id(String.valueOf(ZoneEn.getAffiliateid()*123));
        		ads_txt.setPub_id(String.valueOf(ZoneEn.getAffiliateid()));
        		ext.setAds_txt(ads_txt);
        		dsp.setExt(ext);
        		source.setTs(System.currentTimeMillis());
        		source.setDs(String.valueOf(sspbuyer.getDigital_signature()));
        		dsp.setSource(source);
        		dsp.setGzip(sspbuyer.getGzip());
//        		dsp.setBuyer_id();
 
//        		dsp.setSecondBidBuffer(zonedetails.get);
        		  DspObjects_source dspObjSource = new DspObjects_source();
        	        dspObjSource.setTs(Instant.now().toEpochMilli());
        	        dspObjSource.setDs(sspbuyer.getDigital_signature());
        	        dsp.setSource(dspObjSource);
        	  
        	        if (zonedetails.getComments().toString() != ""){
        	        		
        	        		
        	        	AffAdditional = Helper.extractValuesFromSerializedtoMap(zonedetails.getComments());    	        		     	     
        	        }
        	    		
        	        if (zonedetails.getIs_seller_json() == 1 && AffAdditional.get("app_type") != null) {

        	            if (!addetails.getSite_page().isEmpty() || !addetails.getApp_url().isEmpty()) {
        	            	dsp.getSource().getExt().getSchain().setSccomplete(1);
        	            } else {
        	            	dsp.getSource().getExt().getSchain().setSccomplete(0);
        	            }

        	            // Currently supply chain version is 1.0
        	            dsp.getSource().getExt().getSchain().setScversion("1.0");

        	            
        	            if (!AffAdditional.get("app_type").equals("3")) {
        	            	dsp.getSource().getExt().getSchain().getScnodes().setNodes_asi(AffAdditional.get("app_url").toString());
        	            } else {
        	            	//need to paaaaass publisher valueeeeee
//        	            	dsp.getSource().getExt().getSchain().getScnodes().setNodes_asi();
        	            }
//        	            dsp.getSource().getExt().getSchain().getScnodes().setNodes_sid();
        	            //need to rid value through param
//        	            dsp.getSource().getExt().getSchain().getScnodes().setNodes_rid(rid);

        	            // If supply chain version is 1.0, then hp is always 1 else it will be applied with the flow of inventory
        	            dsp.getSource().getExt().getSchain().getScnodes().setNodes_hp(1);
        		
          }
        	        dsps.add(dsp);
    	  }

    	return dsps;
    }


    public static List<ImpImgObjects> getimp(AdExchangeZone addetails,ZoneEn zonedetails, ImpObjects_pmp_deals pmpdeal){
    	List<ImpImgObjects> imps = new ArrayList<>();
    	
    	ImpImgObjects imp = new ImpImgObjects();
    	ImpObjects_banner banner = new ImpObjects_banner();
    	ImpObjects_pmp_deals pmpdeal1 = new ImpObjects_pmp_deals();
    	imp.setId("1");
    	imp.setBidFloor(addetails.getImp_bidfloor()); 
//    	pmp1.setPrivate_auction(0);
//    	pmp1.setDeals(null);
//    	banner.setPos(0);
    	banner.setMimes(Arrays.asList(addetails.getBan_mimes().split(",")));
    	imp.getBanner().setH(zonedetails.getHeight());
    	imp.getBanner().setW(zonedetails.getWidth());
    	imps.add(imp);
//    	System.out.println("Impression Object:"+imps);
    	return imps;
    	
    }
    
    public static SiteObjects getSiteObj(ZoneEn zonedetails, AdExchangeZone znextra,GlobalVariables glob) {
        SiteObjects siteObj = new SiteObjects();
        System.out.println("setDomain  :"+znextra.getPub_domain());
        System.out.println("setPagecat  :"+Arrays.asList(znextra.getSite_page().split(",")));
        
        siteObj.setId(String.valueOf(zonedetails.getZoneid()));
        siteObj.setName(glob.getDomainName());
        siteObj.setDomain(znextra.getPub_domain());
 siteObj.setPage(glob.getPageURL());
        siteObj.setPagecat(Arrays.asList(znextra.getSite_page().split(",")));

        siteObj.getInventory().setCat(Arrays.asList(znextra.getSite_cat().split(",")));
        siteObj.getInventory().setSectioncat(Arrays.asList(znextra.getSite_section().split(",")));
        siteObj.getInventory().setPagecat(Arrays.asList(znextra.getSite_page().split(",")));
        siteObj.getInventory().setPrivacypolicy(znextra.getSite_privacy());
        siteObj.getInventory().setKeywords(znextra.getSite_key());

        siteObj.getInventory().getPublisher().setCat(Arrays.asList(znextra.getPub_cat().split(",")));
        siteObj.getInventory().getPublisher().setDomain(znextra.getPub_domain());

        return siteObj;
    }
 
    public static RegsObjects getRegsObjects(AdExchangeZone znado) {
      	 RegsObjects regsObj = new RegsObjects();
      	 regsObj.setCoppa(1);	
      	 regsObj.setCcpa(znado.getCcpa());
      	 regsObj.setGdpr(znado.getGdpr());
   		return regsObj;     	 
       }
      
    public static UserObjects getUserObjects(AdExchangeZone znus) {
    	UserObjects user = new UserObjects();
    	
    	if (znus.getUser_yob() > 0) {
    		user.setYob(znus.getUser_yob());
    	}
      
	if (znus.getUser_gender() != "") {
		user.setGender(znus.getUser_gender());
    	}
	List<UserObjects_data> userdatas = new ArrayList<>();
	UserObjects_data userdata = new UserObjects_data();
	
	List<Segments> segments = new ArrayList<>();
	Segments segment = new Segments();
	segment.setId("1");
	segment.setName(znus.getSeg_name());
	segment.setValue(znus.getSeg_value());
	segments.add(segment);
	userdata.setSegment(segments);
	userdatas.add(userdata);
	user.setData(userdatas);

		return user;
    }
       
    public static Restrictions getRestrictions(AdExchangeZone znextra) {
    	Restrictions restriObj = new Restrictions();
    	restriObj.setTest(znextra.getReq_test());
    	restriObj.setBadv(znextra.getReq_badv().split(","));
    	restriObj.setBapp(znextra.getReq_bapp().split(","));
    	restriObj.setBcat(znextra.getReq_bcat().split(","));
    	restriObj.setSecure(znextra.getImp_secure());
		return restriObj;
    	
    }
    
    public static AppObject getAppObj(AdExchangeZone znextra,ZoneEn zninfo) {
    	
    	 AppObject appObj = new AppObject();

         Map<Object, Object> AffAdditional = new HashMap<>();
         if (!zninfo.getComments().isEmpty()) {
             // Assuming that phpserialize is a valid library in Java for unmarshalling
//        	 byte[] phpSerializedDataBytes = zninfo.getComments().getBytes(StandardCharsets.UTF_8);
//
//             // Convert byte array to String
//             String phpSerializedData = new String(phpSerializedDataBytes, StandardCharsets.UTF_8);
//
//             
//             AffAdditional = new Gson().fromJson(phpSerializedData, Map.class);
         }

         appObj.setBundle((String) AffAdditional.get("bundle_id"));
         appObj.setStoreUrl((String) AffAdditional.get("app_url"));
//           appObj.setPaid(Integer.parseInt(AffAdditional.get("app_version").toString()));
         

         appObj.getInventory().setCat(Arrays.asList(znextra.getSite_cat().split(",")));
         appObj.getInventory().setSectioncat(Arrays.asList(znextra.getSite_section().split(",")));
         appObj.getInventory().setPagecat(Arrays.asList(znextra.getSite_page().split(",")));
         appObj.getInventory().setPrivacypolicy(znextra.getSite_privacy());
         appObj.getInventory().setKeywords(znextra.getSite_key());

         appObj.getInventory().getPublisher().setCat(Arrays.asList(znextra.getPub_cat().split(",")));
         appObj.getInventory().getPublisher().setDomain(znextra.getPub_domain());
     
		return appObj;
    	
    }
    
    public static DeviceObjects getDeviceobj(AdExchangeZone znextra,GlobalVariables global) {
    	DeviceObjects deviceObj = new DeviceObjects();

          if (znextra.Dev_dnt == 0) {
              deviceObj.setIp(global.getIp_address());
              deviceObj.setUa(global.getUseragent()); 
              deviceObj.setMake(global.getDeviceName()); 
              deviceObj.setModel(global.getDeviceModel());

              switch (global.getDeviceType()) {
                  case "Computer":
                      deviceObj.setDeviceType(2);
                      break;
                  case "Phone":
                      deviceObj.setDeviceType(1);
                      break;
                  case "Tablet":
                      deviceObj.setDeviceType(5);
                      break;
                  case "Tv":
                      deviceObj.setDeviceType(3);
                      break;
                  case "Console":
                      deviceObj.setDeviceType(7);
                      break;
                  default:
                      deviceObj.setDeviceType(2);
              }

              deviceObj.setOs(global.getOs());
              deviceObj.setOsv(global.getOsv());
          }

          return deviceObj;
    	
    }
    
}
