package com.sspBidder.helper;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class Helper {
	 public static int[] extractValuesFromSerializedArray(String serializing) {
	        // Use a regular expression to find all occurrences of s:[number]:"[value]"
	        Pattern pattern = Pattern.compile("s:\\d+:\"(\\d+)\"");
	        Matcher matcher = pattern.matcher(serializing);

	        // Use the Stream API to find all matches and extract the values into an array
	        return matcher.results()
	                .map(matchResult -> Integer.parseInt(matchResult.group(1)))
	                .mapToInt(Integer::intValue)
	                .toArray();
	    }
	 
	 public static String[] extractValuesFromSerializedArrayString(String serializing) {
	        // Use a regular expression to find all occurrences of s:[number]:"[value]"
	        Pattern pattern = Pattern.compile("s:\\d+:\"(\\d+)\"");
	        Matcher matcher = pattern.matcher(serializing);

	        // Use the Stream API to find all matches and extract the valuets teinto an array
	        return matcher.results()
	                .map(matchResult -> matchResult.group(1))
	                .toArray(String[]::new);
	 }
	 
	    public static Map<String, Object> extractValuesFromSerializedtoMap(String serializing) {
	        // Use a regular expression to find all occurrences of s:[number]:"[value]"
	        Pattern pattern = Pattern.compile("s:(\\d+):\"(\\d+)\"");
	        Matcher matcher = pattern.matcher(serializing);

	        // Use the Stream API to find all matches and extract the values into a map
	        Map<String, Object> resultMap = new HashMap<>();
	        matcher.results()
	                .forEach(matchResult -> {
	                    String key = matchResult.group(1);
	                    String value = matchResult.group(2);
	                    resultMap.put(key, Integer.parseInt(value));
	                });

	        return resultMap;
	    }
}
