package com.sspBidder.globalvariables;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import com.sspBidder.entity.GlobalVariables;

public class Globalvariables {

	public static final Set<String> EXCLUDED_IPS = new HashSet<>(Arrays.asList(
	            "0:0:0:0:0:0:0:1", // IPv6 loopback address
	            "127.0.0.1" // IPv4 loopback address
	    ));
	
	GlobalVariables globalVariables=new GlobalVariables();
	
	public GlobalVariables Global(HttpServletRequest request) throws IOException, GeoIp2Exception{
		
		String ip_addr=getIP(request);
//		System.out.println("ip add"+ip_addr);
		 File database = new File(getClass().getClassLoader().getResource("GeoLite2-City.mmdb").getFile());
		 
		 DatabaseReader reader = new DatabaseReader.Builder(database).build();

         // Replace "8.8.8.8" with the IP address you want to look up
//		 System.out.println("ipAddress: " + ip_addr);
         InetAddress ipAddress = InetAddress.getByName("185.219.141.88");
//         System.out.println("ipAddress: " + ipAddress);
         // Perform a lookup and get the CityResponse object
         CityResponse cityResponse = reader.city(ipAddress);
         String userAgent=request.getHeader("USER-AGENT");
         
         parseUserAgent(userAgent);
         String device_model =parseDeviceModel(userAgent);
//         System.out.println("device_model: " + device_model);
         
         String deviceType = getDeviceType(userAgent);
         String deviceName = getDeviceName(userAgent);

         Locale first_locale = new Locale("en", cityResponse.getCountry().getIsoCode()); 
         
         String link="https://"+request.getServerName()+request.getRequestURI();
//         System.out.println("link"+link);
         
         URL url=new URL(link);
//         System.out.println("Hostname"+parserURL(url, "Hostname"));
//         System.out.println("DomainName"+parserURL(url, "Hostname"));
//         System.out.println("RefUrl"+request.getHeader("Referer"));
//         System.out.println("Source"+request.getParameter("loc"));
         // Now you can access various information from the CityResponse object
        
         globalVariables.setRequest(request);
         globalVariables.setIp_address(ip_addr);
    globalVariables.setLatitude(cityResponse.getLocation().getLatitude().toString());
    globalVariables.setLongitude(cityResponse.getLocation().getLongitude().toString());
    globalVariables.setCountry_code(cityResponse.getCountry().getIsoCode());
    globalVariables.setCountry_name(cityResponse.getCountry().getName());
    globalVariables.setSubdivision_one(cityResponse.getCountry().getIsoCode());
    globalVariables.setSubdivision_two(first_locale.getISO3Country());
    globalVariables.setContinent(cityResponse.getContinent().getCode());
    globalVariables.setCity(cityResponse.getCity().getName());
    globalVariables.setPostal_code( cityResponse.getPostal().getCode());
    globalVariables.setUseragent(userAgent);
    globalVariables.setDeviceName(deviceName);
    globalVariables.setDeviceType(deviceType);
    globalVariables.setDeviceModel(device_model);

    
//         System.out.println("City: " + cityResponse.getCity().getName());
//         System.out.println("City: " + cityResponse.getPostal().getCode());
//         System.out.println("Country: " + cityResponse.getCountry().getName());
//         System.out.println("Latitude: " + cityResponse.getLocation().getLatitude());
//         System.out.println("Longitude: " + cityResponse.getLocation().getLongitude());
//         System.out.println("Continent: " + cityResponse.getContinent().getCode());
//         System.out.println("IsoCod: " + cityResponse.getCountry().getIsoCode());
//         System.out.println("useragent: " + request.getHeader("USER-AGENT"));
//         System.out.println("deviceType: " + deviceType);
//         System.out.println("deviceName: " + deviceName);
//         System.out.println("subdivisionOne: " + first_locale.getISO3Country());
            
         // Close the DatabaseReader when done
         reader.close();
		return globalVariables;
       
	}
	
	  public static String getIP(HttpServletRequest request) {
	        // Get IP from X-REAL-IP header
	        String ip_addr = request.getHeader("X-REAL-IP");
	        if (isValidIP(ip_addr)) {
	        	System.out.println("1 if called");
	            return ip_addr;
	        }

	        // Get IP from X-FORWARDED-FOR header
	        String ips = request.getHeader("X-FORWARDED-FOR");
	        if (ips != null) {
	            return Arrays.stream(ips.split(","))
	                    .map(String::trim)
	                    .filter(ip -> !EXCLUDED_IPS.contains(ip))
	                    .findFirst()
	                    .orElse(null);
	        }

	        // Get IP from RemoteAddr
	        String remoteAddr = request.getRemoteAddr();
	        try {
	            InetAddress netIP = InetAddress.getByName(remoteAddr);
	            if (isValidIP(netIP.getHostAddress())) {
	                return netIP.getHostAddress();
	            }
	        } catch (UnknownHostException e) {
	            e.printStackTrace(); 
	        }

	        return null; // No valid IP found
	    }
	  
	  private static boolean isValidIP(String ip) {
	        return ip != null && !ip.isEmpty() && !ip.equalsIgnoreCase("unknown") && !ip.equalsIgnoreCase("127.0.0.1") && !ip.equalsIgnoreCase("0:0:0:0:0:0:0:1");
	    }
	  
	  private String getDeviceType(String userAgent) {

	        if (userAgent.contains("Mobile")) {
	            return "Mobile";
	        } else if (userAgent.contains("Tablet")) {
	            return "Tablet";
	        } else {
	            return "Desktop";
	        }
	    }

	    private String getDeviceName(String userAgent) {
	
	        if (userAgent.contains("Android")) {
	            return "Android Device";
	        } else if (userAgent.contains("iPhone")) {
	            return "iPhone";
	        } else if (userAgent.contains("iPad")) {
	            return "iPad";
	        }else if(userAgent.contains("Linux")) {
	        	return "Linux Desktop";
	        }else if(userAgent.contains("Windows")) {
	        	return "Windows Desktop";
	        } else {
	            return "Unknown Device";
	        }
	    }
	    
	    private void parseUserAgent(String userAgentString) {        

	        if (userAgentString != null && !userAgentString.isEmpty()) {
	            // Regular expressions to extract information
	            Pattern browserPattern = Pattern.compile("([^/\\s]+)\\s*\\/\\s*([^\\s]+)");
	            Matcher browserMatcher = browserPattern.matcher(userAgentString);

	            if (browserMatcher.find()) {
	                String Browser=browserMatcher.group(1);
	                String BrowserVersion= browserMatcher.group(2);
	                globalVariables.setBrowser(Browser);
	                globalVariables.setBrowserVersion(BrowserVersion);
	                System.out.println("Browser"+Browser);
	                System.out.println("setBrowserVersion"+BrowserVersion);
	            }


	            Pattern osPattern = Pattern.compile("\\(([^;\\)]+)[^\\)]*\\)\\s*([^\\s]+)");
	            Matcher osMatcher = osPattern.matcher(userAgentString);

	            if (osMatcher.find()) {
	            	String Os=osMatcher.group(1);
	            	String OsVersion=osMatcher.group(2);
	            	 System.out.println("Os"+Os);
	            	 System.out.println("OsVersion"+OsVersion);
	            	 globalVariables.setOs(Os);
	            	 globalVariables.setOsv(OsVersion);
	            }
	        }
	    }
	    
	    
	    private String parseDeviceModel(String userAgentString) {
	        if (userAgentString != null && !userAgentString.isEmpty()) {
	            // Example: Extracting device model for iPhone
	            Pattern iphonePattern = Pattern.compile("iPhone ([^\\s;]+)");
	            Matcher iphoneMatcher = iphonePattern.matcher(userAgentString);
	            if (iphoneMatcher.find()) {
	                return "iPhone " + iphoneMatcher.group(1);
	            }

	            // Example: Extracting device model for Android
	            Pattern androidPattern = Pattern.compile("Android [^;]+; ([^\\s)]+)");
	            Matcher androidMatcher = androidPattern.matcher(userAgentString);
	            if (androidMatcher.find()) {
	                return "Android " + androidMatcher.group(1);
	            }

	          
	        }

	        return "";
	    }
	    
	    public String parserURL(java.net.URL url, String name) {
	        switch (name) {
	            case "Hostname":
	                if (url.getHost() != null) {
	                    try {
	                        URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), null, null, null);
	                        return uri.getHost();
	                    } catch (URISyntaxException e) {
	                        e.printStackTrace(); // Handle the exception appropriately
	                    }
	                }
	                break;
	        }
	        return "";
	    }
	
}