package com.sspBidder.fetching;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import com.sspBidder.configuration.MySqlConfiguration;
import com.sspBidder.entity.AdExchangeZone;
import com.sspBidder.entity.DealsDetails;
import com.sspBidder.entity.SiteObjectspublisher;
import com.sspBidder.entity.SspExBuyer;
import com.sspBidder.entity.ZoneEn;

public class Fetching {
	
	public static ZoneEn fetchData(String zoneid) throws SQLException {
	     ZoneEn zone = new ZoneEn();
       try (Connection connection = MySqlConfiguration.getConnection()){
       	
String query1 = "SELECT z.zoneid,z.zonename,z.affiliateid,z.delivery,"
		+ "z.zonetype,z.width,z.height,z.prepend,z.append,z.inventory_type,z.ssp_buyer,"
		+ "z.block,z.capping,z.session_capping,z.inv_type,z.passbacktag ,"
		+ "a.comments ,vidtype,reward,amount,position,layout,infeedads,infeedpos,adposition,adinterval,"
		+ "a.name as affiliate_name, a.is_seller_json as is_seller_json from  rv_zones as z inner join  "
		+ "rv_affiliates as a ON a.affiliateid = z.affiliateid where zoneid ="+zoneid;
      	
            PreparedStatement preparedStatement = connection.prepareStatement(query1);
            ResultSet resultSet = preparedStatement.executeQuery(query1) ;
            
       while (resultSet.next()) {
               // Create a new Zone object and populate it with data from the ResultSet
           	
           	zone.setZoneid(resultSet.getInt("zoneid"));
           	zone.setZonename(resultSet.getString("zonename"));
               zone.setAffiliateid(resultSet.getInt("affiliateid"));
               zone.setDelivery(resultSet.getString("delivery"));
               zone.setZonetype(resultSet.getInt("zonetype"));
               zone.setWidth(resultSet.getInt("width"));
               zone.setHeight(resultSet.getInt("height"));
               zone.setPrepend(resultSet.getString("prepend"));
               zone.setAppend(resultSet.getString("append"));
               zone.setInventory_type(resultSet.getInt("inventory_type"));
               zone.setSsp_buyer(resultSet.getString("ssp_buyer"));
               zone.setBlock(resultSet.getInt("block"));
               zone.setCapping(resultSet.getInt("capping"));
               zone.setSession_capping(resultSet.getInt("session_capping"));
               zone.setInv_type(resultSet.getInt("inv_type"));
               zone.setPassbacktag(resultSet.getString("passbacktag"));
               zone.setComments(resultSet.getString("comments"));
               zone.setVidtype(resultSet.getInt("vidtype"));
               zone.setAmount(resultSet.getString("amount"));
               zone.setPosition(resultSet.getString("position"));
               zone.setLayout(resultSet.getString("layout"));
               zone.setInfeedads(resultSet.getString("infeedads"));
               zone.setAdposition(resultSet.getString("adposition"));
               zone.setAdinterval(resultSet.getString("adinterval"));
           
//               zone.set      (resultSet.getInt(""));
             
   			// Process or use the Zone object
//               System.out.println(zone);
           	
           }      	   	
         }
		return zone;
       }
	
	public static SspExBuyer fetchDetails(int buyerid) throws SQLException{		 
		SspExBuyer sap = new SspExBuyer();
		
		String stringValue1 = String.valueOf(buyerid);
		try (Connection connection = MySqlConfiguration.getConnection()){
			
			String query2 = "SELECT exchange_id as Exchange_id ,exchange_name as Exchange_name, "
					+ "open_rtb_version as Open_rtb_version ,"
					+ "status as Status, ping_url as Ping_url , "
					+ "auction_currency as Auction_currency , auction_type as Auction_type ,"
					+ "digital_signature as Digital_signature, gzip as Gzip  "
					+ "from rv_dj_ad_exchange WHERE exchange_id ="+stringValue1;
			
			PreparedStatement preparedStatement = connection.prepareStatement(query2);
			ResultSet resultSet1 = preparedStatement.executeQuery(query2) ;
			
			while (resultSet1.next()) {
				sap.setExchange_id(resultSet1.getInt("exchange_id"));
				sap.setExchange_name(resultSet1.getString("exchange_name"));
				sap.setOpen_rtb_version(resultSet1.getInt("open_rtb_version"));
			    sap.setStatus(resultSet1.getInt("status"));
			    sap.setAuction_currency(resultSet1.getInt("auction_currency"));
			    sap.setAuction_type(resultSet1.getInt("auction_type"));
			    sap.setGzip(resultSet1.getInt("gzip"));
			    sap.setPing_url(resultSet1.getString("ping_url"));
			    sap.setDigital_signature(resultSet1.getString("digital_signature"));
			 
//			    System.out.println(sap);
			}
			return sap;		
		}
     }
		public static AdExchangeZone getZonRtbParams(String zoneid) throws SQLException{		 
			AdExchangeZone adex = new AdExchangeZone();
			
			
			try (Connection connection = MySqlConfiguration.getConnection()){
				
				String query3 = "SELECT * FROM " + "rv_exchange_zone_assoc WHERE zoneid ="+zoneid;			
				PreparedStatement preparedStatement = connection.prepareStatement(query3);
				ResultSet resultSet2 = preparedStatement.executeQuery(query3) ;
				
				while (resultSet2.next()) {
					adex.setZoneid(resultSet2.getInt("Zoneid"));
					adex.setReq_test(resultSet2.getInt("Req_test"));				
					adex.setReq_tmax(resultSet2.getInt("Req_tmax"));
					adex.setReq_wseat(resultSet2.getString("Req_wseat"));
					adex.setReq_allimps(resultSet2.getInt("Req_allimps"));
					adex.setReq_bcat(resultSet2.getString("Req_bcat"));
					adex.setReq_badv(resultSet2.getString("Req_bcat"));
					adex.setReq_bapp(resultSet2.getString("Req_bapp"));
					adex.setReq_regs(resultSet2.getString("Req_regs"));
					adex.setImp_dm(resultSet2.getString("Imp_dm"));
					adex.setImp_dms(resultSet2.getString("Imp_dms")); 
					adex.setImp_tagid(resultSet2.getString("Imp_tagid"));
					adex.setImp_bidfloor(resultSet2.getFloat("Imp_bidfloor")); 
					adex.setImp_cb(resultSet2.getInt("Imp_cb")); 
					adex.setImp_secure(resultSet2.getInt("Imp_secure"));  
					adex.setImp_iframe(resultSet2.getString("Imp_iframe"));  
					adex.setImp_exp(resultSet2.getInt("Imp_exp"));
					adex.setImp_pmp(resultSet2.getString("Imp_pmp"));  
					adex.setBan_btype(resultSet2.getString("Ban_btype"));  
					adex.setBan_battr(resultSet2.getString("Ban_battr"));
					adex.setBan_mimes(resultSet2.getString("Ban_mimes"));  
					adex.setVid_width(resultSet2.getInt("Vid_width"));
					adex.setVid_height(resultSet2.getInt("Vid_height"));  
					adex.setVid_playervideo(resultSet2.getString("Vid_playervideo"));   
					adex.setCcpa(resultSet2.getString("Ccpa")); 
		            adex.setGdpr(resultSet2.getInt("Gdpr"));
		            adex.setNative_objects(resultSet2.getString("Native_objects")); 
		            adex.setImg_width(resultSet2.getString("Img_width"));  
	              	adex.setImg_height(resultSet2.getString("Img_height"));
		            adex.setDesk_width(resultSet2.getString("Desk_width"));
	                adex.setDesk_height(resultSet2.getString("Desk_height"));
	                adex.setBelow_img(resultSet2.getString("Below_img"));
	                adex.setDeal_id(resultSet2.getString("Deal_id"));
					adex.setPmp(resultSet2.getInt("Pmp"));
					adex.setAud_dl(resultSet2.getInt("Aud_dl"));
					adex.setAud_nvol(resultSet2.getInt("Aud_nvol"));
					adex.setAud_feed(resultSet2.getInt("Aud_feed"));
					adex.setAud_maxseq(resultSet2.getInt("Aud_maxseq"));
	                adex.setAud_comptype(resultSet2.getString("Aud_comptype"));
	                adex.setAud_del(resultSet2.getString("Aud_del"));
					adex.setAud_maxbit(resultSet2.getInt("Aud_maxbit"));
					adex.setAud_minbit(resultSet2.getInt("Aud_minbit"));
					adex.setAud_maxext(resultSet2.getInt("Aud_maxext"));
	                adex.setAud_battr(resultSet2.getString("Aud_battr"));  
	                adex.setAud_protocol(resultSet2.getString("Aud_protocol"));
					adex.setAud_max(resultSet2.getInt("Aud_max"));
					adex.setAud_min(resultSet2.getInt("Aud_min"));
	                adex.setAud_mimes(resultSet2.getString("Aud_mimes"));
	                adex.setNat_widheight(resultSet2.getString("Nat_widheight"));
	                adex.setNat_id(resultSet2.getString("Nat_id"));
	                adex.setRtb_id(resultSet2.getString("Rtb_id"));
					adex.setNat_lin(resultSet2.getInt("Nat_lin"));
					adex.setNat_datalength(resultSet2.getInt("Nat_datalength"));
					adex.setNat_datatype(resultSet2.getInt("Nat_datatype"));
	                adex.setNat_vid_protocol(resultSet2.getString("Nat_vid_protocol"));
					adex.setNat_max(resultSet2.getInt("Nat_max"));
					adex.setNat_min(resultSet2.getInt("Nat_min"));
	                adex.setNat_vid_mimes(resultSet2.getString("Nat_vid_mimes"));
	                adex.setNat_vid_playervideo(resultSet2.getString("Nat_vid_playervideo"));
					adex.setNat_vid_height(resultSet2.getInt("Nat_vid_height"));
					adex.setNat_vid_width(resultSet2.getInt("Nat_vid_width"));
	                adex.setNat_img_mimes(resultSet2.getString("Nat_img_mimes"));
					adex.setNat_height(resultSet2.getInt("Nat_height"));
					adex.setNat_width(resultSet2.getInt("Nat_width"));
					adex.setNat_type(resultSet2.getInt("Nat_type"));
					adex.setNat_len(resultSet2.getInt("Nat_len"));
					adex.setNat_adunit(resultSet2.getInt("Nat_adunit"));
					adex.setNat_lay(resultSet2.getInt("Nat_lay"));
					adex.setFormat_h(resultSet2.getInt("Format_h"));
					adex.setFormat_w(resultSet2.getInt("Format_w"));
					
	                adex.setSeg_value(resultSet2.getString("Seg_value"));
	                adex.setSeg_name(resultSet2.getString("Seg_name"));
	                adex.setData_seg(resultSet2.getString("Data_seg"));
	                adex.setData_name(resultSet2.getString("Data_name"));
	                adex.setUser_data(resultSet2.getString("User_data"));
	                adex.setUser_cd(resultSet2.getString("User_cd"));
	                adex.setUser_key(resultSet2.getString("User_key"));
	                adex.setUser_gender(resultSet2.getString("User_gender"));
				    adex.setUser_yob(resultSet2.getInt("User_yob"));
	                adex.setUser_bid(resultSet2.getString("User_bid"));

					adex.setGeo_lf(resultSet2.getInt("Geo_lf"));
					adex.setGeo_accuracy(resultSet2.getInt("Geo_accuracy"));
					adex.setDev_lmt(resultSet2.getInt("Dev_lmt"));
					adex.setDev_dnt(resultSet2.getInt("Dev_dnt"));
						
	                adex.setProd_domain(resultSet2.getString("Prod_domain"));
	                adex.setProd_cat(resultSet2.getString("Prod_cat"));
	                adex.setProd_name(resultSet2.getString("Prod_name"));
	                adex.setCont_data(resultSet2.getString("Cont_data"));
				    adex.setCont_embed(resultSet2.getInt("Cont_embed"));
	                adex.setCont_lang(resultSet2.getString("Cont_lang"));
					adex.setCont_len(resultSet2.getInt("Cont_len"));
					adex.setCont_key(resultSet2.getString("Cont_key"));
					adex.setCont_mr(resultSet2.getInt("Cont_mr"));
	                adex.setCont_ur(resultSet2.getString("Cont_ur"));
	                adex.setCont_cr(resultSet2.getString("Cont_cr"));
					adex.setCont_context(resultSet2.getInt("Cont_context"));
					adex.setCont_vq(resultSet2.getInt("Cont_vq"));
					adex.setCont_prodq(resultSet2.getInt("Cont_prodq"));
						
	                adex.setCont_cat(resultSet2.getString("Cont_cat"));
	                adex.setCont_prod(resultSet2.getString("Cont_prod"));
					adex.setCont_season (resultSet2.getString("Cont_season"));
	                adex.setCont_series (resultSet2.getString("Cont_series"));
	                adex.setCont_title(resultSet2.getString("Cont_title"));
					adex.setCont_epi(resultSet2.getInt("Cont_epi"));
						
	               adex.setPub_domain(resultSet2.getString("Pub_domain"));
	               adex.setPub_cat(resultSet2.getString("Pub_cat"));	
				   adex.setApp_key(resultSet2.getString("App_key"));
				   adex.setApp_paid(resultSet2.getInt("App_paid"));
				   adex.setApp_ver(resultSet2.getString("App_ver"));
			       adex.setApp_privacy(resultSet2.getString("App_privacy"));
				   adex.setApp_page(resultSet2.getString("App_page"));
				   adex.setApp_section(resultSet2.getString("App_section"));
				   adex.setApp_cat(resultSet2.getString("App_cat"));
				   adex.setApp_url(resultSet2.getString("App_url"));
				   adex.setApp_bundle(resultSet2.getString("App_bundle"));
				   adex.setApp_name(resultSet2.getString("App_name"));
				   adex.setApp_id(resultSet2.getString("App_id"));
				   adex.setSite_privacy(resultSet2.getInt("Site_privacy"));
				   adex.setSite_content(resultSet2.getString("Site_content"));
				   adex.setSite_key(resultSet2.getString("Site_key"));
				   adex.setSite_page(resultSet2.getString("Site_page"));
				   adex.setSite_section(resultSet2.getString("Site_section"));
				   adex.setSite_cat(resultSet2.getString("Site_cat"));
						
				   adex.setDeal_wadomain(resultSet2.getString("Deal_wadomain"));
				   adex.setDeal_wseat(resultSet2.getString("Deal_wseat"));
	               adex.setDeal_bidfloorcur(resultSet2.getString("Deal_bidfloorcur"));
				   adex.setDeal_bidfloor(resultSet2.getFloat("Deal_bidfloor"));
									
				   adex.setVid_comp_height(resultSet2.getInt("Vid_comp_height"));
				   adex.setVid_comp_width(resultSet2.getInt("Vid_comp_width"));
				   adex.setVid_comptype(resultSet2.getString("Vid_comptype"));
				   adex.setVid_api(resultSet2.getString("Vid_api"));
				   adex.setVid_compad(resultSet2.getString("Vid_compad"));
				   adex.setVid_pos(resultSet2.getInt("Vid_pos"));
				   adex.setVid_del(resultSet2.getInt("Vid_del"));
				   adex.setVid_play(resultSet2.getString("Vid_play"));
				   adex.setVid_box(resultSet2.getInt("Vid_box"));
				   adex.setVid_maxbit(resultSet2.getInt("Vid_maxbit"));
				   adex.setVid_minbit(resultSet2.getInt("Vid_minbit"));
				   adex.setVid_maxext(resultSet2.getInt("Vid_maxext"));
				   adex.setVid_battr(resultSet2.getString("Vid_battr"));
				   adex.setVid_seq(resultSet2.getInt("Vid_seq"));
				   adex.setVid_skipafter(resultSet2.getInt("Vid_skipafter"));
				   adex.setVid_skipmin(resultSet2.getInt("Vid_skipmin"));
				   adex.setVid_skip(resultSet2.getInt("Vid_skip"));
				   adex.setVid_lin(resultSet2.getInt("Vid_lin"));
	               adex.setVid_roll_sec(resultSet2.getInt("Vid_roll_sec"));
	               adex.setVid_sd(resultSet2.getInt("Vid_sd"));
	               adex.setVid_protocol(resultSet2.getString("Vid_protocol"));
	               adex.setVid_min(resultSet2.getInt("Vid_min"));
				   adex.setVid_max(resultSet2.getInt("Vid_max"));
				   adex.setVid_mimes(resultSet2.getString("Vid_mimes"));
				   
				    System.out.println(adex);
					
				}
				return adex;		
			}
	     }
			
	      public static DealsDetails getZnMatchedDeals() throws SQLException {
	    	  DealsDetails dealo = new DealsDetails();
	    	  List<DealsDetails> deals = new ArrayList();

	  		try (Connection connection = MySqlConfiguration.getConnection()){
	    	  
	    	  String query4 =  "SELECT dealid, dealid_token,auction_type,floor_price, zones, adsize ,whitelist FROM " 
	    	                   + " rv_exchange_zone_assoc dealid WHERE is_pause= 0 AND is_expire =0 AND is_delete=0 ";
	    	  
	    		PreparedStatement preparedStatement = connection.prepareStatement(query4);
				ResultSet resultSet4 = preparedStatement.executeQuery(query4) ;
	    	  
	    	  while(resultSet4.next()) {
	    		  dealo.setDealid(resultSet4.getInt("Dealid"));
	    		  dealo.setDealid_token(resultSet4.getString("Dealid_token"));
	    		  dealo.setAuction_type(resultSet4.getInt("Auction_type"));
	    		  dealo.setFloor_price(resultSet4.getFloat("Floor_price"));
	    		  dealo.setZones(resultSet4.getString("Zones"));
	    		  dealo.setAdsize(resultSet4.getString("Adsize"));
	    		  dealo.setWhitelist(resultSet4.getString("Whitelist"));	    		  
	    	  }

	  		}	  		
	    	  return dealo;
	    	  
	      }
	            
	      public static SiteObjectspublisher getZonePubDetails() throws SQLException {
	     	 SiteObjectspublisher objecto = new SiteObjectspublisher();
	     	 
	     	 try (Connection connection = MySqlConfiguration.getConnection()){
	     	 
	     	 String query3 =   "SELECT * FROM " + "rv_exchange_zone_assoc WHERE zoneid = '%d'";
	     	 
	     	 PreparedStatement preparedStatement = connection.prepareStatement(query3);
	 			ResultSet resultSet3 = preparedStatement.executeQuery(query3) ;
	     	    	 

	 			while (resultSet3.next()) {
	 				
	 				objecto.setId(resultSet3.getString("id"));
	 				objecto.setName(resultSet3.getString("name"));
	 				objecto.setDomain(resultSet3.getString("domain"));
	 			} 
	     	  System.out.println(objecto);
	     	 }
	     	 return objecto ;
	     	 
	      }
}

