package com.sspBidder.adDelivery;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.maxmind.geoip2.exception.GeoIp2Exception;
//import com.sspBidder.configuration.ZoneRtbParams;
import com.sspBidder.entity.AdExchangeZone;
import com.sspBidder.entity.GlobalVariables;
import com.sspBidder.entity.SspExBuyer;
import com.sspBidder.entity.ZoneEn;
import com.sspBidder.fetching.Fetching;
import com.sspBidder.globalvariables.Globalvariables;
import com.sspBidder.helper.Helper;
import com.sspBidder.rtbRequest.ImageRequest;
import com.sspBidder.rtbRequest.ImpObjects_pmp_deals;
import com.sspBidder.rtbRequest.Request;

public class AdDelivery {

	String jsContent=null;
	public String AsyncJs(HttpServletRequest request, HttpServletResponse response,ExecutorService executorService) throws IOException, InterruptedException, ExecutionException {
		System.out.println("called");
		Future<?> futureResult=executorService.submit(() -> {
		String filePath = "src/main/webapp/js/async.js";
		 
		try {
			jsContent= readFileContents(filePath);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		});
		executorService.shutdown();

        System.out.println("JavaScript File Content:\n" + jsContent);
        
        String deliveryWebPath = "rvphp.djaxbidder.com/golangssp/www/delivery";
        String deliverySSLWebPath = "rvphp.djaxbidder.com/golangssp/www/delivery";

        String concatString = deliveryWebPath + "*" + deliverySSLWebPath;

        String GO_ETAG = calculateMD5(concatString);
        String GO_PRODUCT="revive";
        String GO_ASYNC_DELIVERY="http://localhost:8080/async";
        
        Object result=futureResult.get();
        System.out.println("result"+result);
        jsContent=jsContent.replaceAll("GO_ETAG", GO_ETAG);
        jsContent=jsContent.replaceAll("GO_PRODUCT", GO_PRODUCT);
        jsContent=jsContent.replaceAll("GO_ASYNC_DELIVERY", GO_ASYNC_DELIVERY);
	
		return jsContent;	
}
	
	private static String calculateMD5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytes = md.digest(input.getBytes());

            // Convert bytes to hexadecimal string
            StringBuilder sb = new StringBuilder();
            for (byte b : bytes) {
                sb.append(String.format("%02x", b));
            }

            return sb.toString();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
	
	public String AsyncTag(HttpServletRequest request, HttpServletResponse response) throws IOException {

		String zoneid;
		zoneid=request.getParameter("zones");
		System.out.println("Zones"+zoneid);
		 Globalvariables globalvariables=new Globalvariables();
		 GlobalVariables global = new GlobalVariables();
		 try {
			 global =globalvariables.Global(request);
		} catch (IOException | GeoIp2Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		 /////////////////
//			String zoneid = request.getParameter("zoneid");
			System.out.println("zoneid :"+zoneid);
			ZoneEn zonedetails = null;
			try {
				zonedetails =Fetching.fetchData(zoneid);
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
//			System.out.println("zonedetails :"+zonedetails);
			
			 int[] extractedValues = Helper.extractValuesFromSerializedArray(zonedetails.getSsp_buyer());

	          List<SspExBuyer> arraysspbuyer = Arrays.stream(extractedValues)
	    	    .mapToObj(buyerId -> {
	    	        String key = String.format("buyer%s", buyerId);
	    	        SspExBuyer sap = new SspExBuyer();
//	    	        SspExBuyer sap;
					try {
						sap = Fetching.fetchDetails(buyerId);
					} catch (SQLException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
	    	        return sap;
	    	    })
	    	    .collect(Collectors.toList());
//	    	System.out.println("array sspbyer: " + arraysspbuyer);
				
				
			AdExchangeZone adexchange = null;
			try {
				adexchange = Fetching.getZonRtbParams(zoneid);
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			response.getWriter().println("Hello, World!");
//			GlobalVariables globalvariable =Globalvariablesfunc.Global(request);
			ImpObjects_pmp_deals pmpdeal = new ImpObjects_pmp_deals();
			ImageRequest bidrequest = Request.framing_request(adexchange,arraysspbuyer,zonedetails,pmpdeal,global);
			  ObjectMapper objectMapper = new ObjectMapper();
			  objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
			 String requestjson = objectMapper.writeValueAsString(bidrequest);
			 System.out.println("Final bid request :"+ requestjson);	
		 /////////////////
		String resp;
		resp="{\"revive-0-0\":{\"html\":\"\\u003ca href='https://adserver.unitdsp.com:2212/click_url?bannerid=129\\u0026zoneid=0\\u0026oadest=http://www.google.com\\u0026bidid=25657bf40546fce859a09e7d89_20231215630\\u0026cookieid=495b54988a239e8209304cb33757b25653c2\\u0026campaignid=56' target='_blank'\\u003e\\u003cimg src='https://adserver.unitdsp.com/www/images/e093b0af63c40a644278673bb646be56.png' width='240' height='400' alt='' title='' border='0'\\u003e\\u003c/a\\u003e\\u003cdiv id='beacon_1253948ef5' style='position: absolute; left: 0px; top: 0px; visibility: hidden;'\\u003e\\u003cimg src='https://adserver.unitdsp.com:2212/imp_url?bannerid=129\\u0026campaignid=56\\u0026zoneid=0\\u0026bidid=25657bf40546fce859a09e7d89_20231215630' width='0' height='0' alt='' style='width: 0px; height: 0px;' /\\u003e\\u003cimg src='' width='0' height='0' alt='' style='width: 0px; height: 0px;' /\\u003e\\u003cimg src='https://adserver.unitdsp.com:2212/cookiesync?v=76\\u0026cookieid=495b54988a239e8209304cb33757b25653c2' width='0' height='0' alt='' style='width: 0px; height: 0px;' /\\u003e\\u003c/div\\u003e\\u003cimg width=0 height=0 src='https://rvphp.djaxbidder.com:8090/billing_notice?id=25657bf40546fce859a09e7d89_20231215630\\u0026bidderid=76\\u0026burl=aHR0cHM6Ly9hZHNlcnZlci51bml0ZHNwLmNvbToyMjEyL2JpbGxpbmdfbm90aWNlP2F1Y3Rpb25JZD0yNTY1N2JmNDA1NDZmY2U4NTlhMDllN2Q4OV8yMDIzMTIxNTYzMCZiaWRpZD0yNTY1N2JmNDA1NDZmY2U4NTlhMDllN2Q4OV8yMDIzMTIxNTYzMCZwcmljZT01LjAwJmltcGlkPTEmc2VhdGlkPVRlc3RfQWR2ZXJ0aXNlcl8xNyZhZGlkPTEyOSZjdXI9VVNE'\\u003e\",\"width\":0,\"height\":0,\"iframeFriendly\":false}}";
		return resp;
	}
	
	private static String readFileContents(String filePath)throws IOException {
		 Path path = Paths.get(filePath);
	        byte[] bytes = Files.readAllBytes(path);
	        return new String(bytes);
}
}
