package com.sspBidder;

import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

import com.sspBidder.controller.HelloController;
import com.sspBidder.controller.AsyncController;
import com.sspBidder.controller.AsyncJsController;

public class App {

	public static void main(String[] args) throws Exception {
		// TODO Auto-generated method stub
		
		Server server = new Server(8080);

        // Create a ServletContextHandler
        ServletContextHandler context = new ServletContextHandler(ServletContextHandler.SESSIONS);
        context.setContextPath("/");

        // Add the HelloServlet to the context
        context.addServlet(new ServletHolder(new HelloController()), "/hello");
        context.addServlet(new ServletHolder(new AsyncJsController()), "/asyncjs");
    	context.addServlet(new ServletHolder(new AsyncController()), "/async");

        // Set the context on the server
        server.setHandler(context);

        // Start the server
        server.start();
        server.join();

	}

}
