package com.newinternaldsp.MysqlDB;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import com.newinternaldsp.Entity.BannerClass;

public class DBConnection {

	public static Map<String, String> Getdsp(String dsp_name, String key, Connection conn) {

		String procedureCall = "{call getdsp(?,?)}";
		Map<String, String> DspDetails = new HashMap<>();

		try (CallableStatement callableStatement = conn.prepareCall(procedureCall)) {
			callableStatement.setString("dsp_name", dsp_name);
			callableStatement.setString("secret_key", key);

			callableStatement.execute();

			try (ResultSet resultSet = callableStatement.getResultSet()) {
				while (resultSet.next()) {

					System.out.println("dspid :" + resultSet.getString("dspid"));
					System.out.println("adminshare :" + resultSet.getString("adminshare"));
					System.out.println("webresponse :" + resultSet.getString("webresponse"));
					System.out.println("videoresponse :" + resultSet.getString("videoresponse"));
					System.out.println("digitalsignature :" + resultSet.getString("digitalsignature"));

					DspDetails.put("dspid", resultSet.getString("dspid"));
					DspDetails.put("adminshare", resultSet.getString("adminshare"));
					DspDetails.put("webresponse", resultSet.getString("webresponse"));
					DspDetails.put("videoresponse", resultSet.getString("videoresponse"));
					DspDetails.put("digitalsignature", resultSet.getString("digitalsignature"));

				}

			}
		} catch (SQLException e) {
			e.printStackTrace();
		}

		return DspDetails;
	}

	public static ArrayList<BannerClass> Getbanner(int width, int height, int dspid, String storagetype, String pmp,
			Connection conn) {
		System.out.println("Getbanner method started...");

		ArrayList<BannerClass> arrayList = new ArrayList<>();
		String procedureCall = "{call getAd(?,?,?,?,?)}";

		try (CallableStatement callableStatement = conn.prepareCall(procedureCall)) {
			callableStatement.setInt("width_value", width);
			callableStatement.setInt("height_value", height);
			callableStatement.setInt("dsp_ids", dspid);
			callableStatement.setString("storage_type_value", storagetype);
			callableStatement.setString("pmp", pmp);

			callableStatement.execute();

			try (ResultSet resultSet = callableStatement.getResultSet()) {
				while (resultSet.next()) {
					System.out.println("start");
					CompletableFuture<BannerClass> future = CompletableFuture.supplyAsync(() -> {
						BannerClass bannerClass = new BannerClass();
						try {
							 bannerClass.setAd_id(resultSet.getInt("ad_id"));
	                            bannerClass.setAd_id(resultSet.getInt("ad_id"));
								bannerClass.setClientid(resultSet.getInt("clientid"));
								bannerClass.setClientname(resultSet.getString("clientname"));
								bannerClass.setPlacement_id(resultSet.getInt("placement_id"));
								bannerClass.setName(resultSet.getString("name"));
								bannerClass.setStoragetype(resultSet.getString("storagetype"));
								bannerClass.setFilename(resultSet.getString("filename"));
								bannerClass.setImageurl(resultSet.getString("imageurl"));
								bannerClass.setWidth(resultSet.getInt("width"));
								bannerClass.setHeight(resultSet.getInt("height"));
								bannerClass.setWeight(resultSet.getInt("weight"));
								bannerClass.setUrl(resultSet.getString("url"));
								bannerClass.setCampaign_weight(resultSet.getInt("campaign_weight"));
								bannerClass.setPmp(resultSet.getInt("pmp"));
								bannerClass.setRevenue(resultSet.getDouble("revenue"));
								bannerClass.setCompiledlimitation(resultSet.getString("compiledlimitation"));
								bannerClass.setDeal_id(resultSet.getInt("deal_id"));
								bannerClass.setBannertext(resultSet.getString("bannertext"));
								bannerClass.setRevenue_type(resultSet.getInt("revenue_type"));
								bannerClass.setHtmltemplate(resultSet.getString("htmltemplate"));

								System.out.println("ad_id :" + resultSet.getInt("ad_id"));
								System.out.println("clientid :" + resultSet.getInt("clientid"));
								System.out.println("clientname :" + resultSet.getString("clientname"));
								System.out.println("placement_id :" + resultSet.getInt("placement_id"));
								System.out.println("name :" + resultSet.getString("name"));
								System.out.println("storagetype :" + resultSet.getString("storagetype"));
								System.out.println("filename :" + resultSet.getString("filename"));
								System.out.println("imageurl :" + resultSet.getString("imageurl"));
								System.out.println("width :" + resultSet.getInt("width"));
								System.out.println("height :" + resultSet.getInt("height"));
								System.out.println("weight :" + resultSet.getInt("weight"));
								System.out.println("url :" + resultSet.getString("url"));
								System.out.println("campaign_weight :" + resultSet.getInt("campaign_weight"));
								System.out.println("pmp :" + resultSet.getInt("pmp"));
								System.out.println("revenue :" + resultSet.getDouble("revenue"));
								System.out.println("secondrevenue :" + resultSet.getInt("secondrevenue"));
								System.out.println("compiledlimitation :" + resultSet.getString("compiledlimitation"));
								System.out.println("deal_id :" + resultSet.getInt("deal_id"));
								System.out.println("bannertext :" + resultSet.getString("bannertext"));
								System.out.println("revenue_type :" + resultSet.getInt("revenue_type"));
								System.out.println("htmltemplate :" + resultSet.getString("htmltemplate"));

// Add to arrayList
							arrayList.add(bannerClass);
						   // future.thenAccept(result -> System.out.println("Async task completed with result: " + result));
					        System.out.println("Async task completed with result: " + bannerClass);
					        System.out.println("stop");
						} catch (SQLException e) {
							e.printStackTrace();
						}
						return bannerClass;
					});
// Wait for this specific CompletableFuture to complete
					future.join();
				}
			}
		} catch (SQLException e) {
			e.printStackTrace();
		}
		System.out.println("Getbanner method finished.");
		return arrayList;
	}


}