package com.newinternaldsp.Controller;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mysql.cj.jdbc.CallableStatement;
import com.newinternaldsp.Entity.Ads;
import com.newinternaldsp.Entity.Banner;
import com.newinternaldsp.Entity.BannerClass;
import com.newinternaldsp.Entity.BidRequest;
import com.newinternaldsp.MysqlDB.DBConfig;
import com.newinternaldsp.helper.helper;

@Path("/dsp_request")
public class Controller {

	@POST
//    @Path("/hello")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.TEXT_PLAIN)
	public String greet(@QueryParam("dsp") String dsp, @QueryParam("secret_key") String secret_key, String jsonInput)
			throws SQLException {
		System.out.println("dsp: " + dsp);
		System.out.println("secret_key: " + secret_key);
		System.out.println("jsonreq: " + jsonInput);

		ObjectMapper objectMapper = new ObjectMapper();

		System.out.println("jsonreq :" + jsonInput);

		try {
			BidRequest bidRequest = objectMapper.readValue(jsonInput, BidRequest.class);
			int width = bidRequest.getImp().get(0).getBanner().getW();
			int height = bidRequest.getImp().get(0).getBanner().getH();

			Map<String, String> DspDetails = helper.GetdspId(dsp, secret_key, 0);

			Connection con = DBConfig.getdbcon();

			ArrayList<BannerClass> DspDetails2 = helper.Getbannerad(width, height,
					Integer.parseInt(DspDetails.get("dspid")), "web", "0");

			BannerClass bannerClass = helper.Highestbid(DspDetails2);
			Banner banner = new Banner();
			banner.setW(width);
			banner.setH(height);

			System.out.println("DspDetails :" + DspDetails);
			System.out.println("bannerClass: " + banner);
			Ads Ads = new Ads();

			return "Received JSON Map: " + bidRequest.getId();
		} catch (IOException e) {
			e.printStackTrace();
			return "Error processing JSON";
		}

	}



}
