/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.vertx.jdbc;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.sql.ResultSet;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.prebid.server.execution.Timeout;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.metric.Metrics;
import org.prebid.server.vertx.CircuitBreaker;
import org.prebid.server.vertx.jdbc.JdbcClient;

public class CircuitBreakerSecuredJdbcClient
implements JdbcClient {
    private static final Logger logger = LoggerFactory.getLogger(CircuitBreakerSecuredJdbcClient.class);
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(logger);
    private static final int LOG_PERIOD_SECONDS = 5;
    private final JdbcClient jdbcClient;
    private final CircuitBreaker breaker;

    public CircuitBreakerSecuredJdbcClient(Vertx vertx, JdbcClient jdbcClient, Metrics metrics, int openingThreshold, long openingIntervalMs, long closingIntervalMs, Clock clock) {
        this.jdbcClient = Objects.requireNonNull(jdbcClient);
        this.breaker = new CircuitBreaker("db_cb", Objects.requireNonNull(vertx), openingThreshold, openingIntervalMs, closingIntervalMs, Objects.requireNonNull(clock)).openHandler(ignored -> this.circuitOpened()).halfOpenHandler(ignored -> this.circuitHalfOpened()).closeHandler(ignored -> this.circuitClosed());
        metrics.createDatabaseCircuitBreakerGauge(() -> ((CircuitBreaker)this.breaker).isOpen());
        logger.info((Object)"Initialized JDBC client with Circuit Breaker");
    }

    public <T> Future<T> executeQuery(String query, List<Object> params, Function<ResultSet, T> mapper, Timeout timeout) {
        return this.breaker.execute(promise -> this.jdbcClient.executeQuery(query, params, mapper, timeout).onComplete((Handler)promise));
    }

    private void circuitOpened() {
        conditionalLogger.warn("Database is unavailable, circuit opened.", 5L, TimeUnit.SECONDS);
    }

    private void circuitHalfOpened() {
        logger.warn((Object)"Database is ready to try again, circuit half-opened.");
    }

    private void circuitClosed() {
        logger.warn((Object)"Database becomes working, circuit closed.");
    }
}

