/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.vertx.jdbc;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.jdbc.JDBCClient;
import io.vertx.ext.sql.ResultSet;
import io.vertx.ext.sql.SQLConnection;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.prebid.server.execution.Timeout;
import org.prebid.server.metric.Metrics;
import org.prebid.server.vertx.jdbc.JdbcClient;

/*
 * Exception performing whole class analysis ignored.
 */
public class BasicJdbcClient
implements JdbcClient {
    private static final Logger logger = LoggerFactory.getLogger(BasicJdbcClient.class);
    private final Vertx vertx;
    private final JDBCClient jdbcClient;
    private final Metrics metrics;
    private final Clock clock;

    public BasicJdbcClient(Vertx vertx, JDBCClient jdbcClient, Metrics metrics, Clock clock) {
        this.vertx = Objects.requireNonNull(vertx);
        this.jdbcClient = Objects.requireNonNull(jdbcClient);
        this.metrics = Objects.requireNonNull(metrics);
        this.clock = Objects.requireNonNull(clock);
    }

    public Future<Void> initialize() {
        Promise connectionPromise = Promise.promise();
        this.jdbcClient.getConnection((Handler)connectionPromise);
        return connectionPromise.future().recover(BasicJdbcClient::logConnectionError).mapEmpty();
    }

    public <T> Future<T> executeQuery(String query, List<Object> params, Function<ResultSet, T> mapper, Timeout timeout) {
        long remainingTimeout = timeout.remaining();
        if (remainingTimeout <= 0L) {
            return Future.failedFuture((Throwable)BasicJdbcClient.timeoutException());
        }
        long startTime = this.clock.millis();
        Promise queryResultPromise = Promise.promise();
        long timerId = this.vertx.setTimer(remainingTimeout, id -> this.timedOutResult(queryResultPromise, startTime));
        Promise connectionPromise = Promise.promise();
        this.jdbcClient.getConnection((Handler)connectionPromise);
        connectionPromise.future().recover(BasicJdbcClient::logConnectionError).compose(connection -> BasicJdbcClient.makeQuery((SQLConnection)connection, (String)query, (List)params)).onComplete(result -> this.handleResult(result, queryResultPromise, timerId, startTime));
        return queryResultPromise.future().map(mapper);
    }

    private void timedOutResult(Promise<ResultSet> queryResultPromise, long startTime) {
        if (!queryResultPromise.future().isComplete()) {
            this.metrics.updateDatabaseQueryTimeMetric(this.clock.millis() - startTime);
            queryResultPromise.fail((Throwable)BasicJdbcClient.timeoutException());
        }
    }

    private static Future<SQLConnection> logConnectionError(Throwable exception) {
        logger.warn((Object)"Cannot connect to database", exception);
        return Future.failedFuture((Throwable)exception);
    }

    private static Future<ResultSet> makeQuery(SQLConnection connection, String query, List<Object> params) {
        Promise resultSetPromise = Promise.promise();
        connection.queryWithParams(query, new JsonArray(params), ar -> {
            connection.close();
            resultSetPromise.handle(ar);
        });
        return resultSetPromise.future();
    }

    private void handleResult(AsyncResult<ResultSet> result, Promise<ResultSet> queryResultPromise, long timerId, long startTime) {
        this.vertx.cancelTimer(timerId);
        if (!queryResultPromise.future().isComplete()) {
            this.metrics.updateDatabaseQueryTimeMetric(this.clock.millis() - startTime);
            queryResultPromise.handle(result);
        }
    }

    private static TimeoutException timeoutException() {
        return new TimeoutException("Timed out while executing SQL query");
    }
}

