/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.vertx.http;

import com.github.benmanes.caffeine.cache.Caffeine;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.metric.Metrics;
import org.prebid.server.vertx.CircuitBreaker;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class CircuitBreakerSecuredHttpClient
implements HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(CircuitBreakerSecuredHttpClient.class);
    private static final ConditionalLogger conditionalLogger = new ConditionalLogger(logger);
    private static final int LOG_PERIOD_SECONDS = 5;
    private final Function<String, CircuitBreaker> circuitBreakerCreator;
    private final Map<String, CircuitBreaker> circuitBreakerByName;
    private final HttpClient httpClient;

    public CircuitBreakerSecuredHttpClient(Vertx vertx, HttpClient httpClient, Metrics metrics, int openingThreshold, long openingIntervalMs, long closingIntervalMs, int idleExpireHours, Clock clock) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.circuitBreakerCreator = name -> this.createCircuitBreaker(name, vertx, openingThreshold, openingIntervalMs, closingIntervalMs, clock, metrics);
        this.circuitBreakerByName = Caffeine.newBuilder().expireAfterAccess((long)idleExpireHours, TimeUnit.HOURS).removalListener((name, cb, cause) -> this.removeCircuitBreakerGauge(name, metrics)).build().asMap();
        metrics.createHttpClientCircuitBreakerNumberGauge(this.circuitBreakerByName::size);
        logger.info((Object)"Initialized HTTP client with Circuit Breaker");
    }

    public Future<HttpClientResponse> request(HttpMethod method, String url, MultiMap headers, String body, long timeoutMs, long maxResponseSize) {
        return ((CircuitBreaker)this.circuitBreakerByName.computeIfAbsent(CircuitBreakerSecuredHttpClient.nameFrom((String)url), this.circuitBreakerCreator)).execute(promise -> this.httpClient.request(method, url, headers, body, timeoutMs, maxResponseSize).onComplete((Handler)promise));
    }

    public Future<HttpClientResponse> request(HttpMethod method, String url, MultiMap headers, byte[] body, long timeoutMs, long maxResponseSize) {
        return ((CircuitBreaker)this.circuitBreakerByName.computeIfAbsent(CircuitBreakerSecuredHttpClient.nameFrom((String)url), this.circuitBreakerCreator)).execute(promise -> this.httpClient.request(method, url, headers, body, timeoutMs, maxResponseSize).onComplete((Handler)promise));
    }

    private CircuitBreaker createCircuitBreaker(String name, Vertx vertx, int openingThreshold, long openingIntervalMs, long closingIntervalMs, Clock clock, Metrics metrics) {
        CircuitBreaker circuitBreaker = new CircuitBreaker("http_cb_" + name, Objects.requireNonNull(vertx), openingThreshold, openingIntervalMs, closingIntervalMs, Objects.requireNonNull(clock)).openHandler(ignored -> this.circuitOpened(name)).halfOpenHandler(ignored -> this.circuitHalfOpened(name)).closeHandler(ignored -> this.circuitClosed(name));
        this.createCircuitBreakerGauge(name, circuitBreaker, metrics);
        return circuitBreaker;
    }

    private void createCircuitBreakerGauge(String name, CircuitBreaker circuitBreaker, Metrics metrics) {
        metrics.createHttpClientCircuitBreakerGauge(CircuitBreakerSecuredHttpClient.idFrom((String)name), () -> ((CircuitBreaker)circuitBreaker).isOpen());
    }

    private void removeCircuitBreakerGauge(String name, Metrics metrics) {
        metrics.removeHttpClientCircuitBreakerGauge(CircuitBreakerSecuredHttpClient.idFrom((String)name));
    }

    private void circuitOpened(String name) {
        conditionalLogger.warn("Http client request to %s is failed, circuit opened.".formatted(name), 5L, TimeUnit.SECONDS);
    }

    private void circuitHalfOpened(String name) {
        logger.warn((Object)"Http client request to {0} will try again, circuit half-opened.", new Object[]{name});
    }

    private void circuitClosed(String name) {
        logger.warn((Object)"Http client request to {0} becomes succeeded, circuit closed.", new Object[]{name});
    }

    private static String nameFrom(String urlAsString) {
        URL url = CircuitBreakerSecuredHttpClient.parseUrl((String)urlAsString);
        return url.getProtocol() + "://" + url.getHost() + (String)(url.getPort() != -1 ? ":" + url.getPort() : "");
    }

    private static String idFrom(String urlAsString) {
        return urlAsString.replaceAll("[^\\w]+", "_");
    }

    private static URL parseUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new PreBidException("Invalid url: " + url, (Throwable)e);
        }
    }
}

