/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.validation;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.json.EncodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.ResourceUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class BidderParamValidator {
    private static final JsonSchemaFactory SCHEMA_FACTORY = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V4);
    private static final String JSON_FILE_EXT = ".json";
    private static final String FILE_SEP = "/";
    private final Map<String, JsonSchema> bidderSchemas;
    private final String schemas;

    private BidderParamValidator(Map<String, JsonSchema> bidderSchemas, String schemas) {
        this.bidderSchemas = bidderSchemas;
        this.schemas = schemas;
    }

    public Set<String> validate(String bidder, JsonNode jsonNode) {
        return ((JsonSchema)this.bidderSchemas.get(bidder)).validate(jsonNode).stream().map(ValidationMessage::getMessage).collect(Collectors.toSet());
    }

    public String schemas() {
        return this.schemas;
    }

    public static BidderParamValidator create(BidderCatalog bidderCatalog, String schemaDirectory, JacksonMapper mapper) {
        Objects.requireNonNull(bidderCatalog);
        Objects.requireNonNull(schemaDirectory);
        Objects.requireNonNull(mapper);
        LinkedHashMap bidderRawSchemas = new LinkedHashMap();
        bidderCatalog.names().forEach(bidder -> bidderRawSchemas.put(bidder, BidderParamValidator.createSchemaNode((String)schemaDirectory, (String)BidderParamValidator.maybeResolveAlias((BidderCatalog)bidderCatalog, (String)bidder), (JacksonMapper)mapper)));
        return new BidderParamValidator(BidderParamValidator.toBidderSchemas(bidderRawSchemas), BidderParamValidator.toSchemas(bidderRawSchemas, (JacksonMapper)mapper));
    }

    private static Map<String, JsonSchema> toBidderSchemas(Map<String, JsonNode> bidderRawSchemas) {
        return (Map)bidderRawSchemas.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> BidderParamValidator.toBidderSchema((JsonNode)((JsonNode)e.getValue()), (String)((String)e.getKey())), (first, second) -> second, CaseInsensitiveMap::new));
    }

    private static String toSchemas(Map<String, JsonNode> bidderRawSchemas, JacksonMapper mapper) {
        try {
            return mapper.encodeToString(bidderRawSchemas);
        }
        catch (EncodeException e) {
            throw new IllegalArgumentException("Couldn't combine json schemas into single json string");
        }
    }

    private static JsonSchema toBidderSchema(JsonNode schema, String bidder) {
        JsonSchema result;
        try {
            result = SCHEMA_FACTORY.getSchema(schema);
        }
        catch (JsonSchemaException e) {
            throw new IllegalArgumentException("Couldn't parse %s bidder schema".formatted(bidder), e);
        }
        return result;
    }

    private static String maybeResolveAlias(BidderCatalog bidderCatalog, String bidder) {
        return (String)ObjectUtils.defaultIfNull((Object)bidderCatalog.bidderInfoByName(bidder).getAliasOf(), (Object)bidder);
    }

    private static JsonNode createSchemaNode(String schemaDirectory, String bidder, JacksonMapper mapper) {
        JsonNode result;
        String path = schemaDirectory + "/" + bidder + ".json";
        try {
            result = BidderParamValidator.toJsonNode((String)ResourceUtil.readFromClasspath((String)path), (String)bidder, (JacksonMapper)mapper);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Couldn't find %s json schema at %s".formatted(bidder, path), e);
        }
        catch (IOException | RuntimeException e) {
            throw new IllegalArgumentException("Failed to load %s json schema at %s".formatted(bidder, path), e);
        }
        return result;
    }

    private static JsonNode toJsonNode(String content, String bidder, JacksonMapper mapper) {
        JsonNode result;
        if (StringUtils.isNotBlank((CharSequence)content)) {
            try {
                result = mapper.mapper().readTree(content);
            }
            catch (JsonSchemaException | IOException e) {
                throw new IllegalArgumentException("Couldn't parse %s bidder schema".formatted(bidder), e);
            }
        } else {
            throw new IllegalArgumentException("Couldn't parse %s bidder schema. File is empty".formatted(bidder));
        }
        return result;
    }
}

