/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config.bidder;

import java.util.function.Function;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.BidderDeps;
import org.prebid.server.bidder.audiencenetwork.AudienceNetworkBidder;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.bidder.AudienceNetworkConfiguration;
import org.prebid.server.spring.config.bidder.model.BidderConfigurationProperties;
import org.prebid.server.spring.config.bidder.util.BidderDepsAssembler;
import org.prebid.server.spring.config.bidder.util.UsersyncerCreator;
import org.prebid.server.spring.env.YamlPropertySourceFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:/bidder-config/audiencenetwork.yaml"}, factory=YamlPropertySourceFactory.class)
public class AudienceNetworkConfiguration {
    private static final String BIDDER_NAME = "audienceNetwork";

    @Bean
    BidderDeps audiencenetworkBidderDeps(AudienceNetworkConfigurationProperties audienceNetworkConfigurationProperties, JacksonMapper mapper) {
        Function<AudienceNetworkConfigurationProperties, Bidder> bidderCreator = config -> new AudienceNetworkBidder(config.getEndpoint(), config.getPlatformId(), config.getAppSecret(), audienceNetworkConfigurationProperties.getTimeoutNotificationUrlTemplate(), mapper);
        return BidderDepsAssembler.forBidder((String)BIDDER_NAME).withConfig((BidderConfigurationProperties)audienceNetworkConfigurationProperties).usersyncerCreator(UsersyncerCreator.create(null)).bidderCreator(audienceNetworkConfigurationProperties.getEnabled() != false ? bidderCreator : null).assemble();
    }
}

