/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config;

import io.vertx.core.Vertx;
import java.time.Clock;
import java.util.Collection;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.hooks.execution.HookCatalog;
import org.prebid.server.hooks.execution.HookStageExecutor;
import org.prebid.server.hooks.v1.Module;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.spring.config.HooksConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HooksConfiguration {
    @Bean
    HookCatalog hookCatalog(Collection<Module> modules) {
        return new HookCatalog(modules);
    }

    @Bean
    HookStageExecutor hookStageExecutor(HooksConfigurationProperties hooksConfiguration, HookCatalog hookCatalog, TimeoutFactory timeoutFactory, Vertx vertx, Clock clock, JacksonMapper mapper) {
        return HookStageExecutor.create((String)hooksConfiguration.getHostExecutionPlan(), (String)hooksConfiguration.getDefaultAccountExecutionPlan(), (HookCatalog)hookCatalog, (TimeoutFactory)timeoutFactory, (Vertx)vertx, (Clock)clock, (JacksonMapper)mapper);
    }

    @Bean
    @ConfigurationProperties(value="hooks")
    HooksConfigurationProperties hooksConfigurationProperties() {
        return new HooksConfigurationProperties();
    }
}

