/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.spring.config;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.List;
import javax.annotation.PostConstruct;
import org.prebid.server.handler.CustomizedAdminEndpoint;
import org.prebid.server.vertx.ContextRunner;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="admin", name={"port"})
public class AdminServerConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(AdminServerConfiguration.class);
    @Autowired
    private ContextRunner contextRunner;
    @Autowired
    private Vertx vertx;
    @Autowired
    @Qualifier(value="adminRouter")
    private Router adminRouter;
    @Value(value="${admin.port}")
    private int adminPort;

    @Bean(name={"adminRouter"})
    Router adminRouter(BodyHandler bodyHandler, List<CustomizedAdminEndpoint> customizedAdminEndpoints) {
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler((Handler)bodyHandler);
        customizedAdminEndpoints.stream().filter(customizedAdminEndpoint -> !customizedAdminEndpoint.isOnApplicationPort()).forEach(customizedAdminEndpoint -> customizedAdminEndpoint.router(router));
        return router;
    }

    @PostConstruct
    public void startAdminServer() {
        logger.info((Object)"Starting Admin Server to serve requests on port {0,number,#}", new Object[]{this.adminPort});
        this.contextRunner.runOnServiceContext(future -> this.vertx.createHttpServer().requestHandler((Handler)this.adminRouter).listen(this.adminPort, (Handler)future));
        logger.info((Object)"Successfully started Admin Server");
    }
}

