/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.prebid.server.settings.model.AccountCoopSyncConfig;

public final class AccountCookieSyncConfig {
    @JsonProperty(value="default-limit")
    private final Integer defaultLimit;
    @JsonProperty(value="max-limit")
    private final Integer maxLimit;
    @JsonProperty(value="pri")
    private final Set<String> prioritizedBidders;
    @JsonProperty(value="coop-sync")
    private final AccountCoopSyncConfig coopSync;

    @ConstructorProperties(value={"defaultLimit", "maxLimit", "prioritizedBidders", "coopSync"})
    private AccountCookieSyncConfig(Integer defaultLimit, Integer maxLimit, Set<String> prioritizedBidders, AccountCoopSyncConfig coopSync) {
        this.defaultLimit = defaultLimit;
        this.maxLimit = maxLimit;
        this.prioritizedBidders = prioritizedBidders;
        this.coopSync = coopSync;
    }

    public static AccountCookieSyncConfig of(Integer defaultLimit, Integer maxLimit, Set<String> prioritizedBidders, AccountCoopSyncConfig coopSync) {
        return new AccountCookieSyncConfig(defaultLimit, maxLimit, prioritizedBidders, coopSync);
    }

    public Integer getDefaultLimit() {
        return this.defaultLimit;
    }

    public Integer getMaxLimit() {
        return this.maxLimit;
    }

    public Set<String> getPrioritizedBidders() {
        return this.prioritizedBidders;
    }

    public AccountCoopSyncConfig getCoopSync() {
        return this.coopSync;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountCookieSyncConfig)) {
            return false;
        }
        AccountCookieSyncConfig other = (AccountCookieSyncConfig)o;
        Integer this$defaultLimit = this.getDefaultLimit();
        Integer other$defaultLimit = other.getDefaultLimit();
        if (this$defaultLimit == null ? other$defaultLimit != null : !((Object)this$defaultLimit).equals(other$defaultLimit)) {
            return false;
        }
        Integer this$maxLimit = this.getMaxLimit();
        Integer other$maxLimit = other.getMaxLimit();
        if (this$maxLimit == null ? other$maxLimit != null : !((Object)this$maxLimit).equals(other$maxLimit)) {
            return false;
        }
        Set this$prioritizedBidders = this.getPrioritizedBidders();
        Set other$prioritizedBidders = other.getPrioritizedBidders();
        if (this$prioritizedBidders == null ? other$prioritizedBidders != null : !((Object)this$prioritizedBidders).equals(other$prioritizedBidders)) {
            return false;
        }
        AccountCoopSyncConfig this$coopSync = this.getCoopSync();
        AccountCoopSyncConfig other$coopSync = other.getCoopSync();
        return !(this$coopSync == null ? other$coopSync != null : !this$coopSync.equals(other$coopSync));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $defaultLimit = this.getDefaultLimit();
        result = result * 59 + ($defaultLimit == null ? 43 : ((Object)$defaultLimit).hashCode());
        Integer $maxLimit = this.getMaxLimit();
        result = result * 59 + ($maxLimit == null ? 43 : ((Object)$maxLimit).hashCode());
        Set $prioritizedBidders = this.getPrioritizedBidders();
        result = result * 59 + ($prioritizedBidders == null ? 43 : ((Object)$prioritizedBidders).hashCode());
        AccountCoopSyncConfig $coopSync = this.getCoopSync();
        result = result * 59 + ($coopSync == null ? 43 : $coopSync.hashCode());
        return result;
    }

    public String toString() {
        return "AccountCookieSyncConfig(defaultLimit=" + this.getDefaultLimit() + ", maxLimit=" + this.getMaxLimit() + ", prioritizedBidders=" + this.getPrioritizedBidders() + ", coopSync=" + this.getCoopSync() + ")";
    }
}

