/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings.helper;

import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.settings.model.StoredDataType;
import org.prebid.server.settings.model.StoredItem;

public class StoredItemResolver {
    private StoredItemResolver() {
    }

    public static StoredItem resolve(StoredDataType type, String accountId, String id, Set<StoredItem> storedItems) {
        if (CollectionUtils.isEmpty(storedItems)) {
            throw new PreBidException("No stored %s found for id: %s".formatted(type, id));
        }
        if (storedItems.size() > 1) {
            if (StringUtils.isEmpty((CharSequence)accountId)) {
                throw new PreBidException("Multiple stored %ss found for id: %s but no account was specified".formatted(type, id));
            }
            return storedItems.stream().filter(storedItem -> Objects.equals(storedItem.getAccountId(), accountId)).findAny().orElseThrow(() -> new PreBidException("No stored %s found among multiple id: %s for account: %s".formatted(type, id, accountId)));
        }
        StoredItem storedItem2 = storedItems.iterator().next();
        if (StringUtils.isBlank((CharSequence)accountId) || storedItem2.getAccountId() == null || Objects.equals(accountId, storedItem2.getAccountId())) {
            return storedItem2;
        }
        throw new PreBidException("No stored %s found for id: %s for account: %s".formatted(type, id, accountId));
    }
}

