/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import java.util.function.Function;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.TcfMetrics;
import org.prebid.server.metric.UpdatableMetrics;

/*
 * Exception performing whole class analysis ignored.
 */
class TcfMetrics
extends UpdatableMetrics {
    private static final int TCF_V1_VERSION = 1;
    private static final int TCF_V2_VERSION = 2;
    private final TcfVersionMetrics tcfVersion1Metrics;
    private final TcfVersionMetrics tcfVersion2Metrics;

    TcfMetrics(MetricRegistry metricRegistry, CounterType counterType, String prefix) {
        super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), TcfMetrics.nameCreator((String)TcfMetrics.createTcfPrefix((String)Objects.requireNonNull(prefix))));
        this.tcfVersion1Metrics = new TcfVersionMetrics(metricRegistry, counterType, TcfMetrics.createTcfPrefix((String)prefix), "v1");
        this.tcfVersion2Metrics = new TcfVersionMetrics(metricRegistry, counterType, TcfMetrics.createTcfPrefix((String)prefix), "v2");
    }

    TcfVersionMetrics fromVersion(int version) {
        return switch (version) {
            case 1 -> this.tcfVersion1Metrics;
            case 2 -> this.tcfVersion2Metrics;
            default -> throw new PreBidException("Unknown tcf version " + version);
        };
    }

    private static String createTcfPrefix(String prefix) {
        return prefix + ".tcf";
    }

    private static Function<MetricName, String> nameCreator(String prefix) {
        return metricName -> "%s.%s".formatted(prefix, metricName);
    }
}

