/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.log;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.RoutingContext;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.BidderRequest;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.HttpInteractionLogger;
import org.prebid.server.log.model.HttpLogSpec;
import org.prebid.server.metric.MetricName;
import org.prebid.server.settings.model.Account;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpInteractionLogger {
    private static final String HTTP_INTERACTION_LOGGER_NAME = "http-interaction";
    private final Logger logger = LoggerFactory.getLogger((String)"http-interaction");
    private final JacksonMapper mapper;
    private final AtomicReference<SpecWithCounter> specWithCounter = new AtomicReference();

    public HttpInteractionLogger(JacksonMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    public void setSpec(HttpLogSpec spec) {
        this.specWithCounter.set(SpecWithCounter.of((HttpLogSpec)spec));
    }

    public void maybeLogOpenrtb2Auction(AuctionContext auctionContext, RoutingContext routingContext, int statusCode, String responseBody) {
        if (this.interactionSatisfiesSpec(HttpLogSpec.Endpoint.auction, statusCode, auctionContext)) {
            this.logger.info((Object)"Requested URL: \"{0}\", request body: \"{1}\", response status: \"{2}\", response body: \"{3}\"", new Object[]{routingContext.request().uri(), this.toOneLineString(routingContext.getBodyAsString()), statusCode, responseBody});
            this.incLoggedInteractions();
        }
    }

    private String toOneLineString(String value) {
        try {
            return this.mapper.encodeToString((Object)this.mapper.mapper().readTree(value));
        }
        catch (JsonProcessingException e) {
            return "Not parseable JSON passed: " + value.replaceAll("[\r\n]+", " ");
        }
    }

    public void maybeLogOpenrtb2Amp(AuctionContext auctionContext, RoutingContext routingContext, int statusCode, String responseBody) {
        if (this.interactionSatisfiesSpec(HttpLogSpec.Endpoint.amp, statusCode, auctionContext)) {
            this.logger.info((Object)"Requested URL: \"{0}\", response status: \"{1}\", response body: \"{2}\"", new Object[]{routingContext.request().uri(), statusCode, responseBody});
            this.incLoggedInteractions();
        }
    }

    public void maybeLogBidderRequest(AuctionContext context, BidderRequest bidderRequest) {
        String bidder = bidderRequest.getBidder();
        if (this.interactionSatisfiesSpec(context, bidder)) {
            BidRequest bidRequest = bidderRequest.getBidRequest();
            BidRequest updatedBidRequest = this.bidRequestWithBidderName(bidder, bidRequest);
            String jsonBidRequest = this.mapper.encodeToString((Object)updatedBidRequest);
            this.logger.info((Object)"Request body to {0}: \"{1}\"", new Object[]{bidder, jsonBidRequest});
            this.incLoggedInteractions();
        }
    }

    private boolean interactionSatisfiesSpec(HttpLogSpec.Endpoint requestEndpoint, int requestStatusCode, AuctionContext auctionContext) {
        SpecWithCounter specWithCounter = (SpecWithCounter)this.specWithCounter.get();
        if (specWithCounter == null) {
            return false;
        }
        Account requestAccount = (Account)ObjectUtil.getIfNotNull((Object)auctionContext, AuctionContext::getAccount);
        String requestAccountId = (String)ObjectUtil.getIfNotNull((Object)requestAccount, Account::getId);
        HttpLogSpec spec = specWithCounter.getSpec();
        HttpLogSpec.Endpoint endpoint = spec.getEndpoint();
        Integer statusCode = spec.getStatusCode();
        String account = spec.getAccount();
        return !(endpoint != null && endpoint != requestEndpoint || statusCode != null && statusCode != requestStatusCode || account != null && !account.equals(requestAccountId));
    }

    private boolean interactionSatisfiesSpec(AuctionContext auctionContext, String requestBidder) {
        SpecWithCounter specWithCounter = (SpecWithCounter)this.specWithCounter.get();
        if (specWithCounter == null) {
            return false;
        }
        HttpLogSpec.Endpoint requestEndpoint = this.parseHttpLogEndpoint((MetricName)ObjectUtil.getIfNotNull((Object)auctionContext, AuctionContext::getRequestTypeMetric));
        Account requestAccount = (Account)ObjectUtil.getIfNotNull((Object)auctionContext, AuctionContext::getAccount);
        String requestAccountId = requestAccount != null ? requestAccount.getId() : null;
        HttpLogSpec spec = specWithCounter.getSpec();
        HttpLogSpec.Endpoint endpoint = spec.getEndpoint();
        String account = spec.getAccount();
        String bidder = spec.getBidder();
        return !(endpoint != null && endpoint != requestEndpoint || account != null && !account.equals(requestAccountId) || bidder == null || !bidder.equals(requestBidder));
    }

    private HttpLogSpec.Endpoint parseHttpLogEndpoint(MetricName requestTypeMetric) {
        if (requestTypeMetric != null) {
            if (requestTypeMetric == MetricName.amp) {
                return HttpLogSpec.Endpoint.amp;
            }
            if (requestTypeMetric == MetricName.openrtb2app || requestTypeMetric == MetricName.openrtb2web || requestTypeMetric == MetricName.openrtb2dooh) {
                return HttpLogSpec.Endpoint.auction;
            }
        }
        return null;
    }

    private void incLoggedInteractions() {
        SpecWithCounter specWithCounter = (SpecWithCounter)this.specWithCounter.get();
        if (specWithCounter != null && specWithCounter.getLoggedInteractions().incrementAndGet() >= (long)specWithCounter.getSpec().getLimit()) {
            this.specWithCounter.set(null);
        }
    }

    private BidRequest bidRequestWithBidderName(String bidder, BidRequest bidRequest) {
        List imps = bidRequest.getImp();
        if (CollectionUtils.isEmpty((Collection)imps)) {
            return bidRequest;
        }
        List<Imp> updatedImps = imps.stream().map(imp -> this.makeImpExtBidderName(bidder, imp)).toList();
        return bidRequest.toBuilder().imp(updatedImps).build();
    }

    private Imp makeImpExtBidderName(String bidder, Imp imp) {
        ObjectNode originalImpExt = imp.getExt();
        if (originalImpExt == null) {
            return imp;
        }
        ObjectNode impExt = originalImpExt.deepCopy();
        Imp updatedImp = imp.toBuilder().ext(impExt).build();
        JsonNode impExtBidder = impExt.remove("bidder");
        if (impExtBidder != null) {
            impExt.set(bidder, impExtBidder);
        }
        return updatedImp;
    }
}

