/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.health;

import io.vertx.core.Vertx;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.geolocation.GeoLocationService;
import org.prebid.server.health.PeriodicHealthChecker;
import org.prebid.server.health.model.Status;
import org.prebid.server.health.model.StatusResponse;

public class GeoLocationHealthChecker
extends PeriodicHealthChecker {
    private static final String NAME = "geolocation";
    private static final String PREBID_ORG_IP = "185.199.111.153";
    private static final Long TIMEOUT_MILLIS = 1000L;
    private final GeoLocationService geoLocationService;
    private final TimeoutFactory timeoutFactory;
    private final Clock clock;
    private StatusResponse status;

    public GeoLocationHealthChecker(Vertx vertx, long refreshPeriod, GeoLocationService geoLocationService, TimeoutFactory timeoutFactory, Clock clock) {
        super(vertx, refreshPeriod);
        this.geoLocationService = Objects.requireNonNull(geoLocationService);
        this.timeoutFactory = Objects.requireNonNull(timeoutFactory);
        this.clock = Objects.requireNonNull(clock);
    }

    void updateStatus() {
        this.geoLocationService.lookup(PREBID_ORG_IP, this.timeoutFactory.create(TIMEOUT_MILLIS.longValue())).onComplete(result -> {
            this.status = StatusResponse.of((String)(result.succeeded() ? Status.UP.name() : Status.DOWN.name()), (ZonedDateTime)ZonedDateTime.now(this.clock));
        });
    }

    public String name() {
        return NAME;
    }

    public StatusResponse status() {
        return this.status;
    }
}

