/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.prebid.server.cookie.UidsCookie;
import org.prebid.server.cookie.UidsCookieService;
import org.prebid.server.cookie.model.UidWithExpiry;
import org.prebid.server.handler.GetuidsHandler;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.model.Endpoint;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class GetuidsHandler
implements Handler<RoutingContext> {
    private final UidsCookieService uidsCookieService;
    private final JacksonMapper mapper;

    public GetuidsHandler(UidsCookieService uidsCookieService, JacksonMapper mapper) {
        this.uidsCookieService = Objects.requireNonNull(uidsCookieService);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public void handle(RoutingContext routingContext) {
        Map uids = this.uidsFrom(routingContext);
        String body = this.mapper.encodeToString((Object)BuyerUids.of((Map)uids));
        HttpUtil.executeSafely((RoutingContext)routingContext, (Endpoint)Endpoint.getuids, response -> response.putHeader(HttpUtil.CONTENT_TYPE_HEADER, (CharSequence)HttpUtil.APPLICATION_JSON_CONTENT_TYPE).end(body));
    }

    private Map<String, String> uidsFrom(RoutingContext routingContext) {
        UidsCookie uidsCookie = this.uidsCookieService.parseFromRequest(routingContext);
        return uidsCookie.getCookieUids().getUids().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, uidEntry -> ((UidWithExpiry)uidEntry.getValue()).getUid()));
    }
}

