/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.settings.CachingApplicationSettings;
import org.prebid.server.util.HttpUtil;

public class AccountCacheInvalidationHandler
implements Handler<RoutingContext> {
    private static final String ACCOUNT_ID_PARAM = "account";
    private final CachingApplicationSettings cachingApplicationSettings;
    private final String endpoint;

    public AccountCacheInvalidationHandler(CachingApplicationSettings cachingApplicationSettings, String endpoint) {
        this.cachingApplicationSettings = Objects.requireNonNull(cachingApplicationSettings);
        this.endpoint = Objects.requireNonNull(endpoint);
    }

    public void handle(RoutingContext routingContext) {
        String accountId = routingContext.request().getParam(ACCOUNT_ID_PARAM);
        if (StringUtils.isBlank((CharSequence)accountId)) {
            HttpUtil.executeSafely((RoutingContext)routingContext, (String)this.endpoint, response -> response.setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Account id is not defined"));
        } else {
            this.cachingApplicationSettings.invalidateAccountCache(accountId);
            HttpUtil.executeSafely((RoutingContext)routingContext, (String)this.endpoint, HttpServerResponse::end);
        }
    }
}

