/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.events;

import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.events.EventRequest;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventUtil {
    private static final String TEMPLATE_URL = "%s/event?t=%s&b=%s&a=%s";
    private static final String TYPE_PARAMETER = "t";
    private static final String WIN_TYPE = "win";
    private static final String IMP_TYPE = "imp";
    private static final String BID_ID_PARAMETER = "b";
    private static final String ACCOUNT_ID_PARAMETER = "a";
    private static final String BIDDER_PARAMETER = "bidder";
    private static final String TIMESTAMP_PARAMETER = "ts";
    private static final String AUCTION_ID = "aid";
    private static final String FORMAT_PARAMETER = "f";
    private static final String BLANK_FORMAT = "b";
    private static final String IMAGE_FORMAT = "i";
    private static final String INTEGRATION_PARAMETER = "int";
    private static final int INTEGRATION_PARAMETER_MAX_LENGTH = 64;
    private static final String ANALYTICS_PARAMETER = "x";
    private static final String ENABLED_ANALYTICS = "1";
    private static final String DISABLED_ANALYTICS = "0";
    private static final String LINE_ITEM_ID_PARAMETER = "l";

    private EventUtil() {
    }

    public static void validateType(RoutingContext routingContext) {
        String type = routingContext.request().params().get("t");
        if (ObjectUtils.notEqual((Object)type, (Object)"imp") && ObjectUtils.notEqual((Object)type, (Object)"win")) {
            throw new IllegalArgumentException("Type '%s' is required query parameter. Possible values are %s and %s, but was %s".formatted("t", "win", "imp", type));
        }
    }

    public static void validateAccountId(RoutingContext routingContext) {
        String accountId = routingContext.request().params().get("a");
        if (StringUtils.isBlank((CharSequence)accountId)) {
            throw new IllegalArgumentException("Account '%s' is required query parameter and can't be empty".formatted("a"));
        }
    }

    public static void validateBidId(RoutingContext routingContext) {
        String bidId = routingContext.request().params().get("b");
        if (StringUtils.isBlank((CharSequence)bidId)) {
            throw new IllegalArgumentException("BidId '%s' is required query parameter and can't be empty".formatted("b"));
        }
    }

    public static void validateFormat(RoutingContext routingContext) {
        String format = routingContext.request().params().get("f");
        if (StringUtils.isNotEmpty((CharSequence)format) && !format.equals("b") && !format.equals("i")) {
            throw new IllegalArgumentException("Format '%s' query parameter is invalid. Possible values are %s and %s, but was %s".formatted("f", "b", "i", format));
        }
    }

    public static void validateAnalytics(RoutingContext routingContext) {
        String analytics = routingContext.request().params().get("x");
        if (StringUtils.isNotEmpty((CharSequence)analytics) && !analytics.equals("1") && !analytics.equals("0")) {
            throw new IllegalArgumentException("Analytics '%s' query parameter is invalid. Possible values are %s and %s, but was %s".formatted("x", "1", "0", analytics));
        }
    }

    public static void validateTimestamp(RoutingContext routingContext) {
        String timestamp = StringUtils.stripToNull((String)routingContext.request().params().get("ts"));
        if (timestamp != null) {
            try {
                Long.parseLong(timestamp);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Timestamp '%s' query parameter is not valid number: %s".formatted("ts", timestamp));
            }
        }
    }

    public static void validateIntegration(RoutingContext routingContext) {
        String value = routingContext.request().getParam("int");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            if (value.length() > 64) {
                throw new IllegalArgumentException("Integration '%s' query parameter is longer %s symbols: %s".formatted("int", 64, value));
            }
            for (int i = 0; i < value.length(); ++i) {
                if (Character.isLetterOrDigit(value.charAt(i)) || value.charAt(i) == '-' || value.charAt(i) == '_') continue;
                throw new IllegalArgumentException("Integration '%s' query parameter is not valid: %s".formatted("int", value));
            }
        }
    }

    public static EventRequest from(RoutingContext routingContext) {
        MultiMap queryParams = routingContext.request().params();
        String typeAsString = queryParams.get("t");
        EventRequest.Type type = typeAsString.equals("win") ? EventRequest.Type.win : EventRequest.Type.imp;
        EventRequest.Format format = Objects.equals(queryParams.get("f"), "i") ? EventRequest.Format.image : EventRequest.Format.blank;
        EventRequest.Analytics analytics = Objects.equals("0", queryParams.get("x")) ? EventRequest.Analytics.disabled : EventRequest.Analytics.enabled;
        String timestampAsString = StringUtils.stripToNull((String)queryParams.get("ts"));
        Long timestamp = timestampAsString != null ? Long.valueOf(timestampAsString) : null;
        String auctionId = StringUtils.stripToNull((String)queryParams.get("aid"));
        return EventRequest.builder().type(type).bidId(queryParams.get("b")).auctionId(auctionId).accountId(queryParams.get("a")).bidder(queryParams.get("bidder")).timestamp(timestamp).format(format).analytics(analytics).integration(queryParams.get("int")).lineItemId(queryParams.get("l")).build();
    }

    static String toUrl(String externalUrl, EventRequest eventRequest) {
        String urlWithRequiredParameters = "%s/event?t=%s&b=%s&a=%s".formatted(externalUrl, eventRequest.getType(), eventRequest.getBidId(), eventRequest.getAccountId());
        return urlWithRequiredParameters + EventUtil.optionalParameters((EventRequest)eventRequest);
    }

    private static String optionalParameters(EventRequest eventRequest) {
        StringBuilder result = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)eventRequest.getAuctionId())) {
            result.append(EventUtil.nameValueAsQueryString((String)"aid", (String)eventRequest.getAuctionId()));
        }
        if (eventRequest.getTimestamp() != null) {
            result.append(EventUtil.nameValueAsQueryString((String)"ts", (String)eventRequest.getTimestamp().toString()));
        }
        if (StringUtils.isNotEmpty((CharSequence)eventRequest.getBidder())) {
            result.append(EventUtil.nameValueAsQueryString((String)"bidder", (String)eventRequest.getBidder()));
        }
        if (eventRequest.getFormat() == EventRequest.Format.blank) {
            result.append(EventUtil.nameValueAsQueryString((String)"f", (String)"b"));
        } else if (eventRequest.getFormat() == EventRequest.Format.image) {
            result.append(EventUtil.nameValueAsQueryString((String)"f", (String)"i"));
        }
        result.append(EventUtil.nameValueAsQueryString((String)"int", (String)StringUtils.stripToEmpty((String)eventRequest.getIntegration())));
        if (eventRequest.getAnalytics() == EventRequest.Analytics.enabled) {
            result.append(EventUtil.nameValueAsQueryString((String)"x", (String)"1"));
        } else if (eventRequest.getAnalytics() == EventRequest.Analytics.disabled) {
            result.append(EventUtil.nameValueAsQueryString((String)"x", (String)"0"));
        }
        result.append(StringUtils.isNotEmpty((CharSequence)eventRequest.getLineItemId()) ? EventUtil.nameValueAsQueryString((String)"l", (String)eventRequest.getLineItemId()) : "");
        return result.toString();
    }

    private static String nameValueAsQueryString(String name, String value) {
        return "&" + name + "=" + value;
    }
}

