/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.model;

import java.beans.ConstructorProperties;
import org.prebid.server.deals.model.SimulationProperties;

public final class SimulationProperties {
    private final boolean enabled;
    private final boolean winEventsEnabled;
    private final boolean userDetailsEnabled;

    @ConstructorProperties(value={"enabled", "winEventsEnabled", "userDetailsEnabled"})
    SimulationProperties(boolean enabled, boolean winEventsEnabled, boolean userDetailsEnabled) {
        this.enabled = enabled;
        this.winEventsEnabled = winEventsEnabled;
        this.userDetailsEnabled = userDetailsEnabled;
    }

    public static SimulationPropertiesBuilder builder() {
        return new SimulationPropertiesBuilder();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isWinEventsEnabled() {
        return this.winEventsEnabled;
    }

    public boolean isUserDetailsEnabled() {
        return this.userDetailsEnabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimulationProperties)) {
            return false;
        }
        SimulationProperties other = (SimulationProperties)o;
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isWinEventsEnabled() != other.isWinEventsEnabled()) {
            return false;
        }
        return this.isUserDetailsEnabled() == other.isUserDetailsEnabled();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isWinEventsEnabled() ? 79 : 97);
        result = result * 59 + (this.isUserDetailsEnabled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SimulationProperties(enabled=" + this.isEnabled() + ", winEventsEnabled=" + this.isWinEventsEnabled() + ", userDetailsEnabled=" + this.isUserDetailsEnabled() + ")";
    }
}

