/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.cache.model.DebugHttpCall;
import org.prebid.server.cookie.UidsCookie;
import org.prebid.server.cookie.model.UidWithExpiry;
import org.prebid.server.deals.LineItemService;
import org.prebid.server.deals.lineitem.LineItem;
import org.prebid.server.deals.model.User;
import org.prebid.server.deals.model.UserDetails;
import org.prebid.server.deals.model.UserDetailsProperties;
import org.prebid.server.deals.model.UserDetailsRequest;
import org.prebid.server.deals.model.UserDetailsResponse;
import org.prebid.server.deals.model.UserId;
import org.prebid.server.deals.model.UserIdRule;
import org.prebid.server.deals.model.WinEventNotification;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserService {
    private static final Logger logger = LoggerFactory.getLogger(UserService.class);
    private static final String USER_SERVICE = "userservice";
    private static final DateTimeFormatter UTC_MILLIS_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").toFormatter();
    private final LineItemService lineItemService;
    private final HttpClient httpClient;
    private final Clock clock;
    private final Metrics metrics;
    private final JacksonMapper mapper;
    private final String userDetailsUrl;
    private final String winEventUrl;
    private final long timeout;
    private final List<UserIdRule> userIdRules;
    private final String dataCenterRegion;

    public UserService(UserDetailsProperties userDetailsProperties, String dataCenterRegion, LineItemService lineItemService, HttpClient httpClient, Clock clock, Metrics metrics, JacksonMapper mapper) {
        this.lineItemService = Objects.requireNonNull(lineItemService);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.clock = Objects.requireNonNull(clock);
        this.metrics = Objects.requireNonNull(metrics);
        this.userDetailsUrl = Objects.requireNonNull(HttpUtil.validateUrl((String)userDetailsProperties.getUserDetailsEndpoint()));
        this.winEventUrl = Objects.requireNonNull(HttpUtil.validateUrl((String)userDetailsProperties.getWinEventEndpoint()));
        this.timeout = userDetailsProperties.getTimeout();
        this.userIdRules = Objects.requireNonNull(userDetailsProperties.getUserIds());
        this.dataCenterRegion = Objects.requireNonNull(dataCenterRegion);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Future<UserDetails> getUserDetails(AuctionContext context, Timeout timeout) {
        Map uidsMap = context.getUidsCookie().getCookieUids().getUids();
        if (CollectionUtils.isEmpty(uidsMap.values())) {
            this.metrics.updateUserDetailsRequestPreparationFailed();
            context.getDebugHttpCalls().put("userservice", Collections.singletonList(DebugHttpCall.empty()));
            return Future.succeededFuture((Object)UserDetails.empty());
        }
        List userIds = this.getUserIds(uidsMap);
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            this.metrics.updateUserDetailsRequestPreparationFailed();
            context.getDebugHttpCalls().put("userservice", Collections.singletonList(DebugHttpCall.empty()));
            return Future.succeededFuture((Object)UserDetails.empty());
        }
        UserDetailsRequest userDetailsRequest = UserDetailsRequest.of((String)UTC_MILLIS_FORMATTER.format(ZonedDateTime.now(this.clock)), (List)userIds);
        String body = this.mapper.encodeToString((Object)userDetailsRequest);
        long requestTimeout = Math.min(this.timeout, timeout.remaining());
        long startTime = this.clock.millis();
        return this.httpClient.post(this.userDetailsUrl, body, requestTimeout).map(httpClientResponse -> this.toUserServiceResult(httpClientResponse, context, this.userDetailsUrl, body, startTime)).recover(throwable -> this.failGetDetailsResponse(throwable, context, this.userDetailsUrl, body, startTime));
    }

    private List<UserId> getUserIds(Map<String, UidWithExpiry> bidderToUid) {
        ArrayList<UserId> userIds = new ArrayList<UserId>();
        for (UserIdRule rule : this.userIdRules) {
            UidWithExpiry uid = bidderToUid.get(rule.getLocation());
            if (uid == null) continue;
            userIds.add(UserId.of((String)rule.getType(), (String)uid.getUid()));
        }
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserDetails toUserServiceResult(HttpClientResponse clientResponse, AuctionContext context, String requestUrl, String requestBody, long startTime) {
        User user;
        int responseStatusCode = clientResponse.getStatusCode();
        UserService.verifyStatusCode((int)responseStatusCode);
        String responseBody = clientResponse.getBody();
        int responseTime = this.responseTime(startTime);
        try {
            user = this.parseUserDetailsResponse(responseBody);
        }
        finally {
            context.getDebugHttpCalls().put("userservice", Collections.singletonList(DebugHttpCall.builder().requestUri(requestUrl).requestBody(requestBody).responseStatus(Integer.valueOf(responseStatusCode)).responseBody(responseBody).responseTimeMillis(Integer.valueOf(responseTime)).build()));
        }
        this.metrics.updateRequestTimeMetric(MetricName.user_details_request_time, (long)responseTime);
        this.metrics.updateUserDetailsRequestMetric(true);
        return UserDetails.of((List)user.getData(), (List)user.getExt().getFcapIds());
    }

    private User parseUserDetailsResponse(String responseBody) {
        UserDetailsResponse userDetailsResponse;
        try {
            userDetailsResponse = (UserDetailsResponse)this.mapper.decodeValue(responseBody, UserDetailsResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException("Cannot parse response: " + responseBody, (Throwable)e);
        }
        User user = userDetailsResponse.getUser();
        if (user == null) {
            throw new PreBidException("Field 'user' is missing in response: " + responseBody);
        }
        if (user.getData() == null) {
            throw new PreBidException("Field 'user.data' is missing in response: " + responseBody);
        }
        if (user.getExt() == null) {
            throw new PreBidException("Field 'user.ext' is missing in response: " + responseBody);
        }
        return user;
    }

    private static void verifyStatusCode(int statusCode) {
        if (statusCode != 200) {
            throw new PreBidException("Bad response status code: " + statusCode);
        }
    }

    private Future<UserDetails> failGetDetailsResponse(Throwable exception, AuctionContext context, String requestUrl, String requestBody, long startTime) {
        int responseTime = this.responseTime(startTime);
        context.getDebugHttpCalls().putIfAbsent("userservice", Collections.singletonList(DebugHttpCall.builder().requestUri(requestUrl).requestBody(requestBody).responseTimeMillis(Integer.valueOf(responseTime)).build()));
        this.metrics.updateUserDetailsRequestMetric(false);
        this.metrics.updateRequestTimeMetric(MetricName.user_details_request_time, (long)responseTime);
        logger.warn((Object)"Error occurred while fetching user details", exception);
        return Future.failedFuture((Throwable)exception);
    }

    private int responseTime(long startTime) {
        return Math.toIntExact(this.clock.millis() - startTime);
    }

    public void processWinEvent(String lineItemId, String bidId, UidsCookie uids) {
        List userIds;
        LineItem lineItem = this.lineItemService.getLineItemById(lineItemId);
        if (!UserService.hasRequiredData((LineItem)lineItem, (List)(userIds = this.getUserIds(uids.getCookieUids().getUids())), (String)lineItemId)) {
            this.metrics.updateWinRequestPreparationFailed();
            return;
        }
        String body = this.mapper.encodeToString((Object)WinEventNotification.builder().bidderCode(lineItem.getSource()).bidId(bidId).lineItemId(lineItemId).region(this.dataCenterRegion).userIds(userIds).winEventDateTime(ZonedDateTime.now(this.clock)).lineUpdatedDateTime(lineItem.getUpdatedTimeStamp()).frequencyCaps(lineItem.getFrequencyCaps()).build());
        this.metrics.updateWinNotificationMetric();
        long startTime = this.clock.millis();
        this.httpClient.post(this.winEventUrl, body, this.timeout).onComplete(result -> this.handleWinResponse(result, startTime));
    }

    private static boolean hasRequiredData(LineItem lineItem, List<UserId> userIds, String lineItemId) {
        if (lineItem == null) {
            logger.error((Object)"Meta Data for Line Item Id {0} does not exist", new Object[]{lineItemId});
            return false;
        }
        if (CollectionUtils.isEmpty(userIds)) {
            logger.error((Object)"User Ids cannot be empty");
            return false;
        }
        return true;
    }

    private void handleWinResponse(AsyncResult<HttpClientResponse> asyncResult, long startTime) {
        this.metrics.updateWinRequestTime((long)this.responseTime(startTime));
        if (asyncResult.succeeded()) {
            try {
                UserService.verifyStatusCode((int)((HttpClientResponse)asyncResult.result()).getStatusCode());
                this.metrics.updateWinEventRequestMetric(true);
            }
            catch (PreBidException e) {
                this.metrics.updateWinEventRequestMetric(false);
                UserService.logWinEventError((Throwable)e);
            }
        } else {
            this.metrics.updateWinEventRequestMetric(false);
            UserService.logWinEventError((Throwable)asyncResult.cause());
        }
    }

    private static void logWinEventError(Throwable exception) {
        logger.warn((Object)"Error occurred while pushing win event notification", exception);
    }
}

