/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.deals.AlertHttpService;
import org.prebid.server.deals.DeliveryProgressService;
import org.prebid.server.deals.Suspendable;
import org.prebid.server.deals.events.AdminEventService;
import org.prebid.server.deals.model.AdminCentralResponse;
import org.prebid.server.deals.model.AlertPriority;
import org.prebid.server.deals.model.DeploymentProperties;
import org.prebid.server.deals.model.PlannerProperties;
import org.prebid.server.deals.proto.CurrencyServiceState;
import org.prebid.server.deals.proto.RegisterRequest;
import org.prebid.server.deals.proto.Status;
import org.prebid.server.deals.proto.report.DeliveryProgressReport;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.health.HealthMonitor;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.vertx.Initializable;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class RegisterService
implements Initializable,
Suspendable {
    private static final Logger logger = LoggerFactory.getLogger(RegisterService.class);
    private static final DateTimeFormatter UTC_MILLIS_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").toFormatter();
    private static final String BASIC_AUTH_PATTERN = "Basic %s";
    private static final String PG_TRX_ID = "pg-trx-id";
    private static final String PBS_REGISTER_CLIENT_ERROR = "pbs-register-client-error";
    private static final String SERVICE_NAME = "register";
    private final PlannerProperties plannerProperties;
    private final DeploymentProperties deploymentProperties;
    private final AdminEventService adminEventService;
    private final DeliveryProgressService deliveryProgressService;
    private final AlertHttpService alertHttpService;
    private final HealthMonitor healthMonitor;
    private final CurrencyConversionService currencyConversionService;
    private final HttpClient httpClient;
    private final Vertx vertx;
    private final JacksonMapper mapper;
    private final long registerTimeout;
    private final long registerPeriod;
    private final String basicAuthHeader;
    private volatile long registerTimerId;
    private volatile boolean isSuspended;

    public RegisterService(PlannerProperties plannerProperties, DeploymentProperties deploymentProperties, AdminEventService adminEventService, DeliveryProgressService deliveryProgressService, AlertHttpService alertHttpService, HealthMonitor healthMonitor, CurrencyConversionService currencyConversionService, HttpClient httpClient, Vertx vertx, JacksonMapper mapper) {
        this.plannerProperties = Objects.requireNonNull(plannerProperties);
        this.deploymentProperties = Objects.requireNonNull(deploymentProperties);
        this.adminEventService = Objects.requireNonNull(adminEventService);
        this.deliveryProgressService = Objects.requireNonNull(deliveryProgressService);
        this.alertHttpService = Objects.requireNonNull(alertHttpService);
        this.healthMonitor = Objects.requireNonNull(healthMonitor);
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.vertx = Objects.requireNonNull(vertx);
        this.mapper = Objects.requireNonNull(mapper);
        this.registerTimeout = plannerProperties.getTimeoutMs();
        this.registerPeriod = TimeUnit.SECONDS.toMillis(plannerProperties.getRegisterPeriodSeconds());
        this.basicAuthHeader = RegisterService.authHeader((String)plannerProperties.getUsername(), (String)plannerProperties.getPassword());
    }

    private static String authHeader(String username, String password) {
        return "Basic %s".formatted(Base64.getEncoder().encodeToString((username + ":" + password).getBytes()));
    }

    public void suspend() {
        this.isSuspended = true;
        this.vertx.cancelTimer(this.registerTimerId);
    }

    public void initialize() {
        this.registerTimerId = this.vertx.setPeriodic(this.registerPeriod, ignored -> this.performRegistration());
        this.performRegistration();
    }

    public void performRegistration() {
        this.register(this.headers());
    }

    protected void register(MultiMap headers) {
        if (this.isSuspended) {
            logger.warn((Object)"Register request was not sent to general planner, as planner service is suspended from register endpoint.");
            return;
        }
        BigDecimal healthIndex = this.healthMonitor.calculateHealthIndex();
        ZonedDateTime currencyLastUpdate = this.currencyConversionService.getLastUpdated();
        RegisterRequest request = RegisterRequest.of((BigDecimal)healthIndex, (Status)Status.of((CurrencyServiceState)(currencyLastUpdate != null ? CurrencyServiceState.of((String)UTC_MILLIS_FORMATTER.format(currencyLastUpdate)) : null), (DeliveryProgressReport)this.deliveryProgressService.getOverallDeliveryProgressReport()), (String)this.deploymentProperties.getPbsHostId(), (String)this.deploymentProperties.getPbsRegion(), (String)this.deploymentProperties.getPbsVendor());
        String body = this.mapper.encodeToString((Object)request);
        logger.info((Object)"Sending register request to Planner, {0} is {1}", new Object[]{"pg-trx-id", headers.get("pg-trx-id")});
        logger.debug((Object)"Register request payload: {0}", new Object[]{body});
        this.httpClient.post(this.plannerProperties.getRegisterEndpoint(), headers, body, this.registerTimeout).onComplete(arg_0 -> this.handleRegister(arg_0));
    }

    protected MultiMap headers() {
        return MultiMap.caseInsensitiveMultiMap().add(HttpUtil.AUTHORIZATION_HEADER, (CharSequence)this.basicAuthHeader).add("pg-trx-id", UUID.randomUUID().toString());
    }

    private void handleRegister(AsyncResult<HttpClientResponse> asyncResult) {
        if (asyncResult.failed()) {
            Throwable cause = asyncResult.cause();
            String errorMessage = "Error occurred while registering with the Planner: " + cause;
            this.alert(errorMessage, arg_0 -> ((Logger)logger).warn(arg_0));
        } else {
            HttpClientResponse response = (HttpClientResponse)asyncResult.result();
            int statusCode = response.getStatusCode();
            String responseBody = response.getBody();
            if (statusCode == HttpResponseStatus.OK.code()) {
                if (StringUtils.isNotBlank((CharSequence)responseBody)) {
                    this.adminEventService.publishAdminCentralEvent(this.parseRegisterResponse(responseBody));
                }
                this.alertHttpService.resetAlertCount("pbs-register-client-error");
            } else {
                String errorMessage = "Planner responded with non-successful code %s, response: %s".formatted(statusCode, responseBody);
                this.alert(errorMessage, arg_0 -> ((Logger)logger).warn(arg_0));
            }
        }
    }

    private AdminCentralResponse parseRegisterResponse(String responseBody) {
        try {
            return (AdminCentralResponse)this.mapper.decodeValue(responseBody, AdminCentralResponse.class);
        }
        catch (DecodeException e) {
            String errorMessage = "Cannot parse register response: " + responseBody;
            this.alert(errorMessage, arg_0 -> ((Logger)logger).warn(arg_0));
            throw new PreBidException(errorMessage, (Throwable)e);
        }
    }

    private void alert(String message, Consumer<String> logger) {
        this.alertHttpService.alertWithPeriod("register", "pbs-register-client-error", AlertPriority.MEDIUM, message);
        logger.accept(message);
    }
}

