/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.deals.DeliveryProgressReportFactory;
import org.prebid.server.deals.DeliveryStatsService;
import org.prebid.server.deals.LineItemService;
import org.prebid.server.deals.events.ApplicationEventProcessor;
import org.prebid.server.deals.lineitem.DeliveryPlan;
import org.prebid.server.deals.lineitem.DeliveryProgress;
import org.prebid.server.deals.lineitem.LineItem;
import org.prebid.server.deals.lineitem.LineItemStatus;
import org.prebid.server.deals.model.DeliveryProgressProperties;
import org.prebid.server.deals.model.TxnLog;
import org.prebid.server.deals.proto.report.DeliveryProgressReport;
import org.prebid.server.deals.proto.report.DeliverySchedule;
import org.prebid.server.deals.proto.report.LineItemStatusReport;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.log.CriteriaLogManager;

public class DeliveryProgressService
implements ApplicationEventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DeliveryProgressService.class);
    private final DeliveryProgressProperties deliveryProgressProperties;
    private final LineItemService lineItemService;
    private final DeliveryStatsService deliveryStatsService;
    private final DeliveryProgressReportFactory deliveryProgressReportFactory;
    private final Clock clock;
    private final CriteriaLogManager criteriaLogManager;
    private final long lineItemStatusTtl;
    protected final DeliveryProgress overallDeliveryProgress;
    protected DeliveryProgress currentDeliveryProgress;

    public DeliveryProgressService(DeliveryProgressProperties deliveryProgressProperties, LineItemService lineItemService, DeliveryStatsService deliveryStatsService, DeliveryProgressReportFactory deliveryProgressReportFactory, Clock clock, CriteriaLogManager criteriaLogManager) {
        this.deliveryProgressProperties = Objects.requireNonNull(deliveryProgressProperties);
        this.lineItemService = Objects.requireNonNull(lineItemService);
        this.deliveryStatsService = Objects.requireNonNull(deliveryStatsService);
        this.deliveryProgressReportFactory = Objects.requireNonNull(deliveryProgressReportFactory);
        this.clock = Objects.requireNonNull(clock);
        this.criteriaLogManager = Objects.requireNonNull(criteriaLogManager);
        this.lineItemStatusTtl = TimeUnit.SECONDS.toMillis(deliveryProgressProperties.getLineItemStatusTtlSeconds());
        ZonedDateTime now = ZonedDateTime.now(clock);
        this.overallDeliveryProgress = DeliveryProgress.of((ZonedDateTime)now, (LineItemService)lineItemService);
        this.currentDeliveryProgress = DeliveryProgress.of((ZonedDateTime)now, (LineItemService)lineItemService);
    }

    public void shutdown() {
        this.createDeliveryProgressReports(ZonedDateTime.now(this.clock));
        this.deliveryStatsService.sendDeliveryProgressReports();
    }

    public DeliveryProgressReport getOverallDeliveryProgressReport() {
        DeliveryProgress overallDeliveryProgressCopy = this.overallDeliveryProgress.copyWithOriginalPlans();
        this.lineItemService.getLineItems().forEach(lineItem -> overallDeliveryProgressCopy.getLineItemStatuses().putIfAbsent(lineItem.getLineItemId(), LineItemStatus.of((String)lineItem.getLineItemId(), (String)lineItem.getSource(), (String)lineItem.getDealId(), (String)lineItem.getExtLineItemId(), (String)lineItem.getAccountId())));
        overallDeliveryProgressCopy.mergeFrom(this.currentDeliveryProgress);
        return this.deliveryProgressReportFactory.fromDeliveryProgress(overallDeliveryProgressCopy, ZonedDateTime.now(this.clock), true);
    }

    public void processAuctionEvent(AuctionContext auctionContext) {
        this.processAuctionEvent(auctionContext.getTxnLog(), auctionContext.getAccount().getId(), ZonedDateTime.now(this.clock));
    }

    protected void processAuctionEvent(TxnLog txnLog, String accountId, ZonedDateTime now) {
        HashMap planIdToTokenPriority = new HashMap();
        txnLog.lineItemSentToClientAsTopMatch().stream().map(arg_0 -> ((LineItemService)this.lineItemService).getLineItemById(arg_0)).filter(Objects::nonNull).filter(lineItem -> lineItem.getActiveDeliveryPlan() != null).forEach(lineItem -> this.incrementTokens(lineItem, now, planIdToTokenPriority));
        this.currentDeliveryProgress.recordTransactionLog(txnLog, planIdToTokenPriority, accountId);
    }

    public void processLineItemWinEvent(String lineItemId) {
        LineItem lineItem = this.lineItemService.getLineItemById(lineItemId);
        if (lineItem != null) {
            this.currentDeliveryProgress.recordWinEvent(lineItemId);
            this.criteriaLogManager.log(logger, lineItem.getAccountId(), lineItem.getSource(), lineItemId, (Object)"Win event for LineItem with id %s was recorded".formatted(lineItemId), arg_0 -> ((Logger)logger).debug(arg_0));
        }
    }

    public void processDeliveryProgressUpdateEvent() {
        this.lineItemService.getLineItems().stream().filter(lineItem -> lineItem.getActiveDeliveryPlan() != null).forEach(arg_0 -> this.mergePlanFromLineItem(arg_0));
    }

    private void mergePlanFromLineItem(LineItem lineItem) {
        this.overallDeliveryProgress.upsertPlanReferenceFromLineItem(lineItem);
        this.currentDeliveryProgress.mergePlanFromLineItem(lineItem);
    }

    public void createDeliveryProgressReports(ZonedDateTime now) {
        DeliveryProgress deliveryProgressToReport = this.currentDeliveryProgress;
        this.currentDeliveryProgress = DeliveryProgress.of((ZonedDateTime)now, (LineItemService)this.lineItemService);
        deliveryProgressToReport.setEndTimeStamp(now);
        deliveryProgressToReport.updateWithActiveLineItems(this.lineItemService.getLineItems());
        this.overallDeliveryProgress.mergeFrom(deliveryProgressToReport);
        this.deliveryStatsService.addDeliveryProgress(deliveryProgressToReport, this.overallDeliveryProgress.getLineItemStatuses());
        this.overallDeliveryProgress.cleanLineItemStatuses(now, this.lineItemStatusTtl, this.deliveryProgressProperties.getCachedPlansNumber());
    }

    public void invalidateLineItemsByIds(List<String> lineItemIds) {
        this.overallDeliveryProgress.getLineItemStatuses().entrySet().removeIf(stringLineItemEntry -> lineItemIds.contains(stringLineItemEntry.getKey()));
        this.currentDeliveryProgress.getLineItemStatuses().entrySet().removeIf(stringLineItemEntry -> lineItemIds.contains(stringLineItemEntry.getKey()));
    }

    public void invalidateLineItems() {
        this.overallDeliveryProgress.getLineItemStatuses().clear();
        this.currentDeliveryProgress.getLineItemStatuses().clear();
    }

    protected void incrementTokens(LineItem lineItem, ZonedDateTime now, Map<String, Integer> planIdToTokenPriority) {
        Integer classPriority = lineItem.incSpentToken(now);
        if (classPriority != null) {
            planIdToTokenPriority.put(lineItem.getActiveDeliveryPlan().getPlanId(), classPriority);
        }
    }

    public LineItemStatusReport getLineItemStatusReport(String lineItemId) {
        LineItem lineItem = this.lineItemService.getLineItemById(lineItemId);
        if (lineItem == null) {
            throw new PreBidException("LineItem not found: " + lineItemId);
        }
        DeliveryPlan activeDeliveryPlan = lineItem.getActiveDeliveryPlan();
        if (activeDeliveryPlan == null) {
            return LineItemStatusReport.builder().lineItemId(lineItemId).build();
        }
        DeliverySchedule deliverySchedule = DeliveryProgressReportFactory.toDeliverySchedule((DeliveryPlan)activeDeliveryPlan);
        return LineItemStatusReport.builder().lineItemId(lineItemId).deliverySchedule(deliverySchedule).readyToServeTimestamp(lineItem.getReadyAt()).spentTokens(Long.valueOf(activeDeliveryPlan.getSpentTokens())).pacingFrequency(activeDeliveryPlan.getDeliveryRateInMilliseconds()).accountId(lineItem.getAccountId()).target(lineItem.getTargeting()).build();
    }
}

