/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.cache.model;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import org.prebid.server.cache.model.DebugHttpCall;

public final class DebugHttpCall {
    private static final DebugHttpCall EMPTY = DebugHttpCall.builder().build();
    private final String endpoint;
    private final String requestUri;
    private final String requestBody;
    private final Integer responseStatus;
    private final String responseBody;
    private final Map<String, List<String>> requestHeaders;
    private final Integer responseTimeMillis;

    public static DebugHttpCall empty() {
        return EMPTY;
    }

    @ConstructorProperties(value={"endpoint", "requestUri", "requestBody", "responseStatus", "responseBody", "requestHeaders", "responseTimeMillis"})
    DebugHttpCall(String endpoint, String requestUri, String requestBody, Integer responseStatus, String responseBody, Map<String, List<String>> requestHeaders, Integer responseTimeMillis) {
        this.endpoint = endpoint;
        this.requestUri = requestUri;
        this.requestBody = requestBody;
        this.responseStatus = responseStatus;
        this.responseBody = responseBody;
        this.requestHeaders = requestHeaders;
        this.responseTimeMillis = responseTimeMillis;
    }

    public static DebugHttpCallBuilder builder() {
        return new DebugHttpCallBuilder();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public Integer getResponseStatus() {
        return this.responseStatus;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    public Integer getResponseTimeMillis() {
        return this.responseTimeMillis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DebugHttpCall)) {
            return false;
        }
        DebugHttpCall other = (DebugHttpCall)o;
        Integer this$responseStatus = this.getResponseStatus();
        Integer other$responseStatus = other.getResponseStatus();
        if (this$responseStatus == null ? other$responseStatus != null : !((Object)this$responseStatus).equals(other$responseStatus)) {
            return false;
        }
        Integer this$responseTimeMillis = this.getResponseTimeMillis();
        Integer other$responseTimeMillis = other.getResponseTimeMillis();
        if (this$responseTimeMillis == null ? other$responseTimeMillis != null : !((Object)this$responseTimeMillis).equals(other$responseTimeMillis)) {
            return false;
        }
        String this$endpoint = this.getEndpoint();
        String other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$requestUri = this.getRequestUri();
        String other$requestUri = other.getRequestUri();
        if (this$requestUri == null ? other$requestUri != null : !this$requestUri.equals(other$requestUri)) {
            return false;
        }
        String this$requestBody = this.getRequestBody();
        String other$requestBody = other.getRequestBody();
        if (this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody)) {
            return false;
        }
        String this$responseBody = this.getResponseBody();
        String other$responseBody = other.getResponseBody();
        if (this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody)) {
            return false;
        }
        Map this$requestHeaders = this.getRequestHeaders();
        Map other$requestHeaders = other.getRequestHeaders();
        return !(this$requestHeaders == null ? other$requestHeaders != null : !((Object)this$requestHeaders).equals(other$requestHeaders));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $responseStatus = this.getResponseStatus();
        result = result * 59 + ($responseStatus == null ? 43 : ((Object)$responseStatus).hashCode());
        Integer $responseTimeMillis = this.getResponseTimeMillis();
        result = result * 59 + ($responseTimeMillis == null ? 43 : ((Object)$responseTimeMillis).hashCode());
        String $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $requestUri = this.getRequestUri();
        result = result * 59 + ($requestUri == null ? 43 : $requestUri.hashCode());
        String $requestBody = this.getRequestBody();
        result = result * 59 + ($requestBody == null ? 43 : $requestBody.hashCode());
        String $responseBody = this.getResponseBody();
        result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        Map $requestHeaders = this.getRequestHeaders();
        result = result * 59 + ($requestHeaders == null ? 43 : ((Object)$requestHeaders).hashCode());
        return result;
    }

    public String toString() {
        return "DebugHttpCall(endpoint=" + this.getEndpoint() + ", requestUri=" + this.getRequestUri() + ", requestBody=" + this.getRequestBody() + ", responseStatus=" + this.getResponseStatus() + ", responseBody=" + this.getResponseBody() + ", requestHeaders=" + this.getRequestHeaders() + ", responseTimeMillis=" + this.getResponseTimeMillis() + ")";
    }
}

