/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.visiblemeasures;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.visiblemeasures.model.VisibleMeasuresType;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.visiblemeasures.ExtImpVisibleMeasures;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class VisibleMeasuresBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpVisibleMeasures>> VISIBLE_MEASURES_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public VisibleMeasuresBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<HttpRequest> requests = new ArrayList<HttpRequest>();
        for (Imp imp : bidRequest.getImp()) {
            ExtImpVisibleMeasures extImpVisibleMeasures;
            try {
                extImpVisibleMeasures = this.parseImpExt(imp);
            }
            catch (PreBidException e) {
                return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
            }
            Imp updatedImp = this.updateImp(imp, extImpVisibleMeasures);
            BidRequest updatedBidRequest = VisibleMeasuresBidder.makeBidRequest((BidRequest)bidRequest, (Imp)updatedImp);
            requests.add(this.makeHttpRequest(updatedBidRequest));
        }
        return Result.withValues(requests);
    }

    private ExtImpVisibleMeasures parseImpExt(Imp imp) {
        try {
            return (ExtImpVisibleMeasures)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), VISIBLE_MEASURES_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private Imp updateImp(Imp imp, ExtImpVisibleMeasures extImpVisibleMeasures) {
        return imp.toBuilder().ext(this.resolveImpExt(extImpVisibleMeasures)).build();
    }

    private ObjectNode resolveImpExt(ExtImpVisibleMeasures extImpVisibleMeasures) {
        String placementId = extImpVisibleMeasures.getPlacementId();
        String endpointId = extImpVisibleMeasures.getEndpointId();
        VisibleMeasuresType type = (VisibleMeasuresType)ObjectUtils.defaultIfNull((Object)(StringUtils.isNotEmpty((CharSequence)placementId) ? VisibleMeasuresType.PUBLISHER : null), (Object)(StringUtils.isNotEmpty((CharSequence)endpointId) ? VisibleMeasuresType.NETWORK : null));
        ExtImpVisibleMeasures resolvedImpExtBidder = ExtImpVisibleMeasures.of((String)(type != null ? type.getValue() : ""), (String)(type == VisibleMeasuresType.PUBLISHER ? placementId : null), (String)(type == VisibleMeasuresType.NETWORK ? endpointId : null));
        return (ObjectNode)this.mapper.mapper().valueToTree((Object)ExtPrebid.of(null, (Object)resolvedImpExtBidder));
    }

    private static BidRequest makeBidRequest(BidRequest bidRequest, Imp imp) {
        return bidRequest.toBuilder().imp(Collections.singletonList(imp)).build();
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest outgoingRequest) {
        return BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper);
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)VisibleMeasuresBidder.extractBids((BidResponse)bidResponse, (BidRequest)((BidRequest)httpCall.getRequest().getPayload())));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)VisibleMeasuresBidder.getBidType((Bid)bid, (List)bidRequest.getImp()), (String)bidResponse.getCur())).filter(Objects::nonNull).toList();
    }

    private static BidType getBidType(Bid bid, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(bid.getImpid())) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        throw new PreBidException("Failed to find impression \"%s\"".formatted(bid.getImpid()));
    }
}

