/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.undertone;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.http.HttpMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.undertone.proto.UndertoneImpExt;
import org.prebid.server.bidder.undertone.proto.UndertoneRequestExt;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.undertone.ExtImpUndertone;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class UndertoneBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpUndertone>> UNDERTONE_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final int ADAPTER_ID = 3;
    private static final String VERSION = "1.0.0";
    private static final String GPID_FIELD = "gpid";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public UndertoneBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public final Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        if (!ObjectUtils.anyNotNull((Object[])new Object[]{bidRequest.getSite(), bidRequest.getApp()})) {
            return Result.withError((BidderError)BidderError.badInput((String)"invalid bidRequest: no App/Site objects"));
        }
        Map undertoneExtImpMap = this.getUndertoneExtImpMap(bidRequest);
        Integer publisherId = this.getPublisherId(undertoneExtImpMap);
        if (publisherId == null) {
            return Result.withError((BidderError)BidderError.badInput((String)"invalid bidRequest: no publisher-id"));
        }
        List imps = this.makeImps(bidRequest, undertoneExtImpMap);
        if (imps.isEmpty()) {
            return Result.withError((BidderError)BidderError.badInput((String)"invalid bidRequest: no valid imps"));
        }
        BidRequest undertoneBidRequest = this.makeBidRequest(bidRequest, publisherId.intValue(), imps);
        HttpRequest httpRequest = HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(HttpUtil.headers()).body(this.mapper.encodeToBytes((Object)undertoneBidRequest)).payload((Object)bidRequest).build();
        return Result.withValue((Object)httpRequest);
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)this.extractBids((BidRequest)httpCall.getRequest().getPayload(), bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private BidRequest makeBidRequest(BidRequest bidRequest, int publisherId, List<Imp> imps) {
        Publisher publisher = this.makePublisher(bidRequest.getSite(), bidRequest.getApp(), publisherId);
        BidRequest.BidRequestBuilder bidRequestBuilder = bidRequest.toBuilder().imp(imps).ext(this.makeReqExt());
        Site site = bidRequest.getSite();
        if (site != null) {
            bidRequestBuilder.site(site.toBuilder().publisher(publisher).build());
        } else {
            bidRequestBuilder.app(bidRequest.getApp().toBuilder().publisher(publisher).build());
        }
        return bidRequestBuilder.build();
    }

    private ExtRequest makeReqExt() {
        return (ExtRequest)this.mapper.fillExtension((FlexibleExtension)ExtRequest.empty(), (Object)UndertoneRequestExt.of((Integer)3, (String)"1.0.0"));
    }

    private Publisher makePublisher(Site site, App app, int publisherId) {
        Publisher publisher = site != null ? site.getPublisher() : app.getPublisher();
        Publisher.PublisherBuilder publisherBuilder = publisher == null ? Publisher.builder() : publisher.toBuilder();
        return publisherBuilder.id(String.valueOf(publisherId)).build();
    }

    private Integer getPublisherId(Map<String, ExtImpUndertone> extImpMap) {
        return extImpMap.values().stream().map(ExtImpUndertone::getPublisherId).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private List<Imp> makeImps(BidRequest bidRequest, Map<String, ExtImpUndertone> extImpMap) {
        return bidRequest.getImp().stream().filter(imp -> this.isValidImp(imp, (ExtImpUndertone)extImpMap.get(imp.getId()))).map(imp -> imp.toBuilder().tagid(((ExtImpUndertone)extImpMap.get(imp.getId())).getPlacementId().toString()).ext(this.getImpExt(imp.getExt())).build()).toList();
    }

    private Map<String, ExtImpUndertone> getUndertoneExtImpMap(BidRequest bidRequest) {
        return bidRequest.getImp().stream().collect(Collectors.toUnmodifiableMap(Imp::getId, imp -> (ExtImpUndertone)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), UNDERTONE_EXT_TYPE_REFERENCE)).getBidder()));
    }

    private boolean isValidImp(Imp imp, ExtImpUndertone extImpUndertone) {
        return imp != null && ObjectUtils.anyNotNull((Object[])new Object[]{imp.getVideo(), imp.getBanner()}) && extImpUndertone != null && extImpUndertone.getPlacementId() != null;
    }

    private ObjectNode getImpExt(ObjectNode impExt) {
        String gpid = UndertoneBidder.getGpid((ObjectNode)impExt);
        return gpid != null ? (ObjectNode)this.mapper.mapper().valueToTree((Object)UndertoneImpExt.of((String)gpid)) : null;
    }

    private static String getGpid(ObjectNode impExt) {
        JsonNode gpidNode = impExt.get("gpid");
        return gpidNode != null && gpidNode.isTextual() ? gpidNode.asText() : null;
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidRequest, bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        Map idImpMap = this.getIdImpMap(bidRequest);
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)this.getBidType(bid, idImpMap), (String)bidResponse.getCur())).toList();
    }

    private Map<String, Imp> getIdImpMap(BidRequest bidRequest) {
        return bidRequest.getImp().stream().collect(Collectors.groupingBy(Imp::getId)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, imps -> (Imp)((List)imps.getValue()).get(0)));
    }

    private BidType getBidType(Bid bid, Map<String, Imp> idImpMap) {
        Imp imp = idImpMap.get(bid.getImpid());
        if (imp == null || imp.getBanner() != null) {
            return BidType.banner;
        }
        if (imp.getVideo() != null) {
            return BidType.video;
        }
        return BidType.banner;
    }
}

