/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.telaria;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.telaria.model.TelariaRequestExt;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.telaria.ExtImpOutTelaria;
import org.prebid.server.proto.openrtb.ext.request.telaria.ExtImpTelaria;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class TelariaBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpTelaria>> TELARIA_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public TelariaBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        String seatCode;
        ExtImpTelaria extImp;
        try {
            TelariaBidder.validateImp((List)bidRequest.getImp());
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        String publisherId = TelariaBidder.getPublisherId((BidRequest)bidRequest);
        Imp modifyImp = (Imp)bidRequest.getImp().get(0);
        try {
            extImp = this.parseImpExt(modifyImp);
            seatCode = extImp.getSeatCode();
            modifyImp = this.updateImp(modifyImp, extImp, publisherId);
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        BidRequest outgoingRequest = this.updateBidRequest(bidRequest, extImp, seatCode, modifyImp);
        return Result.withValue((Object)this.makeHttpRequest(outgoingRequest));
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest bidRequest) {
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(TelariaBidder.headers((BidRequest)bidRequest)).payload((Object)bidRequest).body(this.mapper.encodeToBytes((Object)bidRequest)).build();
    }

    private BidRequest updateBidRequest(BidRequest bidRequest, ExtImpTelaria extImp, String seatCode, Imp modifyImp) {
        BidRequest.BidRequestBuilder bidRequestBuilder = bidRequest.toBuilder();
        if (bidRequest.getSite() != null) {
            bidRequestBuilder.site(TelariaBidder.modifySite((Site)bidRequest.getSite(), (String)seatCode));
        } else if (bidRequest.getApp() != null) {
            bidRequestBuilder.app(TelariaBidder.modifyApp((App)bidRequest.getApp(), (String)seatCode));
        }
        return bidRequestBuilder.ext(this.modifyExt(extImp)).imp(Collections.singletonList(modifyImp)).build();
    }

    private static void validateImp(List<Imp> imps) {
        boolean hasVideoObject = false;
        for (Imp imp : imps) {
            if (imp.getBanner() != null) {
                throw new PreBidException("Telaria: Banner not supported");
            }
            hasVideoObject = hasVideoObject || imp.getVideo() != null;
        }
        if (!hasVideoObject) {
            throw new PreBidException("Telaria: Only Supports Video");
        }
    }

    private static String getPublisherId(BidRequest bidRequest) {
        if (bidRequest.getSite() != null && bidRequest.getSite().getPublisher() != null) {
            return bidRequest.getSite().getPublisher().getId();
        }
        if (bidRequest.getApp() != null && bidRequest.getApp().getPublisher() != null) {
            return bidRequest.getApp().getPublisher().getId();
        }
        return "";
    }

    private ExtImpTelaria parseImpExt(Imp imp) {
        try {
            return (ExtImpTelaria)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), TELARIA_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
    }

    private Imp updateImp(Imp imp, ExtImpTelaria extImp, String publisherId) {
        if (StringUtils.isBlank((CharSequence)extImp.getSeatCode())) {
            throw new PreBidException("Telaria: Seat Code required");
        }
        return imp.toBuilder().tagid(extImp.getAdCode()).ext((ObjectNode)this.mapper.mapper().valueToTree((Object)ExtImpOutTelaria.of((String)imp.getTagid(), (String)publisherId))).build();
    }

    private ExtRequest modifyExt(ExtImpTelaria extImp) {
        return extImp != null ? (ExtRequest)this.mapper.fillExtension((FlexibleExtension)ExtRequest.empty(), (Object)TelariaRequestExt.of((ObjectNode)extImp.getExtra())) : null;
    }

    private static Site modifySite(Site site, String seatCode) {
        return site.toBuilder().publisher(TelariaBidder.createPublisher((Publisher)site.getPublisher(), (String)seatCode)).build();
    }

    private static App modifyApp(App app, String seatCode) {
        return app.toBuilder().publisher(TelariaBidder.createPublisher((Publisher)app.getPublisher(), (String)seatCode)).build();
    }

    private static Publisher createPublisher(Publisher publisher, String seatCode) {
        return publisher != null ? publisher.toBuilder().id(seatCode).build() : Publisher.builder().id(seatCode).build();
    }

    private static MultiMap headers(BidRequest bidRequest) {
        MultiMap headers = HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        Device device = bidRequest.getDevice();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.ACCEPT_LANGUAGE_HEADER, (CharSequence)device.getLanguage());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.DNT_HEADER, (CharSequence)Objects.toString(device.getDnt(), null));
        }
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)this.extractBids(bidResponse, bidRequest));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return TelariaBidder.bidsFromResponse((BidResponse)bidResponse, (BidRequest)bidRequest);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse, BidRequest bidRequest) {
        SeatBid firstSeatBid = (SeatBid)bidResponse.getSeatbid().get(0);
        List bids = firstSeatBid.getBid();
        List imps = bidRequest.getImp();
        if (CollectionUtils.isEmpty((Collection)bids)) {
            return Collections.emptyList();
        }
        return IntStream.range(0, bids.size()).filter(i -> bids.get(i) != null).filter(i -> i < imps.size()).mapToObj(i -> TelariaBidder.makeBidderBid((Bid)((Bid)bids.get(i)), (BidResponse)bidResponse, (Imp)((Imp)imps.get(i)))).toList();
    }

    private static BidderBid makeBidderBid(Bid bid, BidResponse bidResponse, Imp imp) {
        Bid modifyBid = bid.toBuilder().impid(imp.getId()).build();
        return BidderBid.of((Bid)modifyBid, (BidType)BidType.video, (String)bidResponse.getCur());
    }
}

