/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.stroeercore;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.stroeercore.model.StroeerCoreBid;
import org.prebid.server.bidder.stroeercore.model.StroeerCoreBidResponse;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.stroeercore.ExtImpStroeerCore;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class StroeerCoreBidder
implements Bidder<BidRequest> {
    private static final String BIDDER_CURRENCY = "EUR";
    private static final TypeReference<ExtPrebid<?, ExtImpStroeerCore>> STROEER_CORE_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;
    private final CurrencyConversionService currencyConversionService;

    public StroeerCoreBidder(String endpointUrl, JacksonMapper mapper, CurrencyConversionService currencyConversionService) {
        this.endpointUrl = HttpUtil.validateUrl((String)endpointUrl);
        this.mapper = Objects.requireNonNull(mapper);
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : bidRequest.getImp()) {
            Price price;
            ExtImpStroeerCore impExt;
            try {
                StroeerCoreBidder.validateImp((Imp)imp);
                impExt = this.parseImpExt(imp);
                StroeerCoreBidder.validateImpExt((ExtImpStroeerCore)impExt);
                price = this.convertBidFloor(bidRequest, imp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)"%s. Ignore imp id = %s.".formatted(e.getMessage(), imp.getId())));
                continue;
            }
            modifiedImps.add(StroeerCoreBidder.modifyImp((Imp)imp, (ExtImpStroeerCore)impExt, (Price)price));
        }
        if (modifiedImps.isEmpty()) {
            return Result.withErrors(errors);
        }
        BidRequest outgoingRequest = bidRequest.toBuilder().imp(modifiedImps).build();
        return this.createHttpRequests(errors, outgoingRequest);
    }

    private static void validateImp(Imp imp) {
        if (imp.getBanner() == null && imp.getVideo() == null) {
            throw new PreBidException("Expected banner or video impression");
        }
    }

    private ExtImpStroeerCore parseImpExt(Imp imp) {
        try {
            return (ExtImpStroeerCore)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), STROEER_CORE_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private static void validateImpExt(ExtImpStroeerCore impExt) {
        if (StringUtils.isBlank((CharSequence)impExt.getSlotId())) {
            throw new PreBidException("Custom param slot id (sid) is empty");
        }
    }

    private Price convertBidFloor(BidRequest bidRequest, Imp imp) {
        String bidFloorCurrency;
        BigDecimal bidFloor = imp.getBidfloor();
        if (!StroeerCoreBidder.shouldConvertBidFloor((BigDecimal)bidFloor, (String)(bidFloorCurrency = imp.getBidfloorcur()))) {
            return Price.of((String)bidFloorCurrency, (BigDecimal)bidFloor);
        }
        BigDecimal convertedBidFloor = this.currencyConversionService.convertCurrency(bidFloor, bidRequest, bidFloorCurrency, "EUR");
        return Price.of((String)"EUR", (BigDecimal)convertedBidFloor);
    }

    private Result<List<HttpRequest<BidRequest>>> createHttpRequests(List<BidderError> errors, BidRequest bidRequest) {
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest((BidRequest)bidRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper)), errors);
    }

    private static boolean shouldConvertBidFloor(BigDecimal bidFloor, String bidFloorCurrency) {
        return BidderUtil.isValidPrice((BigDecimal)bidFloor) && !StringUtils.equalsIgnoreCase((CharSequence)bidFloorCurrency, (CharSequence)"EUR");
    }

    private static Imp modifyImp(Imp imp, ExtImpStroeerCore impExt, Price price) {
        return imp.toBuilder().bidfloorcur(price.getCurrency()).bidfloor(price.getValue()).tagid(impExt.getSlotId()).build();
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            String body = httpCall.getResponse().getBody();
            StroeerCoreBidResponse bidResponse = (StroeerCoreBidResponse)this.mapper.decodeValue(body, StroeerCoreBidResponse.class);
            return Result.withValues((List)StroeerCoreBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (StroeerCoreBidResponse)bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, StroeerCoreBidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getBids())) {
            return Collections.emptyList();
        }
        return bidResponse.getBids().stream().filter(Objects::nonNull).map(stroeerCoreBid -> StroeerCoreBidder.toBidderBid((BidRequest)bidRequest, (StroeerCoreBid)stroeerCoreBid)).toList();
    }

    private static BidderBid toBidderBid(BidRequest bidRequest, StroeerCoreBid stroeercoreBid) {
        return BidderBid.of((Bid)Bid.builder().id(stroeercoreBid.getId()).impid(stroeercoreBid.getImpId()).w(stroeercoreBid.getWidth()).h(stroeercoreBid.getHeight()).price(stroeercoreBid.getCpm()).adm(stroeercoreBid.getAdMarkup()).crid(stroeercoreBid.getCreativeId()).build(), (BidType)StroeerCoreBidder.getBidType((String)stroeercoreBid.getImpId(), (List)bidRequest.getImp()), (String)"EUR");
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() == null) continue;
            return BidType.video;
        }
        return BidType.banner;
    }
}

