/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.richaudience;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.richaudience.ExtImpRichaudience;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class RichaudienceBidder
implements Bidder<BidRequest> {
    private static final int BID_TEST_REQUEST = 1;
    private static final String OPENRTB_VERSION = "2.5";
    private static final String DEVICE_IP = "11.222.33.44";
    private static final String DEFAULT_CURRENCY = "USD";
    private static final String HTTPS = "https";
    private static final String TAG_ID_KEY = "tagId";
    private static final TypeReference<ExtPrebid<?, ExtImpRichaudience>> RICHAUDIENCE_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public RichaudienceBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        try {
            RichaudienceBidder.validateRequest((BidRequest)request);
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        for (Imp imp : request.getImp()) {
            try {
                RichaudienceBidder.validateImp((Imp)imp);
                ExtImpRichaudience extImp = this.parseImpExt(imp);
                BidRequest modifiedBidRequest = RichaudienceBidder.makeRequest((BidRequest)request, (Imp)imp, (ExtImpRichaudience)extImp);
                httpRequests.add(this.makeHttpRequest(modifiedBidRequest, Collections.singleton(imp.getId())));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return httpRequests.isEmpty() ? Result.withErrors(errors) : Result.of(httpRequests, errors);
    }

    private static void validateRequest(BidRequest bidRequest) throws PreBidException {
        Device device = bidRequest.getDevice();
        if (device == null || StringUtils.isAllBlank((CharSequence[])new CharSequence[]{device.getIp(), device.getIpv6()})) {
            throw new PreBidException("Device IP is required.");
        }
    }

    private static void validateImp(Imp imp) throws PreBidException {
        if (imp.getBanner() != null && !RichaudienceBidder.isBannerSizesPresent((Banner)imp.getBanner())) {
            throw new PreBidException("Banner W/H/Format is required. ImpId: " + imp.getId());
        }
        if (imp.getVideo() != null && !RichaudienceBidder.isVideoSizesPresent((Video)imp.getVideo())) {
            throw new PreBidException("Video W and H are required. ImpId: " + imp.getId());
        }
    }

    private static boolean isBannerSizesPresent(Banner banner) {
        return ObjectUtils.anyNotNull((Object[])new Object[]{banner.getW(), banner.getH()}) || CollectionUtils.isNotEmpty((Collection)banner.getFormat());
    }

    private static boolean isVideoSizesPresent(Video video) {
        return video.getW() != null && video.getW() != 0 && video.getH() != null && video.getH() != 0;
    }

    private ExtImpRichaudience parseImpExt(Imp imp) throws PreBidException {
        try {
            return (ExtImpRichaudience)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), RICHAUDIENCE_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Invalid ext. Imp.Id: " + imp.getId());
        }
    }

    private static BidRequest makeRequest(BidRequest request, Imp imp, ExtImpRichaudience extImp) {
        Site originalSite = request.getSite();
        Optional urlOptional = RichaudienceBidder.extractUrl((Site)originalSite);
        boolean isSecure = urlOptional.map(URL::getProtocol).map("https"::equals).orElse(false);
        Imp modifiedImp = RichaudienceBidder.modifyImp((Imp)imp, (ExtImpRichaudience)extImp, (boolean)isSecure);
        Site modifiedSite = urlOptional.map(url -> RichaudienceBidder.modifySite((Site)originalSite, (String)imp.getTagid(), (URL)url)).orElseGet(() -> RichaudienceBidder.modifySite((Site)originalSite, (String)imp.getTagid()));
        App modifiedApp = RichaudienceBidder.modifyApp((App)request.getApp(), (String)imp.getTagid());
        boolean isTest = BooleanUtils.isTrue((Boolean)extImp.getTest());
        return request.toBuilder().imp(Collections.singletonList(modifiedImp)).site(modifiedSite).app(modifiedApp).test(isTest ? Integer.valueOf(1) : null).device(isTest ? request.getDevice().toBuilder().ip("11.222.33.44").build() : request.getDevice()).build();
    }

    private static Site modifySite(Site originalSite, String tagId, URL url) {
        return originalSite.toBuilder().keywords("tagId=" + tagId).domain(StringUtils.isBlank((CharSequence)originalSite.getDomain()) ? url.getHost() : originalSite.getDomain()).build();
    }

    private static Site modifySite(Site originalSite, String tagId) {
        return Optional.ofNullable(originalSite).map(site -> site.toBuilder().keywords("tagId=" + tagId).build()).orElse(originalSite);
    }

    private static App modifyApp(App originalApp, String tagId) {
        return Optional.ofNullable(originalApp).map(app -> app.toBuilder().keywords("tagId=" + tagId).build()).orElse(originalApp);
    }

    private static Optional<URL> extractUrl(Site site) {
        return Optional.ofNullable(site).map(Site::getPage).map(page -> {
            try {
                return new URL((String)page);
            }
            catch (MalformedURLException e) {
                return null;
            }
        });
    }

    private static Imp modifyImp(Imp imp, ExtImpRichaudience extImp, boolean isSecure) {
        String tagId = extImp.getPid();
        String extBidFloorCur = extImp.getBidFloorCur();
        String impBidFloorCur = imp.getBidfloorcur();
        String bidFloorCur = (String)StringUtils.defaultIfBlank((CharSequence)extBidFloorCur, (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)impBidFloorCur, (CharSequence)"USD")));
        return imp.toBuilder().secure(Integer.valueOf(BooleanUtils.toInteger((boolean)isSecure))).tagid((String)StringUtils.defaultIfBlank((CharSequence)tagId, (CharSequence)imp.getTagid())).bidfloorcur(bidFloorCur).build();
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest bidRequest, Set<String> impIds) {
        return HttpRequest.builder().method(HttpMethod.POST).headers(this.resolveHeaders()).impIds(impIds).uri(this.endpointUrl).body(this.mapper.encodeToBytes((Object)bidRequest)).payload((Object)bidRequest).build();
    }

    private MultiMap resolveHeaders() {
        return HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)this.extractBids(bidResponse, bidRequest));
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        Map impMap = bidRequest.getImp().stream().collect(Collectors.toMap(Imp::getId, Function.identity()));
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).flatMap(seatBid -> seatBid.getBid().stream()).filter(Objects::nonNull).filter(bid -> impMap.containsKey(bid.getImpid())).map(bid -> RichaudienceBidder.makeBid((BidResponse)bidResponse, (Map)impMap, (Bid)bid)).toList();
    }

    private static BidderBid makeBid(BidResponse bidResponse, Map<String, Imp> impMap, Bid bid) {
        Imp imp = impMap.get(bid.getImpid());
        BidType bidType = RichaudienceBidder.resolveBidType((Imp)imp);
        Bid.BidBuilder builder = bid.toBuilder();
        if (bidType == BidType.video) {
            builder.w(imp.getVideo().getW());
            builder.h(imp.getVideo().getH());
        }
        return BidderBid.of((Bid)builder.build(), (BidType)bidType, (String)bidResponse.getCur());
    }

    private static BidType resolveBidType(Imp imp) {
        if (imp.getVideo() != null) {
            return BidType.video;
        }
        return BidType.banner;
    }
}

